/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.net.URI;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.hadoop.fs.swift.http.RestClientBindings;
import org.apache.hadoop.fs.swift.util.SwiftUtils;

public final class SwiftObjectPath {
    private static final Pattern PATH_PART_PATTERN = Pattern.compile(".*/AUTH_\\w*/");
    private final String container;
    private final String object;
    private final String uriPath;

    public SwiftObjectPath(String container, String object) {
        if (object == null) {
            throw new IllegalArgumentException("object name can't be null");
        }
        this.container = container;
        this.object = URI.create(object).getPath();
        this.uriPath = this.buildUriPath();
    }

    public String getContainer() {
        return this.container;
    }

    public String getObject() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SwiftObjectPath)) {
            return false;
        }
        SwiftObjectPath that = (SwiftObjectPath)o;
        return this.toUriPath().equals(that.toUriPath());
    }

    public int hashCode() {
        int result = this.container.hashCode();
        result = 31 * result + this.object.hashCode();
        return result;
    }

    private String buildUriPath() {
        return SwiftUtils.joinPaths(this.container, this.object);
    }

    public String toUriPath() {
        return this.uriPath;
    }

    public String toString() {
        return this.toUriPath();
    }

    public boolean objectMatches(String path) {
        return this.object.equals(path);
    }

    public boolean isEqualToOrParentOf(SwiftObjectPath possibleChild) {
        String childPath;
        String origPath = this.toUriPath();
        Object path = origPath;
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return (childPath = possibleChild.toUriPath()).equals(origPath) || childPath.startsWith((String)path);
    }

    public static SwiftObjectPath fromPath(URI uri, Path path) throws SwiftConfigurationException {
        return SwiftObjectPath.fromPath(uri, path, false);
    }

    public static SwiftObjectPath fromPath(URI uri, Path path, boolean addTrailingSlash) throws SwiftConfigurationException {
        String container;
        Object url = path.toUri().getPath().replaceAll(PATH_PART_PATTERN.pattern(), "");
        if (addTrailingSlash && !((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        if ((container = uri.getHost()) == null) {
            container = "";
        } else if (container.contains(".")) {
            container = RestClientBindings.extractContainerName(container);
        }
        return new SwiftObjectPath(container, (String)url);
    }
}

