/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;

public class SimpleUdpClient {
    protected final String host;
    protected final int port;
    protected final XDR request;
    protected final boolean oneShot;
    protected final DatagramSocket clientSocket;

    public SimpleUdpClient(String host, int port, XDR request, DatagramSocket clientSocket) {
        this(host, port, request, true, clientSocket);
    }

    public SimpleUdpClient(String host, int port, XDR request, Boolean oneShot, DatagramSocket clientSocket) {
        this.host = host;
        this.port = port;
        this.request = request;
        this.oneShot = oneShot;
        this.clientSocket = clientSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        InetAddress IPAddress = InetAddress.getByName(this.host);
        byte[] sendData = this.request.getBytes();
        byte[] receiveData = new byte[65535];
        DatagramSocket socket = this.clientSocket == null ? new DatagramSocket() : this.clientSocket;
        try {
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, this.port);
            socket.send(sendPacket);
            socket.setSoTimeout(500);
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            socket.receive(receivePacket);
            XDR xdr = new XDR(Arrays.copyOfRange(receiveData, 0, receivePacket.getLength()));
            RpcReply reply = RpcReply.read(xdr);
            if (reply.getState() != RpcReply.ReplyState.MSG_ACCEPTED) {
                throw new IOException("Request failed: " + reply.getState());
            }
        }
        finally {
            if (this.clientSocket == null) {
                socket.close();
            }
        }
    }
}

