/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.unmanagedamlauncher;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmanagedAMLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(UnmanagedAMLauncher.class);
    private Configuration conf;
    protected YarnClient rmClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private String amCmd = null;
    private String classpath = null;
    private volatile boolean amCompleted = false;
    private static final long AM_STATE_WAIT_TIMEOUT_MS = 10000L;

    public static void main(String[] args) {
        try {
            UnmanagedAMLauncher client = new UnmanagedAMLauncher();
            LOG.info("Initializing Client");
            boolean doRun = client.init(args);
            if (!doRun) {
                System.exit(0);
            }
            client.run();
        }
        catch (Throwable t) {
            LOG.error("Error running Client", t);
            System.exit(1);
        }
    }

    public UnmanagedAMLauncher(Configuration conf) throws Exception {
        this.conf = conf;
    }

    public UnmanagedAMLauncher() throws Exception {
        this(new Configuration());
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("Client", opts);
    }

    public boolean init(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption("appname", true, "Application Name. Default value - UnmanagedAM");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("queue", true, "RM Queue in which this application is to be submitted");
        opts.addOption("master_memory", true, "Amount of memory in MB to be requested to run the application master");
        opts.addOption("cmd", true, "command to start unmanaged AM (required)");
        opts.addOption("classpath", true, "additional classpath");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for client to initialize");
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        this.appName = cliParser.getOptionValue("appname", "UnmanagedAM");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        this.classpath = cliParser.getOptionValue("classpath", null);
        this.amCmd = cliParser.getOptionValue("cmd");
        if (this.amCmd == null) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No cmd specified for application master");
        }
        YarnConfiguration yarnConf = new YarnConfiguration(this.conf);
        this.rmClient = YarnClient.createYarnClient();
        this.rmClient.init((Configuration)yarnConf);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchAM(ApplicationAttemptId attemptId) throws IOException, YarnException {
        Credentials credentials = new Credentials();
        Token token = this.rmClient.getAMRMToken(attemptId.getApplicationId());
        credentials.addToken(token.getService(), token);
        File tokenFile = File.createTempFile("unmanagedAMRMToken", "", new File(System.getProperty("user.dir")));
        try {
            FileUtil.chmod((String)tokenFile.getAbsolutePath(), (String)"600");
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        tokenFile.deleteOnExit();
        DataOutputStream os = new DataOutputStream(new FileOutputStream(tokenFile, true));
        credentials.writeTokenStorageToStream(os);
        os.close();
        Map<String, String> env = System.getenv();
        ArrayList<CallSite> envAMList = new ArrayList<CallSite>();
        boolean setClasspath = false;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("CLASSPATH")) {
                setClasspath = true;
                if (this.classpath != null) {
                    value = (String)value + File.pathSeparator + this.classpath;
                }
            }
            envAMList.add((CallSite)((Object)(key + "=" + (String)value)));
        }
        if (!setClasspath && this.classpath != null) {
            envAMList.add((CallSite)((Object)("CLASSPATH=" + this.classpath)));
        }
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)0L);
        String hostname = InetAddress.getLocalHost().getHostName();
        envAMList.add((CallSite)((Object)(ApplicationConstants.Environment.CONTAINER_ID.name() + "=" + containerId)));
        envAMList.add((CallSite)((Object)(ApplicationConstants.Environment.NM_HOST.name() + "=" + hostname)));
        envAMList.add((CallSite)((Object)(ApplicationConstants.Environment.NM_HTTP_PORT.name() + "=0")));
        envAMList.add((CallSite)((Object)(ApplicationConstants.Environment.NM_PORT.name() + "=0")));
        envAMList.add((CallSite)((Object)(ApplicationConstants.Environment.LOCAL_DIRS.name() + "= /tmp")));
        envAMList.add((CallSite)((Object)("APP_SUBMIT_TIME_ENV=" + System.currentTimeMillis())));
        envAMList.add((CallSite)((Object)("HADOOP_TOKEN_FILE_LOCATION=" + tokenFile.getAbsolutePath())));
        String[] envAM = new String[envAMList.size()];
        Process amProc = Runtime.getRuntime().exec(this.amCmd, envAMList.toArray(envAM));
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(amProc.getErrorStream(), Charset.forName("UTF-8")));
        final BufferedReader inReader = new BufferedReader(new InputStreamReader(amProc.getInputStream(), Charset.forName("UTF-8")));
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        System.err.println(line);
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Error reading the error stream", (Throwable)ioe);
                }
            }
        };
        Thread outThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = inReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        System.out.println(line);
                        line = inReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Error reading the out stream", (Throwable)ioe);
                }
            }
        };
        try {
            errThread.start();
            outThread.start();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            int exitCode = amProc.waitFor();
            LOG.info("AM process exited with value: " + exitCode);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.amCompleted = true;
        }
        try {
            errThread.join();
            outThread.join();
            errReader.close();
            inReader.close();
        }
        catch (InterruptedException ie) {
            LOG.info("ShellExecutor: Interrupted while reading the error/out stream", (Throwable)ie);
        }
        catch (IOException ioe) {
            LOG.warn("Error while closing the error/out stream", (Throwable)ioe);
        }
        amProc.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() throws IOException, YarnException {
        LOG.info("Starting Client");
        this.rmClient.start();
        try {
            boolean success;
            LOG.info("Setting up application submission context for ASM");
            ApplicationSubmissionContext appContext = this.rmClient.createApplication().getApplicationSubmissionContext();
            ApplicationId appId = appContext.getApplicationId();
            appContext.setApplicationName(this.appName);
            Priority pri = (Priority)Records.newRecord(Priority.class);
            pri.setPriority(this.amPriority);
            appContext.setPriority(pri);
            appContext.setQueue(this.amQueue);
            ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            appContext.setAMContainerSpec(amContainer);
            appContext.setUnmanagedAM(true);
            LOG.info("Setting unmanaged AM");
            LOG.info("Submitting application to ASM");
            this.rmClient.submitApplication(appContext);
            ApplicationReport appReport = this.monitorApplication(appId, EnumSet.of(YarnApplicationState.ACCEPTED, YarnApplicationState.KILLED, YarnApplicationState.FAILED, YarnApplicationState.FINISHED));
            if (appReport.getYarnApplicationState() == YarnApplicationState.ACCEPTED) {
                ApplicationAttemptReport attemptReport = this.monitorCurrentAppAttempt(appId, YarnApplicationAttemptState.LAUNCHED);
                ApplicationAttemptId attemptId = attemptReport.getApplicationAttemptId();
                LOG.info("Launching AM with application attempt id " + attemptId);
                this.launchAM(attemptId);
                appReport = this.monitorApplication(appId, EnumSet.of(YarnApplicationState.KILLED, YarnApplicationState.FAILED, YarnApplicationState.FINISHED));
            }
            YarnApplicationState appState = appReport.getYarnApplicationState();
            FinalApplicationStatus appStatus = appReport.getFinalApplicationStatus();
            LOG.info("App ended with state: " + appReport.getYarnApplicationState() + " and status: " + appStatus);
            if (YarnApplicationState.FINISHED == appState && FinalApplicationStatus.SUCCEEDED == appStatus) {
                LOG.info("Application has completed successfully.");
                success = true;
            } else {
                LOG.info("Application did finished unsuccessfully. YarnState=" + appState.toString() + ", FinalStatus=" + appStatus.toString());
                success = false;
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.rmClient.stop();
        }
    }

    private ApplicationAttemptReport monitorCurrentAppAttempt(ApplicationId appId, YarnApplicationAttemptState attemptState) throws YarnException, IOException {
        long startTime = System.currentTimeMillis();
        ApplicationAttemptId attemptId = null;
        do {
            if (attemptId == null) {
                attemptId = this.rmClient.getApplicationReport(appId).getCurrentApplicationAttemptId();
            }
            ApplicationAttemptReport attemptReport = null;
            if (attemptId != null && attemptState.equals((Object)(attemptReport = this.rmClient.getApplicationAttemptReport(attemptId)).getYarnApplicationAttemptState())) {
                return attemptReport;
            }
            LOG.info("Current attempt state of " + appId + " is " + (Serializable)((Object)(attemptReport == null ? " N/A " : attemptReport.getYarnApplicationAttemptState())) + ", waiting for current attempt to reach " + attemptState);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for current attempt of " + appId + " to reach " + attemptState);
            }
        } while (System.currentTimeMillis() - startTime <= 10000L);
        String errmsg = "Timeout for waiting current attempt of " + appId + " to reach " + attemptState;
        LOG.error(errmsg);
        throw new RuntimeException(errmsg);
    }

    private ApplicationReport monitorApplication(ApplicationId appId, Set<YarnApplicationState> finalState) throws YarnException, IOException {
        YarnApplicationState state2;
        long foundAMCompletedTime = 0L;
        StringBuilder expectedFinalState = new StringBuilder();
        boolean first = true;
        for (YarnApplicationState state2 : finalState) {
            if (first) {
                first = false;
                expectedFinalState.append(state2.name());
                continue;
            }
            expectedFinalState.append("," + state2.name());
        }
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread sleep in monitoring loop interrupted");
            }
            ApplicationReport report = this.rmClient.getApplicationReport(appId);
            LOG.info("Got application report from ASM for, appId=" + appId.getId() + ", appAttemptId=" + report.getCurrentApplicationAttemptId() + ", clientToAMToken=" + report.getClientToAMToken() + ", appDiagnostics=" + report.getDiagnostics() + ", appMasterHost=" + report.getHost() + ", appQueue=" + report.getQueue() + ", appMasterRpcPort=" + report.getRpcPort() + ", appStartTime=" + report.getStartTime() + ", yarnAppState=" + report.getYarnApplicationState().toString() + ", distributedFinalState=" + report.getFinalApplicationStatus().toString() + ", appTrackingUrl=" + report.getTrackingUrl() + ", appUser=" + report.getUser());
            state2 = report.getYarnApplicationState();
            if (finalState.contains(state2)) {
                return report;
            }
            if (!this.amCompleted) continue;
            if (foundAMCompletedTime == 0L) {
                foundAMCompletedTime = System.currentTimeMillis();
                continue;
            }
            if (System.currentTimeMillis() - foundAMCompletedTime > 10000L) break;
        }
        LOG.warn("Waited 10 seconds after process completed for AppReport to reach desired final state. Not waiting anymore.CurrentState = " + state2 + ", ExpectedStates = " + expectedFinalState.toString());
        throw new RuntimeException("Failed to receive final expected state in ApplicationReport, CurrentState=" + state2 + ", ExpectedStates=" + expectedFinalState.toString());
    }
}

