/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.RequestHedgingProxyProvider;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestRequestHedgingProxyProvider {
    private Configuration conf;
    private URI nnUri;
    private String ns;

    @Before
    public void setup() throws URISyntaxException {
        this.ns = "mycluster-" + Time.monotonicNow();
        this.nnUri = new URI("hdfs://" + this.ns);
        this.conf = new Configuration();
        this.conf.set("dfs.nameservices", this.ns);
        this.conf.set("dfs.ha.namenodes." + this.ns, "nn1,nn2");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn1", "machine1.foo.bar:8020");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn2", "machine2.foo.bar:8020");
    }

    @Test
    public void testHedgingWhenOneFails() throws Exception {
        NamenodeProtocols goodMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)goodMock.getStats()).thenReturn((Object)new long[]{1L});
        NamenodeProtocols badMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, NamenodeProtocols.class, this.createFactory(goodMock, badMock));
        long[] stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        ((NamenodeProtocols)Mockito.verify((Object)badMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)goodMock)).getStats();
    }

    @Test
    public void testHedgingWhenOneIsSlow() throws Exception {
        NamenodeProtocols goodMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(1000L);
                return new long[]{1L};
            }
        });
        NamenodeProtocols badMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, NamenodeProtocols.class, this.createFactory(goodMock, badMock));
        long[] stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        ((NamenodeProtocols)Mockito.verify((Object)badMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)goodMock)).getStats();
    }

    @Test
    public void testHedgingWhenBothFail() throws Exception {
        NamenodeProtocols badMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        NamenodeProtocols worseMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)worseMock.getStats()).thenThrow(new Throwable[]{new IOException("Worse mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, NamenodeProtocols.class, this.createFactory(badMock, worseMock));
        try {
            ((NamenodeProtocols)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since both namenodes throw IOException !!");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MultiException));
        }
        ((NamenodeProtocols)Mockito.verify((Object)badMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)worseMock)).getStats();
    }

    @Test
    public void testPerformFailover() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final int[] isGood = new int[]{1};
        NamenodeProtocols goodMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 1) {
                    Thread.sleep(1000L);
                    return new long[]{1L};
                }
                throw new IOException("Was Good mock !!");
            }
        });
        NamenodeProtocols badMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 2) {
                    Thread.sleep(1000L);
                    return new long[]{2L};
                }
                throw new IOException("Bad mock !!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, NamenodeProtocols.class, this.createFactory(goodMock, badMock));
        long[] stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Assert.assertEquals((long)2L, (long)counter.get());
        ((NamenodeProtocols)Mockito.verify((Object)badMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)goodMock)).getStats();
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{badMock});
        Assert.assertEquals((long)3L, (long)counter.get());
        isGood[0] = 2;
        try {
            ((NamenodeProtocols)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)4L, (long)counter.get());
        provider.performFailover((Object)((NamenodeProtocols)provider.getProxy().proxy));
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)5L, (long)counter.get());
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)6L, (long)counter.get());
        isGood[0] = 1;
        try {
            ((NamenodeProtocols)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)7L, (long)counter.get());
        provider.performFailover((Object)((NamenodeProtocols)provider.getProxy().proxy));
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
    }

    @Test
    public void testPerformFailoverWith3Proxies() throws Exception {
        this.conf.set("dfs.ha.namenodes." + this.ns, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn3", "machine3.foo.bar:8020");
        final AtomicInteger counter = new AtomicInteger(0);
        final int[] isGood = new int[]{1};
        NamenodeProtocols goodMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 1) {
                    Thread.sleep(1000L);
                    return new long[]{1L};
                }
                throw new IOException("Was Good mock !!");
            }
        });
        NamenodeProtocols badMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 2) {
                    Thread.sleep(1000L);
                    return new long[]{2L};
                }
                throw new IOException("Bad mock !!");
            }
        });
        NamenodeProtocols worseMock = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        Mockito.when((Object)worseMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 3) {
                    Thread.sleep(1000L);
                    return new long[]{3L};
                }
                throw new IOException("Worse mock !!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, NamenodeProtocols.class, this.createFactory(goodMock, badMock, worseMock));
        long[] stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Assert.assertEquals((long)3L, (long)counter.get());
        ((NamenodeProtocols)Mockito.verify((Object)badMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)goodMock)).getStats();
        ((NamenodeProtocols)Mockito.verify((Object)worseMock)).getStats();
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{badMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{worseMock});
        Assert.assertEquals((long)4L, (long)counter.get());
        isGood[0] = 2;
        try {
            ((NamenodeProtocols)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)5L, (long)counter.get());
        provider.performFailover((Object)((NamenodeProtocols)provider.getProxy().proxy));
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)7L, (long)counter.get());
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)8L, (long)counter.get());
        isGood[0] = 3;
        try {
            ((NamenodeProtocols)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)9L, (long)counter.get());
        provider.performFailover((Object)((NamenodeProtocols)provider.getProxy().proxy));
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)stats[0]);
        Assert.assertEquals((long)11L, (long)counter.get());
        stats = ((NamenodeProtocols)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)stats[0]);
        Assert.assertEquals((long)12L, (long)counter.get());
    }

    private ConfiguredFailoverProxyProvider.ProxyFactory<NamenodeProtocols> createFactory(NamenodeProtocols ... protos) {
        final Iterator iterator = Lists.newArrayList((Object[])protos).iterator();
        return new ConfiguredFailoverProxyProvider.ProxyFactory<NamenodeProtocols>(){

            public NamenodeProtocols createProxy(Configuration conf, InetSocketAddress nnAddr, Class<NamenodeProtocols> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
                return (NamenodeProtocols)iterator.next();
            }
        };
    }
}

