/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestEditLogTailer {
    private static final String DIR_PREFIX = "/dir";
    private static final int DIRS_TO_MAKE = 20;
    static final long SLEEP_TIME = 1000L;
    static final long NN_LAG_TIMEOUT = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTailer() throws IOException, InterruptedException, ServiceFailedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        cluster.waitActive();
        cluster.transitionToActive(0);
        NameNode nn1 = cluster.getNameNode(0);
        NameNode nn2 = cluster.getNameNode(1);
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                NameNodeAdapter.mkdirs(nn1, TestEditLogTailer.getDirPath(i), new PermissionStatus("test", "test", new FsPermission(493)), true);
            }
            HATestUtil.waitForStandbyToCatchUp(nn1, nn2);
            for (i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(nn2, TestEditLogTailer.getDirPath(i), false).isDir());
            }
            for (i = 10; i < 20; ++i) {
                NameNodeAdapter.mkdirs(nn1, TestEditLogTailer.getDirPath(i), new PermissionStatus("test", "test", new FsPermission(493)), true);
            }
            HATestUtil.waitForStandbyToCatchUp(nn1, nn2);
            for (i = 10; i < 20; ++i) {
                Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(nn2, TestEditLogTailer.getDirPath(i), false).isDir());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testNN0TriggersLogRolls() throws Exception {
        TestEditLogTailer.testStandbyTriggersLogRolls(0);
    }

    @Test
    public void testNN1TriggersLogRolls() throws Exception {
        TestEditLogTailer.testStandbyTriggersLogRolls(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testStandbyTriggersLogRolls(int activeIndex) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.log-roll.period", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(10031)).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(10032)));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        try {
            cluster.transitionToActive(activeIndex);
            TestEditLogTailer.waitForLogRollInSharedDir(cluster, 3L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static String getDirPath(int suffix) {
        return DIR_PREFIX + suffix;
    }

    private static void waitForLogRollInSharedDir(MiniDFSCluster cluster, long startTxId) throws Exception {
        URI sharedUri = cluster.getSharedEditsDir(0, 1);
        File sharedDir = new File(sharedUri.getPath(), "current");
        final File expectedLog = new File(sharedDir, NNStorage.getInProgressEditsFileName((long)startTxId));
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return expectedLog.exists();
            }
        }, (int)100, (int)10000);
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSImage.LOG, (Level)Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)FSEditLog.LOG, (Level)Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)EditLogTailer.LOG, (Level)Level.DEBUG);
    }
}

