/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.BestEffortLongFile;
import org.apache.hadoop.hdfs.util.PersistentLongFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSUpgradeWithHA {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSUpgradeWithHA.class);
    private Configuration conf;

    @Before
    public void createConfiguration() {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("ipc.client.connection.maxidletime", 0);
    }

    private static void assertCTimesEqual(MiniDFSCluster cluster) {
        long nn1CTime = cluster.getNamesystem(0).getFSImage().getStorage().getCTime();
        long nn2CTime = cluster.getNamesystem(1).getFSImage().getStorage().getCTime();
        Assert.assertEquals((long)nn1CTime, (long)nn2CTime);
    }

    private static void checkClusterPreviousDirExistence(MiniDFSCluster cluster, boolean shouldExist) {
        for (int i = 0; i < 2; ++i) {
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, i, shouldExist);
        }
    }

    private static void checkNnPreviousDirExistence(MiniDFSCluster cluster, int index, boolean shouldExist) {
        Collection<URI> nameDirs = cluster.getNameDirs(index);
        for (URI nnDir : nameDirs) {
            TestDFSUpgradeWithHA.checkPreviousDirExistence(new File(nnDir), shouldExist);
        }
    }

    private static void checkJnPreviousDirExistence(MiniQJMHACluster jnCluster, boolean shouldExist) throws IOException {
        for (int i = 0; i < 3; ++i) {
            TestDFSUpgradeWithHA.checkPreviousDirExistence(jnCluster.getJournalCluster().getJournalDir(i, "ns1"), shouldExist);
        }
        if (shouldExist) {
            TestDFSUpgradeWithHA.assertEpochFilesCopied(jnCluster);
        }
    }

    private static void assertEpochFilesCopied(MiniQJMHACluster jnCluster) throws IOException {
        for (int i = 0; i < 3; ++i) {
            File journalDir = jnCluster.getJournalCluster().getJournalDir(i, "ns1");
            File currDir = new File(journalDir, "current");
            File prevDir = new File(journalDir, "previous");
            for (String fileName : new String[]{"last-promised-epoch", "last-writer-epoch"}) {
                File prevFile = new File(prevDir, fileName);
                if (!prevFile.exists()) continue;
                PersistentLongFile prevLongFile = new PersistentLongFile(prevFile, -10L);
                PersistentLongFile currLongFile = new PersistentLongFile(new File(currDir, fileName), -11L);
                Assert.assertTrue((String)("Value in " + fileName + " has decreased on upgrade in " + journalDir), (prevLongFile.get() <= currLongFile.get() ? 1 : 0) != 0);
            }
        }
    }

    private static void checkPreviousDirExistence(File rootDir, boolean shouldExist) {
        File previousDir = new File(rootDir, "previous");
        if (shouldExist) {
            Assert.assertTrue((String)(previousDir + " does not exist"), (boolean)previousDir.exists());
        } else {
            Assert.assertFalse((String)(previousDir + " does exist"), (boolean)previousDir.exists());
        }
    }

    private void runFinalizeCommand(MiniDFSCluster cluster) throws IOException {
        HATestUtil.setFailoverConfigurations(cluster, this.conf);
        new DFSAdmin(this.conf).finalizeUpgrade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotFinalizeIfNoActive() throws IOException, URISyntaxException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
            File sharedDir = new File(cluster.getSharedEditsDir(0, 1));
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, false);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, true);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster.restartNameNode(0, false, new String[0]);
            cluster.transitionToActive(0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo3")));
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo4")));
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            cluster.transitionToStandby(1);
            try {
                this.runFinalizeCommand(cluster);
                Assert.fail((String)"Should not have been able to finalize upgrade with no NN active");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"Cannot finalize with no NameNode active", (Throwable)ioe);
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfsUpgrade() throws IOException, URISyntaxException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
            File sharedDir = new File(cluster.getSharedEditsDir(0, 1));
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, false);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, true);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster.restartNameNode(0, false, new String[0]);
            cluster.transitionToActive(0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo3")));
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo4")));
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private long getCommittedTxnIdValue(MiniQJMHACluster qjCluster) throws IOException {
        Journal journal1 = qjCluster.getJournalCluster().getJournalNode(0).getOrCreateJournal("ns1");
        BestEffortLongFile committedTxnId = (BestEffortLongFile)Whitebox.getInternalState((Object)journal1, (String)"committedTxnId");
        return committedTxnId != null ? committedTxnId.get() : -12345L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeWithJournalNodes() throws IOException, URISyntaxException {
        MiniQJMHACluster qjCluster = null;
        FileSystem fs = null;
        try {
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder(this.conf);
            builder.getDfsBuilder().numDataNodes(0);
            qjCluster = builder.build();
            MiniDFSCluster cluster = qjCluster.getDfsCluster();
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            long cidBeforeUpgrade = this.getCommittedTxnIdValue(qjCluster);
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, true);
            Assert.assertTrue((cidBeforeUpgrade <= this.getCommittedTxnIdValue(qjCluster) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster.restartNameNode(0, false, new String[0]);
            cluster.transitionToActive(0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo3")));
            Assert.assertTrue((this.getCommittedTxnIdValue(qjCluster) > cidBeforeUpgrade ? 1 : 0) != 0);
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo4")));
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (qjCluster != null) {
                qjCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeWithJournalNodes() throws IOException, URISyntaxException {
        MiniQJMHACluster qjCluster = null;
        FileSystem fs = null;
        try {
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder(this.conf);
            builder.getDfsBuilder().numDataNodes(0);
            qjCluster = builder.build();
            MiniDFSCluster cluster = qjCluster.getDfsCluster();
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            long cidBeforeUpgrade = this.getCommittedTxnIdValue(qjCluster);
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            Assert.assertTrue((cidBeforeUpgrade <= this.getCommittedTxnIdValue(qjCluster) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, true);
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            long cidDuringUpgrade = this.getCommittedTxnIdValue(qjCluster);
            Assert.assertTrue((cidDuringUpgrade > cidBeforeUpgrade ? 1 : 0) != 0);
            this.runFinalizeCommand(cluster);
            Assert.assertEquals((long)cidDuringUpgrade, (long)this.getCommittedTxnIdValue(qjCluster));
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (qjCluster != null) {
                qjCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeFromSecondNameNodeWithJournalNodes() throws IOException, URISyntaxException {
        MiniQJMHACluster qjCluster = null;
        FileSystem fs = null;
        try {
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder(this.conf);
            builder.getDfsBuilder().numDataNodes(0);
            qjCluster = builder.build();
            MiniDFSCluster cluster = qjCluster.getDfsCluster();
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, true);
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            this.runFinalizeCommand(cluster);
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (qjCluster != null) {
                qjCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartingWithUpgradeInProgressSucceeds() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
            for (int i = 0; i < 2; ++i) {
                for (URI uri : cluster.getNameDirs(i)) {
                    File prevTmp = new File(new File(uri), "previous.tmp");
                    LOG.info("creating previous tmp dir: " + prevTmp);
                    Assert.assertTrue((boolean)prevTmp.mkdirs());
                }
            }
            cluster.restartNameNodes();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackWithNfs() throws Exception {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
            File sharedDir = new File(cluster.getSharedEditsDir(0, 1));
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, false);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, true);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, true);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            Collection<URI> nn1NameDirs = cluster.getNameDirs(0);
            cluster.shutdown();
            this.conf.setStrings("dfs.namenode.name.dir", new String[]{Joiner.on((String)",").join(nn1NameDirs)});
            NameNode.doRollback((Configuration)this.conf, (boolean)false);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, false);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackWithJournalNodes() throws IOException, URISyntaxException {
        MiniQJMHACluster qjCluster = null;
        FileSystem fs = null;
        try {
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder(this.conf);
            builder.getDfsBuilder().numDataNodes(0);
            qjCluster = builder.build();
            MiniDFSCluster cluster = qjCluster.getDfsCluster();
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            long cidBeforeUpgrade = this.getCommittedTxnIdValue(qjCluster);
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, true);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            long cidDuringUpgrade = this.getCommittedTxnIdValue(qjCluster);
            Assert.assertTrue((cidDuringUpgrade > cidBeforeUpgrade ? 1 : 0) != 0);
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)cluster.getConfiguration(1));
            Assert.assertEquals((long)0L, (long)rc);
            cluster.restartNameNode(1);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, true);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            Collection<URI> nn1NameDirs = cluster.getNameDirs(0);
            cluster.shutdown();
            this.conf.setStrings("dfs.namenode.name.dir", new String[]{Joiner.on((String)",").join(nn1NameDirs)});
            NameNode.doRollback((Configuration)this.conf, (boolean)false);
            long cidAfterRollback = this.getCommittedTxnIdValue(qjCluster);
            Assert.assertTrue((cidBeforeUpgrade < cidAfterRollback ? 1 : 0) != 0);
            Assert.assertTrue((cidDuringUpgrade > cidAfterRollback ? 1 : 0) != 0);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, false);
            TestDFSUpgradeWithHA.checkJnPreviousDirExistence(qjCluster, false);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (qjCluster != null) {
                qjCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotUpgradeSecondNameNode() throws IOException, URISyntaxException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
            File sharedDir = new File(cluster.getSharedEditsDir(0, 1));
            TestDFSUpgradeWithHA.checkClusterPreviousDirExistence(cluster, false);
            TestDFSUpgradeWithHA.assertCTimesEqual(cluster);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, false);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo1")));
            cluster.shutdownNameNode(1);
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            cluster.restartNameNode(0, false, new String[0]);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 0, true);
            TestDFSUpgradeWithHA.checkNnPreviousDirExistence(cluster, 1, false);
            TestDFSUpgradeWithHA.checkPreviousDirExistence(sharedDir, true);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo2")));
            cluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster.restartNameNode(0, false, new String[0]);
            cluster.transitionToActive(0);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/foo3")));
            cluster.getNameNodeInfos()[1].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
            try {
                cluster.restartNameNode(1, false, new String[0]);
                Assert.fail((String)"Should not have been able to start second NN with -upgrade");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"It looks like the shared log is already being upgraded", (Throwable)ioe);
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

