/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.AvailableSpaceVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.TestRoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAvailableSpaceVolumeChoosingPolicy {
    private static final int RANDOMIZED_ITERATIONS = 10000;
    private static final float RANDOMIZED_ERROR_PERCENT = 0.05f;
    private static final long RANDOMIZED_ALLOWED_ERROR = 500L;

    private static void initPolicy(VolumeChoosingPolicy<FsVolumeSpi> policy, float preferencePercent) {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.available-space-volume-choosing-policy.balanced-space-threshold", 0x100000L);
        conf.setFloat("dfs.datanode.available-space-volume-choosing-policy.balanced-space-preference-fraction", preferencePercent);
        ((Configurable)policy).setConf(conf);
    }

    @Test(timeout=60000L)
    public void testRR() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        TestRoundRobinVolumeChoosingPolicy.testRR((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    @Test(timeout=60000L)
    public void testRRPolicyExceptionMessage() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = new AvailableSpaceVolumeChoosingPolicy();
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        TestRoundRobinVolumeChoosingPolicy.testRRPolicyExceptionMessage((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    @Test(timeout=60000L)
    public void testTwoUnbalancedVolumes() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)0x100000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)0x300000L);
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
    }

    @Test(timeout=60000L)
    public void testThreeUnbalancedVolumes() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)0x100000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)0x300000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(2)).getAvailable()).thenReturn((Object)0x300000L);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(2), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(2), (Object)policy.chooseVolume(volumes, 100L));
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 0.0f);
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
    }

    @Test(timeout=60000L)
    public void testFourUnbalancedVolumes() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)0x100000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)0x100001L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(2)).getAvailable()).thenReturn((Object)0x300000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(3)).getAvailable()).thenReturn((Object)0x300000L);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        Assert.assertEquals(volumes.get(2), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(3), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(2), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(3), (Object)policy.chooseVolume(volumes, 100L));
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 0.0f);
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 100L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
    }

    @Test(timeout=60000L)
    public void testNotEnoughSpaceOnSelectedVolume() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)0x100000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)0x300000L);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 0.0f);
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0x200000L));
    }

    @Test(timeout=60000L)
    public void testAvailableSpaceChanges() throws Exception {
        AvailableSpaceVolumeChoosingPolicy policy = (AvailableSpaceVolumeChoosingPolicy)ReflectionUtils.newInstance(AvailableSpaceVolumeChoosingPolicy.class, null);
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, 1.0f);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)0x100000L);
        volumes.add((FsVolumeSpi)Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)0x300000L).thenReturn((Object)0x300000L).thenReturn((Object)0x300000L).thenReturn((Object)0x100000L);
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 100L));
    }

    @Test(timeout=60000L)
    public void randomizedTest1() throws Exception {
        this.doRandomizedTest(0.75f, 1, 1);
    }

    @Test(timeout=60000L)
    public void randomizedTest2() throws Exception {
        this.doRandomizedTest(0.75f, 5, 1);
    }

    @Test(timeout=60000L)
    public void randomizedTest3() throws Exception {
        this.doRandomizedTest(0.75f, 1, 5);
    }

    @Test(timeout=60000L)
    public void randomizedTest4() throws Exception {
        this.doRandomizedTest(0.9f, 5, 1);
    }

    public void doRandomizedTest(float preferencePercent, int lowSpaceVolumes, int highSpaceVolumes) throws Exception {
        FsVolumeSpi volume;
        int i;
        Random random = new Random(123L);
        AvailableSpaceVolumeChoosingPolicy policy = new AvailableSpaceVolumeChoosingPolicy(random);
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>();
        for (i = 0; i < lowSpaceVolumes; ++i) {
            volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
            Mockito.when((Object)volume.getAvailable()).thenReturn((Object)0x100000L);
            volumes.add(volume);
        }
        for (i = 0; i < highSpaceVolumes; ++i) {
            volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
            Mockito.when((Object)volume.getAvailable()).thenReturn((Object)0x300000L);
            volumes.add(volume);
        }
        TestAvailableSpaceVolumeChoosingPolicy.initPolicy((VolumeChoosingPolicy<FsVolumeSpi>)policy, preferencePercent);
        long lowAvailableSpaceVolumeSelected = 0L;
        long highAvailableSpaceVolumeSelected = 0L;
        block2: for (int i2 = 0; i2 < 10000; ++i2) {
            FsVolumeSpi volume2 = policy.chooseVolume(volumes, 100L);
            for (int j = 0; j < volumes.size(); ++j) {
                if (volume2 == volumes.get(j) && j == 0) {
                    ++lowAvailableSpaceVolumeSelected;
                }
                if (volume2 != volumes.get(j) || j != lowSpaceVolumes) continue;
                ++highAvailableSpaceVolumeSelected;
                continue block2;
            }
        }
        float expectedSelectionRatio = preferencePercent / (1.0f - preferencePercent);
        GenericTestUtils.assertValueNear((long)((long)((float)lowAvailableSpaceVolumeSelected * expectedSelectionRatio)), (long)highAvailableSpaceVolumeSelected, (long)500L);
    }
}

