/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBPOfferService {
    private static final String FAKE_BPID = "fake bpid";
    private static final String FAKE_CLUSTERID = "fake cluster";
    protected static final Logger LOG = LoggerFactory.getLogger(TestBPOfferService.class);
    private static final ExtendedBlock FAKE_BLOCK = new ExtendedBlock("fake bpid", 12345L);
    private static final File TEST_BUILD_DATA = PathUtils.getTestDir(TestBPOfferService.class);
    private long firstCallTime = 0L;
    private long secondCallTime = 0L;
    private DatanodeProtocolClientSideTranslatorPB mockNN1;
    private DatanodeProtocolClientSideTranslatorPB mockNN2;
    private final NNHAStatusHeartbeat[] mockHaStatuses = new NNHAStatusHeartbeat[2];
    private final int[] heartbeatCounts = new int[2];
    private DataNode mockDn;
    private FsDatasetSpi<?> mockFSDataset;

    @Before
    public void setupMocks() throws Exception {
        this.mockNN1 = this.setupNNMock(0);
        this.mockNN2 = this.setupNNMock(1);
        this.mockDn = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)this.mockDn)).shouldRun();
        Configuration conf = new Configuration();
        File dnDataDir = new File(new File(TEST_BUILD_DATA, "dfs"), "data");
        conf.set("dfs.datanode.data.dir", dnDataDir.toURI().toString());
        ((DataNode)Mockito.doReturn((Object)conf).when((Object)this.mockDn)).getConf();
        ((DataNode)Mockito.doReturn((Object)new DNConf(conf)).when((Object)this.mockDn)).getDnConf();
        ((DataNode)Mockito.doReturn((Object)DataNodeMetrics.create((Configuration)conf, (String)"fake dn")).when((Object)this.mockDn)).getMetrics();
        this.mockFSDataset = (FsDatasetSpi)Mockito.spy((Object)new SimulatedFSDataset(null, conf));
        this.mockFSDataset.addBlockPool(FAKE_BPID, conf);
        ((DataNode)Mockito.doReturn(this.mockFSDataset).when((Object)this.mockDn)).getFSDataset();
    }

    private DatanodeProtocolClientSideTranslatorPB setupNNMock(int nnIdx) throws Exception {
        DatanodeProtocolClientSideTranslatorPB mock = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doReturn((Object)new NamespaceInfo(1, FAKE_CLUSTERID, FAKE_BPID, 0L)).when((Object)mock)).versionRequest();
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doReturn((Object)DFSTestUtil.getLocalDatanodeRegistration()).when((Object)mock)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new HeartbeatAnswer(nnIdx)).when((Object)mock)).sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class));
        this.mockHaStatuses[nnIdx] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.STANDBY, 0L);
        return mock;
    }

    @Test
    public void testBasicFunctionality() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)this.mockNN1)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)this.mockNN2)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
            this.waitForBlockReport(this.mockNN1);
            this.waitForBlockReport(this.mockNN2);
            bpos.notifyNamenodeReceivedBlock(FAKE_BLOCK, "", "");
            ReceivedDeletedBlockInfo[] ret = this.waitForBlockReceived(FAKE_BLOCK, this.mockNN1);
            Assert.assertEquals((long)1L, (long)ret.length);
            Assert.assertEquals((Object)FAKE_BLOCK.getLocalBlock(), (Object)ret[0].getBlock());
            ret = this.waitForBlockReceived(FAKE_BLOCK, this.mockNN2);
            Assert.assertEquals((long)1L, (long)ret.length);
            Assert.assertEquals((Object)FAKE_BLOCK.getLocalBlock(), (Object)ret[0].getBlock());
        }
        finally {
            bpos.stop();
        }
    }

    @Test
    public void testIgnoreDeletionsFromNonActive() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doReturn((Object)new BlockCommand(2, FAKE_BPID, new Block[]{FAKE_BLOCK.getLocalBlock()})).when((Object)this.mockNN2)).blockReport((DatanodeRegistration)Mockito.anyObject(), (String)Mockito.eq((Object)FAKE_BPID), (StorageBlockReport[])Mockito.anyObject(), (BlockReportContext)Mockito.anyObject());
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            this.waitForBlockReport(this.mockNN1);
            this.waitForBlockReport(this.mockNN2);
        }
        finally {
            bpos.stop();
        }
        ((FsDatasetSpi)Mockito.verify(this.mockFSDataset, (VerificationMode)Mockito.never())).invalidate((String)Mockito.eq((Object)FAKE_BPID), (Block[])Mockito.anyObject());
    }

    @Test
    public void testNNsFromDifferentClusters() throws Exception {
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doReturn((Object)new NamespaceInfo(1, "fake foreign cluster", FAKE_BPID, 0L)).when((Object)this.mockNN1)).versionRequest();
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForOneToFail(bpos);
        }
        finally {
            bpos.stop();
        }
    }

    @Test
    public void testPickActiveNameNode() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            Assert.assertNull((Object)bpos.getActiveNN());
            this.mockHaStatuses[0] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN1, (Object)bpos.getActiveNN());
            this.mockHaStatuses[1] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 2L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN2, (Object)bpos.getActiveNN());
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN2, (Object)bpos.getActiveNN());
            this.mockHaStatuses[1] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.STANDBY, 2L);
            bpos.triggerHeartbeatForTests();
            Assert.assertNull((Object)bpos.getActiveNN());
            this.mockHaStatuses[0] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 3L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN1, (Object)bpos.getActiveNN());
        }
        finally {
            bpos.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBPInitErrorHandling() throws Exception {
        final DataNode mockDn = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)mockDn)).shouldRun();
        Configuration conf = new Configuration();
        File dnDataDir = new File(new File(TEST_BUILD_DATA, "testBPInitErrorHandling"), "data");
        conf.set("dfs.datanode.data.dir", dnDataDir.toURI().toString());
        ((DataNode)Mockito.doReturn((Object)conf).when((Object)mockDn)).getConf();
        ((DataNode)Mockito.doReturn((Object)new DNConf(conf)).when((Object)mockDn)).getDnConf();
        ((DataNode)Mockito.doReturn((Object)DataNodeMetrics.create((Configuration)conf, (String)"fake dn")).when((Object)mockDn)).getMetrics();
        final AtomicInteger count = new AtomicInteger();
        ((DataNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (count.getAndIncrement() == 0) {
                    throw new IOException("faked initBlockPool exception");
                }
                ((DataNode)Mockito.doReturn(TestBPOfferService.this.mockFSDataset).when((Object)mockDn)).getFSDataset();
                return null;
            }
        }).when((Object)mockDn)).initBlockPool((BPOfferService)Mockito.any(BPOfferService.class));
        BPOfferService bpos = this.setupBPOSForNNs(mockDn, this.mockNN1, this.mockNN2);
        List actors = bpos.getBPServiceActors();
        Assert.assertEquals((long)2L, (long)actors.size());
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            this.waitForBlockReport(this.mockNN1, this.mockNN2);
        }
        finally {
            bpos.stop();
        }
    }

    private void waitForOneToFail(final BPOfferService bpos) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                List actors = bpos.getBPServiceActors();
                int failedcount = 0;
                for (BPServiceActor actor : actors) {
                    if (actor.isAlive()) continue;
                    ++failedcount;
                }
                return failedcount == 1;
            }
        }, (int)100, (int)10000);
    }

    private BPOfferService setupBPOSForNNs(DatanodeProtocolClientSideTranslatorPB ... nns) throws IOException {
        return this.setupBPOSForNNs(this.mockDn, nns);
    }

    private BPOfferService setupBPOSForNNs(DataNode mockDn, DatanodeProtocolClientSideTranslatorPB ... nns) throws IOException {
        LinkedHashMap nnMap = Maps.newLinkedHashMap();
        for (int port = 0; port < nns.length; ++port) {
            nnMap.put(new InetSocketAddress(port), nns[port]);
            ((DataNode)Mockito.doReturn((Object)nns[port]).when((Object)mockDn)).connectToNN((InetSocketAddress)Mockito.eq((Object)new InetSocketAddress(port)));
        }
        return new BPOfferService((List)Lists.newArrayList(nnMap.keySet()), mockDn);
    }

    private void waitForInitialization(final BPOfferService bpos) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return bpos.isAlive() && bpos.isInitialized();
            }
        }, (int)100, (int)10000);
    }

    private void waitForBlockReport(final DatanodeProtocolClientSideTranslatorPB mockNN) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)mockNN)).blockReport((DatanodeRegistration)Mockito.anyObject(), (String)Mockito.eq((Object)TestBPOfferService.FAKE_BPID), (StorageBlockReport[])Mockito.anyObject(), (BlockReportContext)Mockito.anyObject());
                    return true;
                }
                catch (Throwable t) {
                    LOG.info("waiting on block report: " + t.getMessage());
                    return false;
                }
            }
        }, (int)500, (int)10000);
    }

    private void waitForBlockReport(final DatanodeProtocolClientSideTranslatorPB mockNN1, final DatanodeProtocolClientSideTranslatorPB mockNN2) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return this.get(mockNN1) != false || this.get(mockNN2) != false;
            }

            private Boolean get(DatanodeProtocolClientSideTranslatorPB mockNN) {
                try {
                    ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)mockNN)).blockReport((DatanodeRegistration)Mockito.anyObject(), (String)Mockito.eq((Object)TestBPOfferService.FAKE_BPID), (StorageBlockReport[])Mockito.anyObject(), (BlockReportContext)Mockito.anyObject());
                    return true;
                }
                catch (Throwable t) {
                    LOG.info("waiting on block report: " + t.getMessage());
                    return false;
                }
            }
        }, (int)500, (int)10000);
    }

    private ReceivedDeletedBlockInfo[] waitForBlockReceived(ExtendedBlock fakeBlock, final DatanodeProtocolClientSideTranslatorPB mockNN) throws Exception {
        final String fakeBlockPoolId = fakeBlock.getBlockPoolId();
        final ArgumentCaptor captor = ArgumentCaptor.forClass(StorageReceivedDeletedBlocks[].class);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)mockNN)).blockReceivedAndDeleted((DatanodeRegistration)Mockito.anyObject(), (String)Mockito.eq((Object)fakeBlockPoolId), (StorageReceivedDeletedBlocks[])captor.capture());
                    return true;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }, (int)100, (int)10000);
        return ((StorageReceivedDeletedBlocks[])captor.getValue())[0].getBlocks();
    }

    private void setTimeForSynchronousBPOSCalls() {
        if (this.firstCallTime == 0L) {
            this.firstCallTime = Time.now();
        } else {
            this.secondCallTime = Time.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReportBadBlockWhenStandbyNNTimesOut() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            Assert.assertNull((Object)bpos.getActiveNN());
            this.mockHaStatuses[0] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN1, (Object)bpos.getActiveNN());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new BPOfferServiceSynchronousCallAnswer(0)).when((Object)this.mockNN1)).reportBadBlocks((LocatedBlock[])Mockito.any(LocatedBlock[].class));
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new BPOfferServiceSynchronousCallAnswer(1)).when((Object)this.mockNN2)).reportBadBlocks((LocatedBlock[])Mockito.any(LocatedBlock[].class));
            bpos.reportBadBlocks(FAKE_BLOCK, this.mockFSDataset.getVolume(FAKE_BLOCK).getStorageID(), this.mockFSDataset.getVolume(FAKE_BLOCK).getStorageType());
            bpos.reportBadBlocks(FAKE_BLOCK, this.mockFSDataset.getVolume(FAKE_BLOCK).getStorageID(), this.mockFSDataset.getVolume(FAKE_BLOCK).getStorageType());
            Thread.sleep(10000L);
            long difference = this.secondCallTime - this.firstCallTime;
            Assert.assertTrue((String)"Active namenode reportBadBlock processing should be independent of standby namenode reportBadBlock processing ", (difference < 5000L ? 1 : 0) != 0);
        }
        finally {
            bpos.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrySendErrorReportWhenStandbyNNTimesOut() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            Assert.assertNull((Object)bpos.getActiveNN());
            this.mockHaStatuses[0] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN1, (Object)bpos.getActiveNN());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new BPOfferServiceSynchronousCallAnswer(0)).when((Object)this.mockNN1)).errorReport((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), Mockito.anyInt(), Mockito.anyString());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new BPOfferServiceSynchronousCallAnswer(1)).when((Object)this.mockNN2)).errorReport((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), Mockito.anyInt(), Mockito.anyString());
            String errorString = "Can't send invalid block " + FAKE_BLOCK;
            bpos.trySendErrorReport(2, errorString);
            bpos.trySendErrorReport(2, errorString);
            Thread.sleep(10000L);
            long difference = this.secondCallTime - this.firstCallTime;
            Assert.assertTrue((String)"Active namenode trySendErrorReport processing should be independent of standby namenode trySendErrorReport processing ", (difference < 5000L ? 1 : 0) != 0);
        }
        finally {
            bpos.stop();
        }
    }

    @Test
    public void testTrySendErrorReportWhenNNThrowsIOException() throws Exception {
        BPOfferService bpos = this.setupBPOSForNNs(this.mockNN1, this.mockNN2);
        bpos.start();
        try {
            this.waitForInitialization(bpos);
            Assert.assertNull((Object)bpos.getActiveNN());
            this.mockHaStatuses[0] = new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L);
            bpos.triggerHeartbeatForTests();
            Assert.assertSame((Object)this.mockNN1, (Object)bpos.getActiveNN());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    if (TestBPOfferService.this.firstCallTime == 0L) {
                        TestBPOfferService.this.firstCallTime = Time.now();
                        throw new IOException();
                    }
                    TestBPOfferService.this.secondCallTime = Time.now();
                    return null;
                }
            }).when((Object)this.mockNN1)).errorReport((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), Mockito.anyInt(), Mockito.anyString());
            String errorString = "Can't send invalid block " + FAKE_BLOCK;
            bpos.trySendErrorReport(2, errorString);
            Thread.sleep(10000L);
            Assert.assertTrue((String)"Active namenode didn't add the report back to the queue when errorReport threw IOException", (this.secondCallTime != 0L ? 1 : 0) != 0);
        }
        finally {
            bpos.stop();
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.TRACE);
    }

    private class BPOfferServiceSynchronousCallAnswer
    implements Answer<Void> {
        private final int nnIdx;

        public BPOfferServiceSynchronousCallAnswer(int nnIdx) {
            this.nnIdx = nnIdx;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            if (this.nnIdx == 0) {
                TestBPOfferService.this.setTimeForSynchronousBPOSCalls();
            } else {
                Thread.sleep(5000L);
            }
            return null;
        }
    }

    private class HeartbeatAnswer
    implements Answer<HeartbeatResponse> {
        private final int nnIdx;

        public HeartbeatAnswer(int nnIdx) {
            this.nnIdx = nnIdx;
        }

        public HeartbeatResponse answer(InvocationOnMock invocation) throws Throwable {
            int n = this.nnIdx;
            TestBPOfferService.this.heartbeatCounts[n] = TestBPOfferService.this.heartbeatCounts[n] + 1;
            return new HeartbeatResponse(new DatanodeCommand[0], TestBPOfferService.this.mockHaStatuses[this.nnIdx], null);
        }
    }
}

