/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraOutputFormatWithCRC;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeraSortWithCRC
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(TeraSortWithCRC.class);

    public int run(String[] args) throws Exception {
        LOG.info("starting");
        Job job = Job.getInstance((Configuration)this.getConf());
        Path inputDir = new Path(args[0]);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem(job.getConfiguration()));
        Path partitionFile = new Path(inputDir, "_partition.lst");
        URI partitionUri = new URI(partitionFile.toString() + "#_partition.lst");
        TeraInputFormatWithCRC.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.setJobName("TeraSortWithCRC");
        job.setJarByClass(TeraSortWithCRC.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(TeraInputFormatWithCRC.class);
        job.setOutputFormatClass(TeraOutputFormatWithCRC.class);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TeraInputFormatWithCRC.writePartitionFile((JobContext)job, partitionFile);
        job.addCacheFile(partitionUri);
        DistributedCache.createSymlink((Configuration)job.getConfiguration());
        job.getConfiguration().setInt("dfs.replication", 1);
        TeraOutputFormatWithCRC.setFinalSync((JobContext)job, true);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        LOG.info("done");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraSortWithCRC(), (String[])args);
        System.exit(res);
    }

    static class TotalOrderPartitioner
    extends Partitioner<Text, Text>
    implements Configurable {
        private TrieNode trie;
        private Text[] splitPoints;
        private Configuration conf;

        private static Text[] readPartitions(FileSystem fs, Path p, Configuration conf) throws IOException {
            int reduces = conf.getInt("mapreduce.job.reduces", 1);
            Text[] result = new Text[reduces - 1];
            FSDataInputStream reader = fs.open(p);
            for (int i = 0; i < reduces - 1; ++i) {
                result[i] = new Text();
                result[i].readFields((DataInput)reader);
            }
            reader.close();
            return result;
        }

        private static TrieNode buildTrie(Text[] splits, int lower, int upper, Text prefix, int maxDepth) {
            int depth = prefix.getLength();
            if (depth >= maxDepth || lower == upper) {
                return new LeafTrieNode(depth, splits, lower, upper);
            }
            InnerTrieNode result = new InnerTrieNode(depth);
            Text trial = new Text(prefix);
            trial.append(new byte[1], 0, 1);
            int currentBound = lower;
            for (int ch = 0; ch < 255; ++ch) {
                trial.getBytes()[depth] = (byte)(ch + 1);
                lower = currentBound;
                while (currentBound < upper && splits[currentBound].compareTo((BinaryComparable)trial) < 0) {
                    ++currentBound;
                }
                trial.getBytes()[depth] = (byte)ch;
                result.child[ch] = TotalOrderPartitioner.buildTrie(splits, lower, currentBound, trial, maxDepth);
            }
            trial.getBytes()[depth] = 127;
            result.child[255] = TotalOrderPartitioner.buildTrie(splits, currentBound, upper, trial, maxDepth);
            return result;
        }

        public void configure(JobConf job) {
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
                Path partFile = new Path("_partition.lst");
                this.splitPoints = TotalOrderPartitioner.readPartitions((FileSystem)fs, partFile, (Configuration)job);
                this.trie = TotalOrderPartitioner.buildTrie(this.splitPoints, 0, this.splitPoints.length, new Text(), 2);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read paritions file", ie);
            }
        }

        public void setConf(Configuration conf) {
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                this.conf = conf;
                Path partFile = new Path("_partition.lst");
                this.splitPoints = TotalOrderPartitioner.readPartitions((FileSystem)fs, partFile, conf);
                this.trie = TotalOrderPartitioner.buildTrie(this.splitPoints, 0, this.splitPoints.length, new Text(), 2);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read partitions file", ie);
            }
        }

        public Configuration getConf() {
            return this.conf;
        }

        public int getPartition(Text key, Text value, int numPartitions) {
            return this.trie.findPartition(key);
        }

        static class LeafTrieNode
        extends TrieNode {
            int lower;
            int upper;
            Text[] splitPoints;

            LeafTrieNode(int level, Text[] splitPoints, int lower, int upper) {
                super(level);
                this.splitPoints = splitPoints;
                this.lower = lower;
                this.upper = upper;
            }

            @Override
            int findPartition(Text key) {
                for (int i = this.lower; i < this.upper; ++i) {
                    if (this.splitPoints[i].compareTo((BinaryComparable)key) < 0) continue;
                    return i;
                }
                return this.upper;
            }

            @Override
            void print(PrintStream strm) throws IOException {
                for (int i = 0; i < 2 * this.getLevel(); ++i) {
                    strm.print(' ');
                }
                strm.print(this.lower);
                strm.print(", ");
                strm.println(this.upper);
            }
        }

        static class InnerTrieNode
        extends TrieNode {
            private TrieNode[] child = new TrieNode[256];

            InnerTrieNode(int level) {
                super(level);
            }

            @Override
            int findPartition(Text key) {
                int level = this.getLevel();
                if (key.getLength() <= level) {
                    return this.child[0].findPartition(key);
                }
                return this.child[key.getBytes()[level] & 0xFF].findPartition(key);
            }

            void setChild(int idx, TrieNode child) {
                this.child[idx] = child;
            }

            @Override
            void print(PrintStream strm) throws IOException {
                for (int ch = 0; ch < 256; ++ch) {
                    for (int i = 0; i < 2 * this.getLevel(); ++i) {
                        strm.print(' ');
                    }
                    strm.print(ch);
                    strm.println(" ->");
                    if (this.child[ch] == null) continue;
                    this.child[ch].print(strm);
                }
            }
        }

        static abstract class TrieNode {
            private int level;

            TrieNode(int level) {
                this.level = level;
            }

            abstract int findPartition(Text var1);

            abstract void print(PrintStream var1) throws IOException;

            int getLevel() {
                return this.level;
            }
        }
    }
}

