/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreTestUtil {
    public static String getClasspathDir(Class klass) throws Exception {
        Object file = klass.getName();
        file = ((String)file).replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource((String)file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - ((String)file).length() - 1);
        return baseDir;
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days) throws CertificateException, IllegalStateException, OperatorCreationException, CertIOException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        KeyPair keyPair = pair;
        BouncyCastleFipsProvider bcProvider = new BouncyCastleFipsProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(dn);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        String signatureAlgorithm = "SHA256WithRSA";
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(true);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
        return cert;
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(1024);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveKeyStore(KeyStore ks, String filename, String password) throws GeneralSecurityException, IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    public static void createKeyStore(String filename, String password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createKeyStore(String filename, String password, String keyPassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setCertificateEntry(alias, cert);
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, String password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void cleanupSSLConfig(String keystoresDir, String sslConfDir) throws Exception {
        File f = new File(keystoresDir + "/clientKS.jks");
        f.delete();
        f = new File(keystoresDir + "/serverKS.jks");
        f.delete();
        f = new File(keystoresDir + "/trustKS.jks");
        f.delete();
        f = new File(sslConfDir + "/ssl-client.xml");
        f.delete();
        f = new File(sslConfDir + "/ssl-server.xml");
        f.delete();
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true);
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true, "");
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore, String excludeCiphers) throws Exception {
        String clientKS = keystoresDir + "/clientKS.jks";
        String clientPassword = "clientP";
        String serverKS = keystoresDir + "/serverKS.jks";
        String serverPassword = "serverP";
        String trustKS = null;
        String trustPassword = "trustP";
        File sslClientConfFile = new File(sslConfDir + "/ssl-client.xml");
        File sslServerConfFile = new File(sslConfDir + "/ssl-server.xml");
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        if (useClientCert) {
            KeyPair cKP = KeyStoreTestUtil.generateKeyPair("RSA");
            X509Certificate cCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=client", cKP, 30);
            KeyStoreTestUtil.createKeyStore(clientKS, clientPassword, "client", cKP.getPrivate(), cCert);
            certs.put("client", cCert);
        }
        KeyPair sKP = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", sKP, 30);
        KeyStoreTestUtil.createKeyStore(serverKS, serverPassword, "server", sKP.getPrivate(), sCert);
        certs.put("server", sCert);
        if (trustStore) {
            trustKS = keystoresDir + "/trustKS.jks";
            KeyStoreTestUtil.createTrustStore(trustKS, trustPassword, certs);
        }
        Configuration clientSSLConf = KeyStoreTestUtil.createClientSSLConfig(clientKS, clientPassword, clientPassword, trustKS, excludeCiphers);
        Configuration serverSSLConf = KeyStoreTestUtil.createServerSSLConfig(serverKS, serverPassword, serverPassword, trustKS, excludeCiphers);
        KeyStoreTestUtil.saveConfig(sslClientConfFile, clientSSLConf);
        KeyStoreTestUtil.saveConfig(sslServerConfFile, serverSSLConf);
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        conf.set("hadoop.ssl.client.conf", sslClientConfFile.getName());
        conf.set("hadoop.ssl.server.conf", sslServerConfFile.getName());
        conf.setBoolean("hadoop.ssl.require.client.cert", useClientCert);
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, "");
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS, String excludeCiphers) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, excludeCiphers);
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, "");
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS, String excludeCiphers) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, excludeCiphers);
    }

    private static Configuration createSSLConfig(SSLFactory.Mode mode, String keystore, String password, String keyPassword, String trustKS, String excludeCiphers) {
        String trustPassword = "trustP";
        Configuration sslConf = new Configuration(false);
        if (keystore != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.location"), keystore);
        }
        if (password != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.password"), password);
        }
        if (keyPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.keypassword"), keyPassword);
        }
        if (trustKS != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.location"), trustKS);
        }
        if (trustPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.password"), trustPassword);
        }
        if (null != excludeCiphers && !excludeCiphers.isEmpty()) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.exclude.cipher.list"), excludeCiphers);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        return sslConf;
    }

    public static void saveConfig(File file, Configuration conf) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            conf.writeXml((Writer)writer);
        }
    }

    public static void provisionPasswordsToCredentialProvider() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        try {
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), storepass);
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.keypassword"), keypass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

