/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.MockFileSystem;
import org.apache.hadoop.fs.shell.find.Print;
import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPrint0 {
    private FileSystem mockFs;

    @Before
    public void resetMock() throws IOException {
        this.mockFs = MockFileSystem.setup();
    }

    @Test(timeout=1000L)
    public void testPrint() throws IOException {
        Print.Print0 print = new Print.Print0();
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        FindOptions options = new FindOptions();
        options.setOut(out);
        print.setOptions(options);
        String filename = "/one/two/test";
        PathData item = new PathData(filename, this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)print.apply(item, -1));
        ((PrintStream)Mockito.verify((Object)out)).print(filename + "\u0000");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }
}

