/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemBasedConfigurationProvider
extends ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBasedConfigurationProvider.class);
    private FileSystem fs;
    private Path configDir;

    public synchronized InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws IOException, YarnException {
        Path filePath;
        if (name == null || name.isEmpty()) {
            throw new YarnException("Illegal argument! The parameter should not be null or empty");
        }
        if (YarnConfiguration.RM_CONFIGURATION_FILES.contains(name)) {
            filePath = new Path(this.configDir, name);
            if (!this.fs.exists(filePath)) {
                LOG.info(filePath + " not found");
                return null;
            }
        } else {
            filePath = new Path(name);
            if (!this.fs.exists(filePath)) {
                LOG.info(filePath + " not found");
                return null;
            }
        }
        return this.fs.open(filePath);
    }

    public synchronized void initInternal(Configuration bootstrapConf) throws Exception {
        this.configDir = new Path(bootstrapConf.get("yarn.resourcemanager.configuration.file-system-based-store", "/yarn/conf"));
        this.fs = this.configDir.getFileSystem(bootstrapConf);
        if (!this.fs.exists(this.configDir)) {
            this.fs.mkdirs(this.configDir);
        }
    }

    public synchronized void closeInternal() throws Exception {
        this.fs.close();
    }
}

