/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class AmFilterInitializer
extends FilterInitializer {
    private static final String FILTER_NAME = "AM_PROXY_FILTER";
    private static final String FILTER_CLASS = AmIpFilter.class.getCanonicalName();
    public static final String RM_HA_URLS = "RM_HA_URLS";

    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> params = new HashMap<String, String>();
        List proxies = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        StringBuilder sb = new StringBuilder();
        for (String proxy : proxies) {
            sb.append(proxy.split(":")[0]).append(",");
        }
        sb.setLength(sb.length() - 1);
        params.put("PROXY_HOSTS", sb.toString());
        String prefix = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
        String proxyBase = this.getApplicationWebProxyBase();
        sb = new StringBuilder();
        for (String proxy : proxies) {
            sb.append(prefix).append(proxy).append(proxyBase).append(",");
        }
        sb.setLength(sb.length() - 1);
        params.put("PROXY_URI_BASES", sb.toString());
        container.addFilter(FILTER_NAME, FILTER_CLASS, params);
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        Collection<String> rmIds = this.getRmIds((Configuration)yarnConf);
        if (rmIds != null) {
            ArrayList<String> urls = new ArrayList<String>();
            for (String rmId : rmIds) {
                String url = this.getUrlByRmId((Configuration)yarnConf, rmId);
                urls.add(url);
            }
            if (!urls.isEmpty()) {
                params.put(RM_HA_URLS, StringUtils.join((CharSequence)",", urls));
            }
        }
    }

    private Collection<String> getRmIds(Configuration conf) {
        return conf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
    }

    private String getUrlByRmId(Configuration conf, String rmId) {
        String addressPropertyPrefix = YarnConfiguration.useHttps((Configuration)conf) ? "yarn.resourcemanager.webapp.https.address" : "yarn.resourcemanager.webapp.address";
        String host = conf.get(HAUtil.addSuffix((String)addressPropertyPrefix, (String)rmId));
        return host;
    }

    @VisibleForTesting
    protected String getApplicationWebProxyBase() {
        return System.getenv("APPLICATION_WEB_PROXY_BASE");
    }
}

