/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityLevel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationActivity {
    private String childName = null;
    private String parentName = null;
    private Integer appPriority = null;
    private Integer requestPriority = null;
    private ActivityState state;
    private String diagnostic = null;
    private NodeId nodeId;
    private Long allocationRequestId;
    private ActivityLevel level;
    private static final Logger LOG = LoggerFactory.getLogger(AllocationActivity.class);

    public AllocationActivity(String parentName, String queueName, Integer priority, ActivityState state, String diagnostic, ActivityLevel level, NodeId nodeId, Long allocationRequestId) {
        this.childName = queueName;
        this.parentName = parentName;
        if (level != null) {
            this.level = level;
            switch (level) {
                case APP: {
                    this.appPriority = priority;
                    break;
                }
                case REQUEST: {
                    this.requestPriority = priority;
                    this.allocationRequestId = allocationRequestId;
                    break;
                }
                case NODE: {
                    this.nodeId = nodeId;
                    break;
                }
            }
        }
        this.state = state;
        this.diagnostic = diagnostic;
    }

    public ActivityNode createTreeNode() {
        return new ActivityNode(this.childName, this.parentName, this.level == ActivityLevel.APP ? this.appPriority : this.requestPriority, this.state, this.diagnostic, this.level, this.nodeId, this.allocationRequestId);
    }

    public String getName() {
        return this.childName;
    }

    public String getState() {
        return this.state.toString();
    }
}

