/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.Objects;

final class RntbdFramer {
    private RntbdFramer() {
    }

    static boolean canDecodePayload(ByteBuf in) {
        return RntbdFramer.canDecodePayload(in, in.readerIndex());
    }

    static boolean canDecodePayload(ByteBuf in, int start) {
        Objects.requireNonNull(in);
        int readerIndex = in.readerIndex();
        if (start < readerIndex) {
            throw new IllegalArgumentException("start < in.readerIndex()");
        }
        int offset = start - readerIndex;
        if (in.readableBytes() - offset < 4) {
            return false;
        }
        long length = in.getUnsignedIntLE(start);
        if (length > Integer.MAX_VALUE) {
            String reason = String.format("Payload frame length exceeds Integer.MAX_VALUE, %d: %d", Integer.MAX_VALUE, length);
            throw new CorruptedFrameException(reason);
        }
        return (long)(offset + 4) + length <= (long)in.readableBytes();
    }

    static boolean canDecodeHead(ByteBuf in) throws CorruptedFrameException {
        Objects.requireNonNull(in);
        if (in.readableBytes() < 24) {
            return false;
        }
        int start = in.readerIndex();
        long length = in.getUnsignedIntLE(start);
        if (length > Integer.MAX_VALUE) {
            String reason = String.format("Head frame length exceeds Integer.MAX_VALUE, %d: %d", Integer.MAX_VALUE, length);
            throw new CorruptedFrameException(reason);
        }
        if (length < 4L) {
            String reason = String.format("Head frame length is less than size of length field, %d: %d", 4, length);
            throw new CorruptedFrameException(reason);
        }
        return length <= (long)in.readableBytes();
    }
}

