/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import java.util.Calendar;
import java.util.Date;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.series.primitive.PrimitiveTimeSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class ImplicitTimeSeries
extends PrimitiveTimeSeries {
    private final CalendarDateUnit myResolution;
    private final CalendarDate myFirst;

    public ImplicitTimeSeries(Calendar aFirst, CalendarDateUnit aResolution, PrimitiveSeries aValueSeries) {
        super(aValueSeries);
        this.myFirst = CalendarDate.make(aFirst, aResolution);
        this.myResolution = aResolution;
    }

    public ImplicitTimeSeries(CalendarDate aFirst, CalendarDateUnit aResolution, PrimitiveSeries aValueSeries) {
        super(aValueSeries);
        this.myFirst = aFirst.filter(aResolution);
        this.myResolution = aResolution;
    }

    public ImplicitTimeSeries(Date aFirst, CalendarDateUnit aResolution, PrimitiveSeries aValueSeries) {
        super(aValueSeries);
        this.myFirst = CalendarDate.make(aFirst, aResolution);
        this.myResolution = aResolution;
    }

    @Override
    public ImplicitTimeSeries add(double addend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.add(addend));
    }

    @Override
    public final ImplicitTimeSeries add(PrimitiveSeries addend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.add(addend));
    }

    @Override
    public ImplicitTimeSeries copy() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.copy());
    }

    @Override
    public final ImplicitTimeSeries differences() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.differences());
    }

    @Override
    public final ImplicitTimeSeries differences(int period) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.differences(period));
    }

    @Override
    public ImplicitTimeSeries divide(double divisor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.divide(divisor));
    }

    @Override
    public final ImplicitTimeSeries divide(PrimitiveSeries divisor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.divide(divisor));
    }

    @Override
    public PrimitiveSeries exp() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.exp());
    }

    @Override
    public final CalendarDate first() {
        return this.myFirst;
    }

    @Override
    public long getAverageStepSize() {
        return this.myResolution.size();
    }

    @Override
    public final long[] keys() {
        long[] retVal = new long[this.size()];
        CalendarDate tmpKey = this.myFirst;
        retVal[0] = tmpKey.millis;
        for (int t = 1; t < retVal.length; ++t) {
            tmpKey = tmpKey.step(this.myResolution);
            retVal[t] = tmpKey.millis;
        }
        return retVal;
    }

    @Override
    public final CalendarDate last() {
        return this.myFirst.step(this.size() - 1, this.myResolution);
    }

    @Override
    public PrimitiveSeries log() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.log());
    }

    @Override
    public final ImplicitTimeSeries multiply(double aFactor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.multiply(aFactor));
    }

    @Override
    public ImplicitTimeSeries multiply(PrimitiveSeries multiplicand) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.multiply(multiplicand));
    }

    @Override
    public final ImplicitTimeSeries quotients() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.quotients());
    }

    @Override
    public final ImplicitTimeSeries quotients(int period) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.quotients(period));
    }

    public final CalendarDateUnit resolution() {
        return this.myResolution;
    }

    @Override
    public final ImplicitTimeSeries runningProduct(double initialValue) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.runningProduct(initialValue));
    }

    @Override
    public final ImplicitTimeSeries runningSum(double initialValue) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.runningSum(initialValue));
    }

    @Override
    public ImplicitTimeSeries subtract(double subtrahend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.subtract(subtrahend));
    }

    @Override
    public ImplicitTimeSeries subtract(PrimitiveSeries subtrahend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.subtract(subtrahend));
    }
}

