/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnAppUtil {
    public static final Logger LOG = LoggerFactory.getLogger(YarnAppUtil.class);
    public static final FsPermission APP_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission APP_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    public static final FsPermission RM_SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission RM_STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)511);
    private static final String MAPR_TICKET_FILE = "ticketfile";
    private static final LocalDirAllocator dirAllocator = new LocalDirAllocator("yarn.nodemanager.local-dirs");

    public static Path getRMStagingDir(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        String rmStagingDir = conf.get("yarn.resourcemanager.staging", YarnDefaultProperties.DEFAULT_RM_STAGING_DIR);
        return YarnAppUtil.getRMDirWithVolume(appIdStr, fs, conf, rmStagingDir, true);
    }

    public static Path getRMStagingDirForWrite(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        String rmStagingDir = conf.get("yarn.resourcemanager.staging", YarnDefaultProperties.DEFAULT_RM_STAGING_DIR);
        return YarnAppUtil.getRMDirWithVolume(appIdStr, fs, conf, rmStagingDir, false);
    }

    public static Path getRMSystemDirForWrite(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        String rmSystemDir = conf.get("yarn.resourcemanager.system", YarnDefaultProperties.DEFAULT_RM_SYSTEM_DIR);
        return YarnAppUtil.getRMDirWithVolume(appIdStr, fs, conf, rmSystemDir, false);
    }

    public static Path getRMSystemDir(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        String rmSystemDir = conf.get("yarn.resourcemanager.system", YarnDefaultProperties.DEFAULT_RM_SYSTEM_DIR);
        return YarnAppUtil.getRMDirWithVolume(appIdStr, fs, conf, rmSystemDir, true);
    }

    public static Path getRMDirWithVolume(String appIdStr, FileSystem fs, Configuration conf, String rmSubDir, boolean lookUpAllDirs) throws IOException {
        Path allRMDirsPath;
        Path result;
        boolean useVolumeSharding;
        String rmDir = conf.get("yarn.resourcemanager.dir", YarnDefaultProperties.DEFAULT_RM_DIR);
        Path rmDirPath = new Path(rmDir);
        Path rmSubDirPath = new Path(rmSubDir);
        String dirSuffix = rmSubDirPath.toString().substring(rmDirPath.toString().length());
        boolean bl = useVolumeSharding = conf.getBoolean("yarn.resourcemanager.dir.volume-sharding.enabled", false) && rmSubDirPath.toUri().getRawPath().startsWith(rmDirPath.toUri().getRawPath());
        if (useVolumeSharding) {
            int volumeCount = conf.getInt("yarn.resourcemanager.dir.volume-count", 4);
            int rmVolumeName = Math.abs(appIdStr.hashCode() % volumeCount);
            StringBuilder sb = new StringBuilder();
            sb.append(rmDirPath.toUri()).append("/").append(rmVolumeName).append(dirSuffix);
            Path dir = new Path(sb.toString());
            result = new Path(fs.makeQualified(dir).toString() + "/" + appIdStr);
        } else {
            Path dir = new Path(rmSubDir);
            result = new Path(fs.makeQualified(dir).toString() + "/" + appIdStr);
        }
        if (!fs.exists(result) && lookUpAllDirs && (allRMDirsPath = YarnAppUtil.inspectAllRMDirs(fs, rmDirPath, dirSuffix, appIdStr)) != null && fs.exists(allRMDirsPath)) {
            result = allRMDirsPath;
        }
        return result;
    }

    private static Path inspectAllRMDirs(FileSystem fs, Path rmDirPath, String dirSuffix, String appIdStr) throws IOException {
        List rmVolumes = Arrays.asList(fs.listStatus(rmDirPath)).stream().filter(volume -> volume.getPath().getName().matches("\\d+")).collect(Collectors.toList());
        for (FileStatus volumeStatus : rmVolumes) {
            Path appIdPathWithVolume = new Path(fs.makeQualified(volumeStatus.getPath()).toString() + dirSuffix + "/" + appIdStr);
            if (!fs.exists(appIdPathWithVolume)) continue;
            return appIdPathWithVolume;
        }
        Path appIdPath = new Path(fs.makeQualified(rmDirPath).toString() + dirSuffix + "/" + appIdStr);
        if (fs.exists(appIdPath)) {
            return appIdPath;
        }
        LOG.debug("App dir " + dirSuffix + " is not found for app " + appIdStr + ". It's fine for application submit and RM recovery");
        return null;
    }

    public static Path getRMStagedMapRTicketPath(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        return YarnAppUtil.getMapRTicketPath(YarnAppUtil.getRMStagingDir(appIdStr, fs, conf));
    }

    public static Path getRMSystemMapRTicketPath(String appIdStr, FileSystem fs, Configuration conf) throws IOException {
        return YarnAppUtil.getMapRTicketPath(YarnAppUtil.getRMSystemDir(appIdStr, fs, conf));
    }

    public static Path getMapRTicketPath(Path appDir) {
        return new Path(appDir, MAPR_TICKET_FILE);
    }

    public static String getNMPrivateRelativeTicketLocation(String appIdStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("nmPrivate").append("/").append(appIdStr).append("/").append(MAPR_TICKET_FILE);
        return sb.toString();
    }

    public static Path getNMPrivateTicketPath(String appIdStr, Configuration conf) {
        return new Path(conf.get("yarn.nodemanager.local-dirs"), YarnAppUtil.getNMPrivateRelativeTicketLocation(appIdStr));
    }

    public static Path getNMPrivateTicketPathForWrite(String appIdStr, Configuration conf) throws IOException {
        return dirAllocator.getLocalPathForWrite(YarnAppUtil.getNMPrivateRelativeTicketLocation(appIdStr), conf);
    }

    public static Path getNMPrivateTicketPathForRead(String appIdStr, Configuration conf) throws IOException {
        return dirAllocator.getLocalPathToRead(YarnAppUtil.getNMPrivateRelativeTicketLocation(appIdStr), conf);
    }
}

