/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.util.Preconditions;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class JceCtrCryptoCodec
extends CryptoCodec {
    private Configuration conf;
    private String provider;
    private SecureRandom random;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void calculateIV(byte[] initIV, long counter, byte[] iv, int blockSize) {
        Preconditions.checkArgument(initIV.length == blockSize);
        Preconditions.checkArgument(iv.length == blockSize);
        int i = iv.length;
        int j = 0;
        int sum = 0;
        while (i-- > 0) {
            sum = (initIV[i] & 0xFF) + (sum >>> 8);
            if (j++ < 8) {
                sum += (byte)counter & 0xFF;
                counter >>>= 8;
            }
            iv[i] = (byte)sum;
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected abstract Logger getLogger();

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.setProvider(conf.get("hadoop.security.crypto.jce.provider"));
        if ("BCFIPS".equals(this.provider)) {
            Security.addProvider((Provider)new BouncyCastleFipsProvider());
        }
        String secureRandomAlg = conf.get("hadoop.security.java.secure.random.algorithm", "SHA1PRNG");
        try {
            this.random = this.provider != null ? SecureRandom.getInstance(secureRandomAlg, this.provider) : SecureRandom.getInstance(secureRandomAlg);
        }
        catch (GeneralSecurityException e) {
            this.getLogger().warn(e.getMessage());
            this.random = new SecureRandom();
        }
    }

    @Override
    public void generateSecureRandom(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    protected static class JceCtrCipher
    implements Encryptor,
    Decryptor {
        private final Cipher cipher;
        private final int mode;
        private String name;
        private boolean contextReset = false;

        public JceCtrCipher(int mode, String provider, CipherSuite suite, String name) throws GeneralSecurityException {
            this.mode = mode;
            this.name = name;
            this.cipher = provider == null || provider.isEmpty() ? Cipher.getInstance(suite.getName()) : Cipher.getInstance(suite.getName(), provider);
        }

        @Override
        public void init(byte[] key, byte[] iv) throws IOException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(iv);
            this.contextReset = false;
            try {
                this.cipher.init(this.mode, (Key)new SecretKeySpec(key, this.name), new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public void encrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        @Override
        public void decrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        public void process(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            try {
                int inputSize = inBuffer.remaining();
                int n = this.cipher.update(inBuffer, outBuffer);
                if (n < inputSize) {
                    this.contextReset = true;
                    this.cipher.doFinal(inBuffer, outBuffer);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean isContextReset() {
            return this.contextReset;
        }
    }
}

