/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Random;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Bytes;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestText {
    private static final int NUM_ITERATIONS = 100;
    private static final Random RANDOM = new Random(1L);
    private static final int RAND_LEN = -1;

    private static String getTestString(int len) throws Exception {
        int length;
        StringBuilder buffer = new StringBuilder();
        int n = length = len == -1 ? RANDOM.nextInt(1000) : len;
        while (buffer.length() < length) {
            int codePoint = RANDOM.nextInt(0x10FFFF);
            char[] tmpStr = new char[2];
            if (!Character.isDefined(codePoint) || codePoint >= 65536 || Character.isHighSurrogate((char)codePoint) || Character.isLowSurrogate((char)codePoint)) continue;
            Character.toChars(codePoint, tmpStr, 0);
            buffer.append(tmpStr);
        }
        return buffer.toString();
    }

    public static String getTestString() throws Exception {
        return TestText.getTestString(-1);
    }

    public static String getLongString() throws Exception {
        String str = TestText.getTestString();
        int length = Short.MAX_VALUE + str.length();
        StringBuilder buffer = new StringBuilder();
        while (buffer.length() < length) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    @Test
    public void testWritable() throws Exception {
        for (int i = 0; i < 100; ++i) {
            String str = i == 0 ? TestText.getLongString() : TestText.getTestString();
            TestWritable.testWritable((Writable)new Text(str));
        }
    }

    @Test
    public void testCoding() throws Exception {
        String before = "Bad \t encoding \t testcase";
        Text text = new Text(before);
        String after = text.toString();
        Assert.assertTrue((boolean)before.equals(after));
        for (int i = 0; i < 100; ++i) {
            before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            ByteBuffer bb = Text.encode((String)before);
            byte[] utf8Text = bb.array();
            byte[] utf8Java = before.getBytes("UTF-8");
            Assert.assertEquals((long)0L, (long)WritableComparator.compareBytes((byte[])utf8Text, (int)0, (int)bb.limit(), (byte[])utf8Java, (int)0, (int)utf8Java.length));
            after = Text.decode((byte[])utf8Java);
            Assert.assertTrue((boolean)before.equals(after));
        }
    }

    @Test
    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 100; ++i) {
            String before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            out.reset();
            Text.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = Text.readString((DataInput)in);
            Assert.assertTrue((boolean)before.equals(after));
            int strLenSize = WritableUtils.getVIntSize((long)Text.utf8Length((String)before));
            String after2 = new String(out.getData(), strLenSize, out.getLength() - strLenSize, "UTF-8");
            Assert.assertTrue((boolean)before.equals(after2));
        }
    }

    public void doTestLimitedIO(String str, int len) throws IOException {
        String after;
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        out.reset();
        try {
            Text.writeString((DataOutput)out, (String)str, (int)len);
            Assert.fail((String)("expected writeString to fail when told to write a string that was too long!  The string was '" + str + "'"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Text.writeString((DataOutput)out, (String)str, (int)(len + 1));
        in.reset(out.getData(), out.getLength());
        in.mark(len);
        try {
            after = Text.readString((DataInput)in, (int)len);
            Assert.fail((String)("expected readString to fail when told to read a string that was too long!  The string was '" + str + "'"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.reset();
        after = Text.readString((DataInput)in, (int)(len + 1));
        Assert.assertTrue((boolean)str.equals(after));
    }

    @Test
    public void testLimitedIO() throws Exception {
        this.doTestLimitedIO("abcd", 3);
        this.doTestLimitedIO("foo bar baz", 10);
        this.doTestLimitedIO("1", 0);
    }

    @Test
    public void testCompare() throws Exception {
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        DataOutputBuffer out3 = new DataOutputBuffer();
        Text.Comparator comparator = new Text.Comparator();
        for (int i = 0; i < 100; ++i) {
            out1.reset();
            out2.reset();
            out3.reset();
            String str1 = TestText.getTestString();
            String str2 = TestText.getTestString();
            if (i == 0) {
                str1 = TestText.getLongString();
                str2 = TestText.getLongString();
            } else {
                str1 = TestText.getTestString();
                str2 = TestText.getTestString();
            }
            Text txt1 = new Text(str1);
            Text txt2 = new Text(str2);
            Text txt3 = new Text(str1);
            txt1.write((DataOutput)out1);
            txt2.write((DataOutput)out2);
            txt3.write((DataOutput)out3);
            int ret1 = comparator.compare(out1.getData(), 0, out1.getLength(), out2.getData(), 0, out2.getLength());
            int ret2 = txt1.compareTo((BinaryComparable)txt2);
            Assert.assertEquals((long)ret1, (long)ret2);
            Assert.assertEquals((String)"Equivalence of different txt objects, same content", (long)0L, (long)txt1.compareTo((BinaryComparable)txt3));
            Assert.assertEquals((String)"Equvalence of data output buffers", (long)0L, (long)comparator.compare(out1.getData(), 0, out3.getLength(), out3.getData(), 0, out3.getLength()));
        }
    }

    @Test
    public void testFind() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        Assertions.assertThat((int)text.find("abd")).isEqualTo(-1);
        Assertions.assertThat((int)text.find("ac")).isEqualTo(-1);
        Assertions.assertThat((int)text.find("\u20ac")).isEqualTo(4);
        Assertions.assertThat((int)text.find("\u20ac", 5)).isEqualTo(11);
    }

    @Test
    public void testFindAfterUpdatingContents() throws Exception {
        Text text = new Text("abcd");
        text.set("a".getBytes());
        Assert.assertEquals((long)text.getLength(), (long)1L);
        Assert.assertEquals((long)text.find("a"), (long)0L);
        Assert.assertEquals((long)text.find("b"), (long)-1L);
    }

    @Test
    public void testValidate() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        byte[] utf8 = text.getBytes();
        int length = text.getLength();
        Text.validateUTF8((byte[])utf8, (int)0, (int)length);
    }

    @Test
    public void testClear() throws Exception {
        Text text = new Text();
        Assert.assertEquals((String)"Actual string on an empty text object must be an empty string", (Object)"", (Object)text.toString());
        Assert.assertEquals((String)"Underlying byte array length must be zero", (long)0L, (long)text.getBytes().length);
        Assert.assertEquals((String)"String's length must be zero", (long)0L, (long)text.getLength());
        text = new Text("abcd\u20acbdcd\u20ac");
        int len = text.getLength();
        text.clear();
        Assert.assertEquals((String)"String must be empty after clear()", (Object)"", (Object)text.toString());
        Assert.assertTrue((String)"Length of the byte array must not decrease after clear()", (text.getBytes().length >= len ? 1 : 0) != 0);
        Assert.assertEquals((String)"Length of the string must be reset to 0 after clear()", (long)0L, (long)text.getLength());
    }

    @Test
    public void testTextText() throws CharacterCodingException {
        Text a = new Text("abc");
        Text b = new Text("a");
        b.set(a);
        Assert.assertEquals((Object)"abc", (Object)b.toString());
        a.append("xdefgxxx".getBytes(), 1, 4);
        Assert.assertEquals((String)"modified aliased string", (Object)"abc", (Object)b.toString());
        Assert.assertEquals((String)"appended string incorrectly", (Object)"abcdefg", (Object)a.toString());
        a.append(new byte[]{100}, 0, 1);
        Assert.assertEquals((long)10L, (long)a.getBytes().length);
        Assert.assertEquals((long)8L, (long)a.copyBytes().length);
    }

    @Test
    public void testConcurrentEncodeDecode() throws Exception {
        ConcurrentEncodeDecodeThread thread1 = new ConcurrentEncodeDecodeThread("apache");
        ConcurrentEncodeDecodeThread thread2 = new ConcurrentEncodeDecodeThread("hadoop");
        thread1.start();
        thread2.start();
        thread2.join();
        thread2.join();
    }

    @Test
    public void testAvroReflect() throws Exception {
        System.setProperty("org.apache.avro.SERIALIZABLE_PACKAGES", "org.apache.hadoop.io");
        AvroTestUtil.testReflect(new Text("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.io.Text\"}");
    }

    @Test
    public void testCharAt() {
        String line = "adsawseeeeegqewgasddga";
        Text text = new Text(line);
        for (int i = 0; i < line.length(); ++i) {
            Assert.assertTrue((String)"testCharAt error1 !!!", (text.charAt(i) == line.charAt(i) ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"testCharAt error2 !!!", (long)-1L, (long)text.charAt(-1));
        Assert.assertEquals((String)"testCharAt error3 !!!", (long)-1L, (long)text.charAt(100));
    }

    @Test
    public void testReadWriteOperations() {
        String line = "adsawseeeeegqewgasddga";
        byte[] inputBytes = line.getBytes();
        inputBytes = Bytes.concat((byte[][])new byte[][]{{22}, inputBytes});
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        Text text = new Text(line);
        try {
            in.reset(inputBytes, inputBytes.length);
            text.readFields((DataInput)in);
        }
        catch (Exception ex) {
            Assert.fail((String)"testReadFields error !!!");
        }
        try {
            text.write((DataOutput)out);
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail((String)"testReadWriteOperations error !!!");
        }
    }

    @Test
    public void testReadWithKnownLength() throws IOException {
        String line = "hello world";
        byte[] inputBytes = line.getBytes(Charsets.UTF_8);
        DataInputBuffer in = new DataInputBuffer();
        Text text = new Text();
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 5);
        Assert.assertEquals((Object)"hello", (Object)text.toString());
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 7);
        Assert.assertEquals((Object)"hello w", (Object)text.toString());
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 2);
        Assert.assertEquals((Object)"he", (Object)text.toString());
    }

    @Test
    public void testBytesToCodePoint() {
        try {
            ByteBuffer bytes = ByteBuffer.wrap(new byte[]{-2, 45, 23, 12, 76, 89});
            Text.bytesToCodePoint((ByteBuffer)bytes);
            Assert.assertTrue((String)"testBytesToCodePoint error !!!", (bytes.position() == 6 ? 1 : 0) != 0);
        }
        catch (BufferUnderflowException ex) {
            Assert.fail((String)"testBytesToCodePoint unexp exception");
        }
        catch (Exception e) {
            Assert.fail((String)"testBytesToCodePoint unexp exception");
        }
    }

    @Test
    public void testbytesToCodePointWithInvalidUTF() {
        try {
            Text.bytesToCodePoint((ByteBuffer)ByteBuffer.wrap(new byte[]{-2}));
            Assert.fail((String)"testbytesToCodePointWithInvalidUTF error unexp exception !!!");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (Exception e) {
            Assert.fail((String)"testbytesToCodePointWithInvalidUTF error unexp exception !!!");
        }
    }

    @Test
    public void testUtf8Length() {
        Assert.assertEquals((String)"testUtf8Length1 error   !!!", (long)1L, (long)Text.utf8Length((String)new String(new char[]{'\u0001'})));
        Assert.assertEquals((String)"testUtf8Length127 error !!!", (long)1L, (long)Text.utf8Length((String)new String(new char[]{'\u007f'})));
        Assert.assertEquals((String)"testUtf8Length128 error !!!", (long)2L, (long)Text.utf8Length((String)new String(new char[]{'\u0080'})));
        Assert.assertEquals((String)"testUtf8Length193 error !!!", (long)2L, (long)Text.utf8Length((String)new String(new char[]{'\u00c1'})));
        Assert.assertEquals((String)"testUtf8Length225 error !!!", (long)2L, (long)Text.utf8Length((String)new String(new char[]{'\u00e1'})));
        Assert.assertEquals((String)"testUtf8Length254 error !!!", (long)2L, (long)Text.utf8Length((String)new String(new char[]{'\u00fe'})));
    }

    private class ConcurrentEncodeDecodeThread
    extends Thread {
        public ConcurrentEncodeDecodeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            String name = this.getName();
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (int i = 0; i < 1000; ++i) {
                try {
                    out.reset();
                    WritableUtils.writeString((DataOutput)out, (String)name);
                    in.reset(out.getData(), out.getLength());
                    String s = WritableUtils.readString((DataInput)in);
                    Assert.assertEquals((String)("input buffer reset contents = " + name), (Object)name, (Object)s);
                    continue;
                }
                catch (Exception ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }
}

