/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn.auth;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.cosn.auth.AbstractCOSCredentialsProvider;

public class SimpleCredentialsProvider
extends AbstractCOSCredentialsProvider
implements COSCredentialsProvider {
    private String secretId;
    private String secretKey;

    public SimpleCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.secretId = conf.get("fs.cosn.userinfo.secretId");
            this.secretKey = conf.get("fs.cosn.userinfo.secretKey");
        }
    }

    public COSCredentials getCredentials() {
        if (!StringUtils.isNullOrEmpty((String)this.secretId) && !StringUtils.isNullOrEmpty((String)this.secretKey)) {
            return new BasicCOSCredentials(this.secretId, this.secretKey);
        }
        return null;
    }

    public void refresh() {
    }
}

