/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SecretManager<T extends TokenIdentifier> {
    public static final Logger LOG = LoggerFactory.getLogger(SecretManager.class);
    private static String selectedAlgorithm;
    private static int selectedLength;
    private static boolean keygenInitialized;
    private final Object keyGenLock = new Object();
    private volatile KeyGenerator keyGen;
    private static boolean macInitialized;
    private static final ThreadLocal<Mac> threadLocalMac;
    private static boolean secretKeyInitialized;
    private static final String UPDATE_LOG_TEMPLATE = "{} was already initialized with older config, those will not be updated.Hint: If you turn on debug log you can see when it is happening. Thread: {}";

    public static synchronized void update(Configuration conf) {
        if (keygenInitialized) {
            LOG.warn(UPDATE_LOG_TEMPLATE, (Object)"KeyGenerator", (Object)Thread.currentThread());
        }
        if (macInitialized) {
            LOG.warn(UPDATE_LOG_TEMPLATE, (Object)"Mac", (Object)Thread.currentThread());
        }
        if (secretKeyInitialized) {
            LOG.warn(UPDATE_LOG_TEMPLATE, (Object)"SecretKey", (Object)Thread.currentThread());
        }
        selectedAlgorithm = conf.get("hadoop.security.secret-manager.key-generator.algorithm", "HmacSHA1");
        LOG.debug("Selected hash algorithm: {}", (Object)selectedAlgorithm);
        selectedLength = conf.getInt("hadoop.security.secret-manager.key-length", 64);
        LOG.debug("Selected hash key length: {}", (Object)selectedLength);
    }

    protected abstract byte[] createPassword(T var1);

    public abstract byte[] retrievePassword(T var1) throws InvalidToken;

    public byte[] retriableRetrievePassword(T identifier) throws InvalidToken, StandbyException, RetriableException, IOException {
        return this.retrievePassword(identifier);
    }

    public abstract T createIdentifier();

    public void checkAvailableForRead() throws StandbyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKey generateSecret() {
        Object object = this.keyGenLock;
        synchronized (object) {
            if (this.keyGen == null) {
                this.keyGen = SecretManager.createKeyGenerator();
            }
            return this.keyGen.generateKey();
        }
    }

    public static byte[] createPassword(byte[] identifier, SecretKey key) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(key);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(identifier);
    }

    protected static SecretKey createSecretKey(byte[] key) {
        LOG.debug("Creating secretKey with algorithm {} with thread {}", (Object)selectedAlgorithm, (Object)Thread.currentThread());
        secretKeyInitialized = true;
        return new SecretKeySpec(key, selectedAlgorithm);
    }

    private static synchronized KeyGenerator createKeyGenerator() {
        LOG.debug("Creating key generator instance {} - {} bit with thread {}", new Object[]{selectedAlgorithm, selectedLength, Thread.currentThread()});
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(selectedAlgorithm);
            keyGen.init(selectedLength);
            keygenInitialized = true;
            return keyGen;
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find " + selectedAlgorithm, nsa);
        }
    }

    private static synchronized Mac createMac() {
        LOG.debug("Creating mac instance {} with thread {}", (Object)selectedAlgorithm, (Object)Thread.currentThread());
        try {
            Mac mac = Mac.getInstance(selectedAlgorithm);
            macInitialized = true;
            return mac;
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find " + selectedAlgorithm, nsa);
        }
    }

    static {
        threadLocalMac = ThreadLocal.withInitial(SecretManager::createMac);
        SecretManager.update(new Configuration());
    }

    @InterfaceStability.Evolving
    public static class InvalidToken
    extends IOException {
        public InvalidToken(String msg) {
            super(msg);
        }
    }
}

