/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import java.io.DataOutput;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;

public class FakeKerberosAuthMethod
extends RpcAuthMethod {
    private static final String FAKE_SASL_MECH_NAME = "FAKE-SASL-MECHANISM";
    private static final byte KERBEROS_AUTH_CODE = 81;
    static final RpcAuthMethod INSTANCE;
    private static final String[] LOGIN_MODULES;

    private FakeKerberosAuthMethod() {
        super((byte)-1, "fake", FAKE_SASL_MECH_NAME, UserGroupInformation.AuthenticationMethod.SIMPLE);
    }

    @Override
    public String[] loginModules() {
        return LOGIN_MODULES;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(81);
    }

    @Override
    public boolean isSasl() {
        return true;
    }

    @Override
    public SaslClient createSaslClient(Map<String, Object> saslProperties) throws IOException {
        return Sasl.createSaslClient(new String[]{this.mechanismName}, null, null, null, saslProperties, null);
    }

    static {
        Security.addProvider(new FakeSaslProvider());
        INSTANCE = new FakeKerberosAuthMethod();
        LOGIN_MODULES = new String[]{"org.apache.hadoop.security.login.PermissiveLoginModule"};
    }

    public static class FakeSaslClient
    implements SaslClient {
        private boolean firstPass = true;
        private static final byte[] FAKE_TOKEN = new byte[]{70, 65, 75, 69, 84, 79, 75, 69, 78};

        @Override
        public String getMechanismName() {
            return FakeKerberosAuthMethod.FAKE_SASL_MECH_NAME;
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            return FAKE_TOKEN;
        }

        @Override
        public boolean isComplete() {
            if (this.firstPass) {
                this.firstPass = false;
                return false;
            }
            return true;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            return null;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            return null;
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            return null;
        }

        @Override
        public void dispose() throws SaslException {
        }
    }

    public static class FakeSaslClientFactory
    implements SaslClientFactory {
        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{FakeKerberosAuthMethod.FAKE_SASL_MECH_NAME};
        }

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (mechanisms != null) {
                for (String mechanism : mechanisms) {
                    if (!FakeKerberosAuthMethod.FAKE_SASL_MECH_NAME.equals(mechanism)) continue;
                    return new FakeSaslClient();
                }
            }
            return null;
        }
    }

    public static class FakeSaslProvider
    extends Provider {
        public FakeSaslProvider() {
            super("FakeSasl", 1.0, "Fake SASL provider");
            this.put("SaslClientFactory.FAKE-SASL-MECHANISM", FakeSaslClientFactory.class.getName());
        }
    }
}

