/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.util.XMLUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXMLUtils
extends AbstractHadoopTestBase {
    @Test
    public void testSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilder db = XMLUtils.newSecureDocumentBuilderFactory().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader("<root/>")));
        ((ObjectAssert)Assertions.assertThat((Object)doc).describedAs("parsed document", new Object[0])).isNotNull();
    }

    @Test(expected=SAXException.class)
    public void testExternalDtdWithSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilder db = XMLUtils.newSecureDocumentBuilderFactory().newDocumentBuilder();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/external-dtd.xml");){
            Document document = db.parse(stream);
        }
    }

    @Test(expected=SAXException.class)
    public void testEntityDtdWithSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilder db = XMLUtils.newSecureDocumentBuilderFactory().newDocumentBuilder();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/entity-dtd.xml");){
            Document document = db.parse(stream);
        }
    }

    @Test
    public void testSecureSAXParserFactory() throws Exception {
        SAXParser parser = XMLUtils.newSecureSAXParserFactory().newSAXParser();
        parser.parse(new InputSource(new StringReader("<root/>")), new DefaultHandler());
    }

    @Test(expected=SAXException.class)
    public void testExternalDtdWithSecureSAXParserFactory() throws Exception {
        SAXParser parser = XMLUtils.newSecureSAXParserFactory().newSAXParser();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/external-dtd.xml");){
            parser.parse(stream, new DefaultHandler());
        }
    }

    @Test(expected=SAXException.class)
    public void testEntityDtdWithSecureSAXParserFactory() throws Exception {
        SAXParser parser = XMLUtils.newSecureSAXParserFactory().newSAXParser();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/entity-dtd.xml");){
            parser.parse(stream, new DefaultHandler());
        }
    }

    @Test
    public void testSecureTransformerFactory() throws Exception {
        Transformer transformer = XMLUtils.newSecureTransformerFactory().newTransformer();
        DocumentBuilder db = XMLUtils.newSecureDocumentBuilderFactory().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader("<root/>")));
        try (StringWriter stringWriter = new StringWriter();){
            transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
            Assertions.assertThat((String)stringWriter.toString()).contains(new CharSequence[]{"<root"});
        }
    }

    @Test(expected=TransformerException.class)
    public void testExternalDtdWithSecureTransformerFactory() throws Exception {
        Transformer transformer = XMLUtils.newSecureTransformerFactory().newTransformer();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/external-dtd.xml");
             StringWriter stringWriter = new StringWriter();){
            transformer.transform(new StreamSource(stream), new StreamResult(stringWriter));
        }
    }

    @Test
    public void testSecureSAXTransformerFactory() throws Exception {
        Transformer transformer = XMLUtils.newSecureSAXTransformerFactory().newTransformer();
        DocumentBuilder db = XMLUtils.newSecureDocumentBuilderFactory().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader("<root/>")));
        try (StringWriter stringWriter = new StringWriter();){
            transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
            Assertions.assertThat((String)stringWriter.toString()).contains(new CharSequence[]{"<root"});
        }
    }

    @Test(expected=TransformerException.class)
    public void testExternalDtdWithSecureSAXTransformerFactory() throws Exception {
        Transformer transformer = XMLUtils.newSecureSAXTransformerFactory().newTransformer();
        try (InputStream stream = TestXMLUtils.getResourceStream("/xml/external-dtd.xml");
             StringWriter stringWriter = new StringWriter();){
            transformer.transform(new StreamSource(stream), new StreamResult(stringWriter));
        }
    }

    @Test
    public void testBestEffortSetAttribute() throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        AtomicBoolean flag1 = new AtomicBoolean(true);
        XMLUtils.bestEffortSetAttribute((TransformerFactory)factory, (AtomicBoolean)flag1, (String)"unsupportedAttribute false", (Object)"abc");
        Assert.assertFalse((String)"unexpected attribute results in return of false?", (boolean)flag1.get());
        AtomicBoolean flag2 = new AtomicBoolean(true);
        XMLUtils.bestEffortSetAttribute((TransformerFactory)factory, (AtomicBoolean)flag2, (String)"http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        Assert.assertTrue((String)"expected attribute results in return of true?", (boolean)flag2.get());
        AtomicBoolean flag3 = new AtomicBoolean(false);
        XMLUtils.bestEffortSetAttribute((TransformerFactory)factory, (AtomicBoolean)flag3, (String)"http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        Assert.assertFalse((String)"expected attribute results in return of false if input flag is false?", (boolean)flag3.get());
    }

    private static InputStream getResourceStream(String filename) {
        return TestXMLUtils.class.getResourceAsStream(filename);
    }
}

