/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class DynamicLoginConfiguration
extends Configuration {
    private final Configuration baseConfig;
    private final Map<String, ?> overrideOptions;

    public DynamicLoginConfiguration(Configuration base, Map<String, ?> options) {
        this.baseConfig = base;
        this.overrideOptions = options;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        AppConfigurationEntry[] app = this.baseConfig.getAppConfigurationEntry(appName);
        if (app == null) {
            return null;
        }
        AppConfigurationEntry[] newEntries = new AppConfigurationEntry[app.length];
        for (int i = 0; i < app.length; ++i) {
            AppConfigurationEntry entry = app[i];
            newEntries[i] = new OverrideAppConfigurationEntry(entry);
        }
        return newEntries;
    }

    public Map<String, ?> getOverrideOptions() {
        return this.overrideOptions;
    }

    public class OverrideAppConfigurationEntry
    extends AppConfigurationEntry {
        public OverrideAppConfigurationEntry(AppConfigurationEntry base) {
            super(base.getLoginModuleName(), base.getControlFlag(), base.getOptions());
        }

        @Override
        public Map<String, ?> getOptions() {
            Map<String, ?> baseOptions = super.getOptions();
            HashMap newOption = new HashMap();
            newOption.putAll(baseOptions);
            newOption.putAll(DynamicLoginConfiguration.this.overrideOptions);
            return newOption;
        }
    }
}

