/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.Display;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTextCommand {
    private static final File TEST_ROOT_DIR = GenericTestUtils.getTestDir("testText");
    private static final String AVRO_FILENAME = new File(TEST_ROOT_DIR, "weather.avro").toURI().getPath();
    private static final String TEXT_FILENAME = new File(TEST_ROOT_DIR, "testtextfile.txt").toURI().getPath();

    @Test(timeout=30000L)
    public void testDisplayForAvroFiles() throws Exception {
        String expectedOutput = "{\"station\":\"011990-99999\",\"time\":-619524000000,\"temp\":0}" + System.getProperty("line.separator") + "{\"station\":\"011990-99999\",\"time\":-619506000000,\"temp\":22}" + System.getProperty("line.separator") + "{\"station\":\"011990-99999\",\"time\":-619484400000,\"temp\":-11}" + System.getProperty("line.separator") + "{\"station\":\"012650-99999\",\"time\":-655531200000,\"temp\":111}" + System.getProperty("line.separator") + "{\"station\":\"012650-99999\",\"time\":-655509600000,\"temp\":78}" + System.getProperty("line.separator");
        String output = this.readUsingTextCommand(AVRO_FILENAME, this.generateWeatherAvroBinaryData());
        Assert.assertEquals((Object)expectedOutput, (Object)output);
    }

    @Test(timeout=30000L)
    public void testEmptyTextFil() throws Exception {
        byte[] emptyContents = new byte[]{};
        String output = this.readUsingTextCommand(TEXT_FILENAME, emptyContents);
        Assert.assertTrue((boolean)"".equals(output));
    }

    @Test(timeout=30000L)
    public void testOneByteTextFil() throws Exception {
        byte[] oneByteContents = new byte[]{120};
        String output = this.readUsingTextCommand(TEXT_FILENAME, oneByteContents);
        Assert.assertTrue((boolean)new String(oneByteContents).equals(output));
    }

    @Test(timeout=30000L)
    public void testTwoByteTextFil() throws Exception {
        byte[] twoByteContents = new byte[]{120, 121};
        String output = this.readUsingTextCommand(TEXT_FILENAME, twoByteContents);
        Assert.assertTrue((boolean)new String(twoByteContents).equals(output));
    }

    private String readUsingTextCommand(String fileName, byte[] fileContents) throws Exception {
        this.createFile(fileName, fileContents);
        Configuration conf = new Configuration();
        URI localPath = new URI(fileName);
        PathData pathData = new PathData(localPath, conf);
        Display.Text text = new Display.Text(){

            public InputStream getInputStream(PathData item) throws IOException {
                return super.getInputStream(item);
            }
        };
        text.setConf(conf);
        InputStream stream = text.getInputStream(pathData);
        return this.inputStreamToString(stream);
    }

    private String inputStreamToString(InputStream stream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)Charset.defaultCharset());
        return writer.toString();
    }

    private void createFile(String fileName, byte[] contents) throws IOException {
        Files.createDirectories(TEST_ROOT_DIR.toPath(), new FileAttribute[0]);
        File file = new File(fileName);
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(contents);
        stream.close();
    }

    private byte[] generateWeatherAvroBinaryData() {
        byte[] contents = new byte[]{79, 98, 106, 1, 4, 20, 97, 118, 114, 111, 46, 99, 111, 100, 101, 99, 8, 110, 117, 108, 108, 22, 97, 118, 114, 111, 46, 115, 99, 104, 101, 109, 97, -14, 2, 123, 34, 116, 121, 112, 101, 34, 58, 34, 114, 101, 99, 111, 114, 100, 34, 44, 34, 110, 97, 109, 101, 34, 58, 34, 87, 101, 97, 116, 104, 101, 114, 34, 44, 34, 110, 97, 109, 101, 115, 112, 97, 99, 101, 34, 58, 34, 116, 101, 115, 116, 34, 44, 34, 102, 105, 101, 108, 100, 115, 34, 58, 91, 123, 34, 110, 97, 109, 101, 34, 58, 34, 115, 116, 97, 116, 105, 111, 110, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 115, 116, 114, 105, 110, 103, 34, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 116, 105, 109, 101, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 108, 111, 110, 103, 34, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 116, 101, 109, 112, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 105, 110, 116, 34, 125, 93, 44, 34, 100, 111, 99, 34, 58, 34, 65, 32, 119, 101, 97, 116, 104, 101, 114, 32, 114, 101, 97, 100, 105, 110, 103, 46, 34, 125, 0, -80, -127, -77, -60, 10, 12, -10, 98, -6, -55, 56, -3, 126, 82, 0, -89, 10, -52, 1, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -93, -112, -24, -121, 36, 0, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -127, -5, -42, -121, 36, 44, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -91, -82, -62, -121, 36, 21, 24, 48, 49, 50, 54, 53, 48, 45, 57, 57, 57, 57, 57, -1, -73, -94, -117, -108, 38, -34, 1, 24, 48, 49, 50, 54, 53, 48, 45, 57, 57, 57, 57, 57, -1, -37, -43, -10, -109, 38, -100, 1, -80, -127, -77, -60, 10, 12, -10, 98, -6, -55, 56, -3, 126, 82, 0, -89};
        return contents;
    }
}

