/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.util.IPList;
import org.apache.hadoop.util.MachineList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedIPList
implements IPList {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedIPList.class);
    private final String fileName;
    private final MachineList addressList;

    public FileBasedIPList(String fileName) {
        String[] lines;
        this.fileName = fileName;
        try {
            lines = FileBasedIPList.readLines(fileName);
        }
        catch (IOException e) {
            lines = null;
        }
        this.addressList = lines != null ? new MachineList(new HashSet<String>(Arrays.asList(lines))) : null;
    }

    public FileBasedIPList reload() {
        return new FileBasedIPList(this.fileName);
    }

    @Override
    public boolean isIn(String ipAddress) {
        if (ipAddress == null || this.addressList == null) {
            return false;
        }
        return this.addressList.includes(ipAddress);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String[] readLines(String fileName) throws IOException {
        block15: {
            try {
                if (fileName == null) break block15;
                File file = new File(fileName);
                if (file.exists()) {
                    try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);){
                        String[] stringArray;
                        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                            ArrayList<String> lines = new ArrayList<String>();
                            String line = null;
                            while ((line = bufferedReader.readLine()) != null) {
                                lines.add(line);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loaded IP list of size = " + lines.size() + " from file = " + fileName);
                            }
                            stringArray = lines.toArray(new String[lines.size()]);
                        }
                        return stringArray;
                    }
                }
                LOG.debug("Missing ip list file : " + fileName);
            }
            catch (IOException ioe) {
                LOG.error(ioe.toString());
                throw ioe;
            }
        }
        return null;
    }
}

