/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

public class CaseInsensitiveAccessControlList
extends AccessControlList {
    public CaseInsensitiveAccessControlList() {
    }

    public CaseInsensitiveAccessControlList(String aclString) {
        super(aclString.toLowerCase());
    }

    public CaseInsensitiveAccessControlList(String users, String groups) {
        super(users.toLowerCase(), groups.toLowerCase());
    }

    @Override
    public boolean isUserInList(UserGroupInformation ugi) {
        if (this.allAllowed || this.users.contains(ugi.getShortUserName().toLowerCase())) {
            return true;
        }
        if (!this.groups.isEmpty()) {
            for (String group : ugi.getGroups()) {
                if (!this.groups.contains(group.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        WritableFactories.setFactory(CaseInsensitiveAccessControlList.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new CaseInsensitiveAccessControlList();
            }
        });
    }
}

