/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class ConfigUtil {
    public static String getConfigViewFsPrefix(String mountTableName) {
        return "fs.viewfs.mounttable." + mountTableName;
    }

    public static String getConfigViewFsPrefix() {
        return ConfigUtil.getConfigViewFsPrefix("fs.viewfs.mounttable.default");
    }

    public static void addLink(Configuration conf, String mountTableName, String src, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".link." + src, target.toString());
    }

    public static void addLink(Configuration conf, String src, URI target) {
        ConfigUtil.addLink(conf, "default", src, target);
    }

    public static void setHomeDirConf(Configuration conf, String homedir) {
        ConfigUtil.setHomeDirConf(conf, "default", homedir);
    }

    public static void setHomeDirConf(Configuration conf, String mountTableName, String homedir) {
        if (!homedir.startsWith("/")) {
            throw new IllegalArgumentException("Home dir should start with /:" + homedir);
        }
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".homedir", homedir);
    }

    public static String getHomeDirValue(Configuration conf) {
        return ConfigUtil.getHomeDirValue(conf, "default");
    }

    public static String getHomeDirValue(Configuration conf, String mountTableName) {
        return conf.get(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".homedir");
    }
}

