/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CommonConfigurationKeys;

public class ConfigRedactor {
    private static final String REDACTED_TEXT = "<redacted>";
    private List<Pattern> compiledPatterns;

    public ConfigRedactor(Configuration conf) {
        String sensitiveRegexList = conf.get("hadoop.security.sensitive-config-keys", CommonConfigurationKeys.HADOOP_SECURITY_SENSITIVE_CONFIG_KEYS_DEFAULT);
        List<String> sensitiveRegexes = Arrays.asList(sensitiveRegexList.split(","));
        this.compiledPatterns = new ArrayList<Pattern>();
        for (String regex : sensitiveRegexes) {
            Pattern p = Pattern.compile(regex);
            this.compiledPatterns.add(p);
        }
    }

    public String redact(String key, String value) {
        if (this.configIsSensitive(key)) {
            return REDACTED_TEXT;
        }
        return value;
    }

    private boolean configIsSensitive(String key) {
        for (Pattern regex : this.compiledPatterns) {
            if (!regex.matcher(key).find()) continue;
            return true;
        }
        return false;
    }
}

