/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDoAsEffectiveUser {
    private static final String REAL_USER_NAME = "realUser1@HADOOP.APACHE.ORG";
    private static final String REAL_USER_SHORT_NAME = "realUser1";
    private static final String PROXY_USER_NAME = "proxyUser";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String ADDRESS = "0.0.0.0";
    private TestProtocol proxy;
    private static final Configuration masterConf = new Configuration();
    public static final Logger LOG = LoggerFactory.getLogger(TestDoAsEffectiveUser.class);

    @Before
    public void setMasterConf() throws IOException {
        UserGroupInformation.setConfiguration((Configuration)masterConf);
        this.refreshConf(masterConf);
    }

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info("Local Ip addresses: " + builder.toString());
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(superUserShortName), new String[]{builder.toString()});
    }

    @Test
    public void testCreateProxyUser() throws Exception {
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi);
        UserGroupInformation curUGI = (UserGroupInformation)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertEquals((Object)"proxyUser (auth:PROXY) via realUser1@HADOOP.APACHE.ORG (auth:SIMPLE)", (Object)curUGI.toString());
    }

    private void checkRemoteUgi(final Server server, final UserGroupInformation ugi, final Configuration conf) throws Exception {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)NetUtils.getConnectAddress((Server)server), (Configuration)conf);
                Assert.assertEquals((Object)ugi.toString(), (Object)TestDoAsEffectiveUser.this.proxy.aMethod());
                Assert.assertEquals((Object)ugi.toString(), (Object)TestDoAsEffectiveUser.this.proxy.getServerRemoteUser());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testRealUserSetup() throws IOException {
        Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).build();
        this.refreshConf(conf);
        try {
            server.start();
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            this.checkRemoteUgi((Server)server, realUserUgi, conf);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            this.checkRemoteUgi((Server)server, proxyUserUgi, conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testRealUserAuthorizationSuccess() throws IOException {
        Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            this.checkRemoteUgi((Server)server, realUserUgi, conf);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            this.checkRemoteUgi((Server)server, proxyUserUgi, conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_SHORT_NAME), new String[]{"20.20.20.20"});
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{"group3"});
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((Object)this.proxy);
            }
        }
    }

    @Test
    public void testProxyWithToken() throws Exception {
        final Configuration conf = new Configuration(masterConf);
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)current, (String[])GROUP_NAMES);
        proxyUserUgi.addToken(token);
        this.refreshConf(conf);
        String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    this.val$server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy((Object)TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        Assert.assertEquals((Object)"realUser1@HADOOP.APACHE.ORG (auth:TOKEN) via SomeSuperUser (auth:SIMPLE)", (Object)retVal);
    }

    @Test
    public void testTokenBySuperUser() throws Exception {
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        final Configuration newConf = new Configuration(masterConf);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)newConf);
        UserGroupInformation.setConfiguration((Configuration)newConf);
        RPC.Server server = new RPC.Builder(newConf).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.createUserForTesting((String)REAL_USER_NAME, (String[])GROUP_NAMES);
        this.refreshConf(newConf);
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        current.addToken(token);
        String retVal = (String)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    this.val$server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy((Object)TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        String expected = "realUser1@HADOOP.APACHE.ORG (auth:TOKEN) via SomeSuperUser (auth:SIMPLE)";
        Assert.assertEquals((String)(retVal + "!=" + expected), (Object)expected, (Object)retVal);
    }

    private void refreshConf(Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    static {
        masterConf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
    }

    public class TestImpl
    implements TestProtocol {
        @Override
        public String aMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().toString();
        }

        @Override
        public String getServerRemoteUser() throws IOException {
            return Server.getRemoteUser().toString();
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 1L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return new ProtocolSignature(1L, null);
        }
    }

    @TokenInfo(value=TestSaslRPC.TestTokenSelector.class)
    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public String aMethod() throws IOException;

        public String getServerRemoteUser() throws IOException;
    }
}

