/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.handler.codec.http2;

import org.apache.hadoop.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.shaded.io.netty.buffer.Unpooled;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hadoop.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.Brotli;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.BrotliDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.SnappyFrameDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.Zstd;
import org.apache.hadoop.shaded.io.netty.handler.codec.compression.ZstdDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import org.apache.hadoop.shaded.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hadoop.shaded.io.netty.util.internal.ObjectUtil;

public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    private final Http2Connection.PropertyKey propertyKey;
    private final int maxAllocation;

    @Deprecated
    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener) {
        this(connection, listener, 0);
    }

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, int maxAllocation) {
        this(connection, listener, true, maxAllocation);
    }

    @Deprecated
    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, boolean strict) {
        this(connection, listener, strict, 0);
    }

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, boolean strict, int maxAllocation) {
        super(listener);
        this.connection = connection;
        this.strict = strict;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(maxAllocation, "maxAllocation");
        this.propertyKey = connection.newKey();
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream stream) {
                Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
                if (decompressor != null) {
                    decompressor.cleanup();
                }
            }
        });
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null) {
            return this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
        }
        return decompressor.decompress(ctx, stream, data, padding, endOfStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
    }

    protected EmbeddedChannel newContentDecompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP, this.maxAllocation));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(wrapper, this.maxAllocation));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new BrotliDecoder());
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new SnappyFrameDecoder());
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ZstdDecoder());
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return HttpHeaderValues.IDENTITY;
    }

    private void initDecompressor(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            return;
        }
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null && !endOfStream) {
            EmbeddedChannel channel;
            CharSequence contentEncoding = (CharSequence)headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding == null) {
                contentEncoding = HttpHeaderValues.IDENTITY;
            }
            if ((channel = this.newContentDecompressor(ctx, contentEncoding)) != null) {
                decompressor = new Http2Decompressor(channel, this.connection, this.listener);
                stream.setProperty(this.propertyKey, decompressor);
                CharSequence targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                    headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    headers.set(HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
                }
            }
        }
        if (decompressor != null) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                this.connection.local().flowController(new ConsumedBytesConverter(this.connection.local().flowController()));
            }
        }
    }

    Http2Decompressor decompressor(Http2Stream stream) {
        return stream == null ? null : (Http2Decompressor)stream.getProperty(this.propertyKey);
    }

    private static final class Http2Decompressor {
        private final EmbeddedChannel decompressor;
        private int compressed;
        private int decompressed;
        private Http2Stream stream;
        private int padding;
        private boolean dataDecompressed;
        private ChannelHandlerContext targetCtx;

        Http2Decompressor(EmbeddedChannel decompressor, final Http2Connection connection, final Http2FrameListener listener) {
            this.decompressor = decompressor;
            this.decompressor.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                @Override
                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    ByteBuf buf = (ByteBuf)msg;
                    if (!buf.isReadable()) {
                        buf.release();
                        return;
                    }
                    Http2Decompressor.this.incrementDecompressedBytes(buf.readableBytes());
                    connection.local().flowController().consumeBytes(Http2Decompressor.this.stream, listener.onDataRead(Http2Decompressor.this.targetCtx, Http2Decompressor.this.stream.id(), buf, Http2Decompressor.this.padding, false));
                    Http2Decompressor.this.padding = 0;
                    buf.release();
                    Http2Decompressor.this.dataDecompressed = true;
                }

                @Override
                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    listener.onDataRead(Http2Decompressor.this.targetCtx, Http2Decompressor.this.stream.id(), Unpooled.EMPTY_BUFFER, Http2Decompressor.this.padding, true);
                }
            });
        }

        void cleanup() {
            this.decompressor.finishAndReleaseAll();
        }

        int decompress(ChannelHandlerContext ctx, Http2Stream stream, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int compressedBytes = data.readableBytes() + padding;
            this.incrementCompressedBytes(compressedBytes);
            try {
                this.stream = stream;
                this.padding = padding;
                this.dataDecompressed = false;
                this.targetCtx = ctx;
                this.decompressor.writeInbound(data.retain());
                if (endOfStream) {
                    this.decompressor.finish();
                    if (!this.dataDecompressed) {
                        this.incrementDecompressedBytes(compressedBytes);
                        return compressedBytes;
                    }
                }
                return 0;
            }
            catch (Throwable t) {
                if (t instanceof Http2Exception) {
                    throw (Http2Exception)t;
                }
                throw Http2Exception.streamError(stream.id(), Http2Error.INTERNAL_ERROR, t, "Decompressor error detected while delegating data read on streamId %d", stream.id());
            }
        }

        private void incrementCompressedBytes(int delta) {
            assert (delta >= 0);
            this.compressed += delta;
        }

        private void incrementDecompressedBytes(int delta) {
            assert (delta >= 0);
            this.decompressed += delta;
        }

        int consumeBytes(int streamId, int decompressedBytes) throws Http2Exception {
            ObjectUtil.checkPositiveOrZero(decompressedBytes, "decompressedBytes");
            if (this.decompressed - decompressedBytes < 0) {
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", streamId, this.decompressed, decompressedBytes);
            }
            double consumedRatio = (double)decompressedBytes / (double)this.decompressed;
            int consumedCompressed = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * consumedRatio));
            if (this.compressed - consumedCompressed < 0) {
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", streamId, decompressedBytes, this.decompressed, this.compressed, consumedCompressed);
            }
            this.decompressed -= decompressedBytes;
            this.compressed -= consumedCompressed;
            return consumedCompressed;
        }
    }

    private final class ConsumedBytesConverter
    implements Http2LocalFlowController {
        private final Http2LocalFlowController flowController;

        ConsumedBytesConverter(Http2LocalFlowController flowController) {
            this.flowController = ObjectUtil.checkNotNull(flowController, "flowController");
        }

        @Override
        public Http2LocalFlowController frameWriter(Http2FrameWriter frameWriter) {
            return this.flowController.frameWriter(frameWriter);
        }

        @Override
        public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
            this.flowController.channelHandlerContext(ctx);
        }

        @Override
        public void initialWindowSize(int newWindowSize) throws Http2Exception {
            this.flowController.initialWindowSize(newWindowSize);
        }

        @Override
        public int initialWindowSize() {
            return this.flowController.initialWindowSize();
        }

        @Override
        public int windowSize(Http2Stream stream) {
            return this.flowController.windowSize(stream);
        }

        @Override
        public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
            this.flowController.incrementWindowSize(stream, delta);
        }

        @Override
        public void receiveFlowControlledFrame(Http2Stream stream, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            this.flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
        }

        @Override
        public boolean consumeBytes(Http2Stream stream, int numBytes) throws Http2Exception {
            Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
            if (decompressor != null) {
                numBytes = decompressor.consumeBytes(stream.id(), numBytes);
            }
            try {
                return this.flowController.consumeBytes(stream, numBytes);
            }
            catch (Http2Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw Http2Exception.streamError(stream.id(), Http2Error.INTERNAL_ERROR, t, "Error while returning bytes to flow control window", new Object[0]);
            }
        }

        @Override
        public int unconsumedBytes(Http2Stream stream) {
            return this.flowController.unconsumedBytes(stream);
        }

        @Override
        public int initialWindowSize(Http2Stream stream) {
            return this.flowController.initialWindowSize(stream);
        }
    }
}

