/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class MapRDistributedFileSystem
extends DistributedFileSystem {
    private FileSystem maprfs;
    private static final String MAPRFS_IMPL = "org.apache.hadoop.shaded.com.mapr.fs.MapRFileSystem";
    private static final String UNSUPPORTED_MESSAGE = "MapRFilesystem does not extend DistributedFileSystem";

    public MapRDistributedFileSystem() {
        try {
            Class<FileSystem> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(MAPRFS_IMPL).asSubclass(FileSystem.class);
            this.maprfs = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InetSocketAddress[] getJobTrackerAddrs(Configuration conf) throws IOException {
        return this.maprfs.getJobTrackerAddrs(conf);
    }

    public PathId createPathId() {
        return this.maprfs.createPathId();
    }

    public FSDataInputStream openFid2(PathId pfid, String file, int readAheadBytesHint) throws IOException {
        return this.maprfs.openFid2(pfid, file, readAheadBytesHint);
    }

    public FSDataOutputStream createFid(String pfid, String file) throws IOException {
        return this.maprfs.createFid(pfid, file);
    }

    public boolean deleteFid(String pfid, String dir) throws IOException {
        return this.maprfs.deleteFid(pfid, dir);
    }

    public String mkdirsFid(Path p) throws IOException {
        return this.maprfs.mkdirsFid(p);
    }

    public String mkdirsFid(String pfid, String dir) throws IOException {
        return this.maprfs.mkdirsFid(pfid, dir);
    }

    public void setOwnerFid(String fid, String user, String group) throws IOException {
        this.maprfs.setOwnerFid(fid, user, group);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.maprfs.initialize(name, conf);
    }

    public String getScheme() {
        return this.maprfs.getScheme();
    }

    public URI getUri() {
        return this.maprfs.getUri();
    }

    public String getCanonicalServiceName() {
        return this.maprfs.getCanonicalServiceName();
    }

    public String getName() {
        return this.maprfs.getName();
    }

    public Path makeQualified(Path path) {
        return this.maprfs.makeQualified(path);
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        return this.maprfs.getDelegationToken(renewer);
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.maprfs.addDelegationTokens(renewer, credentials);
    }

    public FileSystem[] getChildFileSystems() {
        return this.maprfs.getChildFileSystems();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.maprfs.getFileBlockLocations(file, start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        return this.maprfs.getFileBlockLocations(p, start, len);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.maprfs.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.maprfs.getServerDefaults(p);
    }

    public Path resolvePath(Path p) throws IOException {
        return this.maprfs.resolvePath(p);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.maprfs.open(f, bufferSize);
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.maprfs.open(f);
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.maprfs.create(f);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.maprfs.create(f, overwrite);
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.maprfs.create(f, progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.maprfs.create(f, replication);
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.maprfs.create(f, replication, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.maprfs.create(f, overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.maprfs.create(f, overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.maprfs.create(f, overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.create(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.create(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.maprfs.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.createNonRecursive(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.maprfs.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean createNewFile(Path f) throws IOException {
        return this.maprfs.createNewFile(f);
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.maprfs.append(f);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.maprfs.append(f, bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.maprfs.append(f, bufferSize, progress);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.maprfs.concat(trg, psrcs);
    }

    public short getReplication(Path src) throws IOException {
        return this.maprfs.getReplication(src);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.maprfs.setReplication(src, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.maprfs.rename(src, dst);
    }

    public boolean delete(Path f) throws IOException {
        return this.maprfs.delete(f);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.maprfs.delete(f, recursive);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.maprfs.deleteOnExit(f);
    }

    public boolean cancelDeleteOnExit(Path f) {
        return this.maprfs.cancelDeleteOnExit(f);
    }

    public boolean exists(Path f) throws IOException {
        return this.maprfs.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.maprfs.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        return this.maprfs.isFile(f);
    }

    public long getLength(Path f) throws IOException {
        return this.maprfs.getLength(f);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.maprfs.getContentSummary(f);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.maprfs.listStatus(f);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.maprfs.listCorruptFileBlocks(path);
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        return this.maprfs.listStatus(f, filter);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.maprfs.listStatus(files);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        return this.maprfs.listStatus(files, filter);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.maprfs.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return this.maprfs.globStatus(pathPattern, filter);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.maprfs.listLocatedStatus(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return this.maprfs.listFiles(f, recursive);
    }

    public Path getHomeDirectory() {
        return this.maprfs.getHomeDirectory();
    }

    public void setWorkingDirectory(Path new_dir) {
        this.maprfs.setWorkingDirectory(new_dir);
    }

    public Path getWorkingDirectory() {
        return this.maprfs.getWorkingDirectory();
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.maprfs.mkdirs(f);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.maprfs.mkdirs(f, permission);
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.maprfs.copyFromLocalFile(src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.maprfs.moveFromLocalFile(srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.maprfs.moveFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.maprfs.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.maprfs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.maprfs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.maprfs.copyToLocalFile(src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.maprfs.moveToLocalFile(src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.maprfs.copyToLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        this.maprfs.copyToLocalFile(delSrc, src, dst, useRawLocalFileSystem);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.maprfs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.maprfs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        this.maprfs.close();
    }

    public long getUsed() throws IOException {
        return this.maprfs.getUsed();
    }

    public long getBlockSize(Path f) throws IOException {
        return this.maprfs.getBlockSize(f);
    }

    public long getDefaultBlockSize() {
        return this.maprfs.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path f) {
        return this.maprfs.getDefaultBlockSize(f);
    }

    public short getDefaultReplication() {
        return this.maprfs.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        return this.maprfs.getDefaultReplication(path);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.maprfs.getFileStatus(f);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.maprfs.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.maprfs.getFileLinkStatus(f);
    }

    public boolean supportsSymlinks() {
        return this.maprfs.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.maprfs.getLinkTarget(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.maprfs.getFileChecksum(f);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.maprfs.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.maprfs.setWriteChecksum(writeChecksum);
    }

    public FsStatus getStatus() throws IOException {
        return this.maprfs.getStatus();
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.maprfs.getStatus(p);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.maprfs.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.maprfs.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.maprfs.setTimes(p, mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.maprfs.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.maprfs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.maprfs.deleteSnapshot(path, snapshotName);
    }

    public FSDataInputStream openFid(String fid, long[] ips, long chunkSize, long fileSize) throws IOException {
        return this.maprfs.openFid(fid, ips, chunkSize, fileSize);
    }

    public FSDataInputStream openFid(String pfid, String file, long[] ips) throws IOException {
        return this.maprfs.openFid(pfid, file, ips);
    }

    public String getZkConnectString() throws IOException {
        return this.maprfs.getZkConnectString();
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean recoverLease(Path f) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, InetSocketAddress[] favoredNodes) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public DFSClient getClient() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public long getMissingBlocksCount() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public long getCorruptBlocksCount() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public long rollEdits() throws AccessControlException, IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void refreshNodes() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void finalizeUpgrade() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void metaSave(String pathname) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean isInSafeMode() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void allowSnapshot(Path path) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void disallowSnapshot(Path path) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public boolean isFileClosed(Path src) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public long addCacheDirective(CacheDirectiveInfo info) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void removeCacheDirective(long id) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public void removeCachePool(String poolName) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected URI canonicalizeUri(URI uri) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected int getDefaultPort() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected Path resolveLink(Path f) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public String toString() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path p, PathFilter filter) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }
}

