/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.shaded.javax.websocket.Nullable;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ProfilingFileIoEvents {
    static final Logger LOG = LoggerFactory.getLogger(ProfilingFileIoEvents.class);
    private volatile boolean isEnabled;
    private volatile int sampleRangeMax;

    public ProfilingFileIoEvents(@Nullable Configuration conf) {
        if (conf != null) {
            int fileIOSamplingPercentage = conf.getInt("dfs.datanode.fileio.profiling.sampling.percentage", 0);
            this.setSampleRangeMax(fileIOSamplingPercentage);
        } else {
            this.isEnabled = false;
            this.sampleRangeMax = 0;
        }
    }

    public long beforeMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addMetadataOperationLatency(Time.monotonicNow() - begin);
        }
    }

    public long beforeFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && ThreadLocalRandom.current().nextInt() < this.sampleRangeMax && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && begin != 0L && (metrics = this.getVolumeMetrics(volume)) != null) {
            long latency = Time.monotonicNow() - begin;
            metrics.addDataFileIoLatency(latency);
            switch (op) {
                case SYNC: {
                    metrics.addSyncIoLatency(latency);
                    break;
                }
                case FLUSH: {
                    metrics.addFlushIoLatency(latency);
                    break;
                }
                case READ: {
                    metrics.addReadIoLatency(latency);
                    break;
                }
                case WRITE: {
                    metrics.addWriteIoLatency(latency);
                    break;
                }
                case TRANSFER: {
                    metrics.addTransferIoLatency(latency);
                    break;
                }
                case NATIVE_COPY: {
                    metrics.addNativeCopyIoLatency(latency);
                    break;
                }
            }
        }
    }

    public void onFailure(@Nullable FsVolumeSpi volume, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addFileIoError(Time.monotonicNow() - begin);
        }
    }

    private DataNodeVolumeMetrics getVolumeMetrics(FsVolumeSpi volume) {
        if (this.isEnabled && volume != null) {
            return volume.getMetrics();
        }
        return null;
    }

    public void setSampleRangeMax(int fileIOSamplingPercentage) {
        this.isEnabled = Util.isDiskStatsEnabled(fileIOSamplingPercentage);
        if (fileIOSamplingPercentage > 100) {
            LOG.warn("dfs.datanode.fileio.profiling.sampling.percentage value cannot be more than 100. Setting value to 100");
            fileIOSamplingPercentage = 100;
        }
        this.sampleRangeMax = (int)((double)fileIOSamplingPercentage / 100.0 * 2.147483647E9);
    }

    @VisibleForTesting
    public boolean getDiskStatsEnabled() {
        return this.isEnabled;
    }

    @VisibleForTesting
    public int getSampleRangeMax() {
        return this.sampleRangeMax;
    }
}

