/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.Closeable;
import java.security.Principal;
import java.util.EnumSet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParser;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForExistFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForKVFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForNumericFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForRelationFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;

public final class TimelineReaderWebServicesUtils {
    private TimelineReaderWebServicesUtils() {
    }

    static TimelineReaderContext createTimelineReaderContext(String clusterId, String userId, String flowName, String flowRunId, String appId, String entityType, String entityIdPrefix, String entityId) {
        return new TimelineReaderContext(TimelineReaderWebServicesUtils.parseStr(clusterId), TimelineReaderWebServicesUtils.parseStr(userId), TimelineReaderWebServicesUtils.parseStr(flowName), TimelineReaderWebServicesUtils.parseLongStr(flowRunId), TimelineReaderWebServicesUtils.parseStr(appId), TimelineReaderWebServicesUtils.parseStr(entityType), TimelineReaderWebServicesUtils.parseLongStr(entityIdPrefix), TimelineReaderWebServicesUtils.parseStr(entityId));
    }

    static TimelineReaderContext createTimelineReaderContext(String clusterId, String userId, String flowName, String flowRunId, String appId, String entityType, String entityIdPrefix, String entityId, String doAsUser) {
        return new TimelineReaderContext(TimelineReaderWebServicesUtils.parseStr(clusterId), TimelineReaderWebServicesUtils.parseStr(userId), TimelineReaderWebServicesUtils.parseStr(flowName), TimelineReaderWebServicesUtils.parseLongStr(flowRunId), TimelineReaderWebServicesUtils.parseStr(appId), TimelineReaderWebServicesUtils.parseStr(entityType), TimelineReaderWebServicesUtils.parseLongStr(entityIdPrefix), TimelineReaderWebServicesUtils.parseStr(entityId), TimelineReaderWebServicesUtils.parseStr(doAsUser));
    }

    static TimelineEntityFilters createTimelineEntityFilters(String limit, String createdTimeStart, String createdTimeEnd, String relatesTo, String isRelatedTo, String infofilters, String conffilters, String metricfilters, String eventfilters, String fromid) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, TimelineReaderWebServicesUtils.parseLongStr(createdTimeStart), TimelineReaderWebServicesUtils.parseLongStr(createdTimeEnd), relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, fromid);
    }

    static TimelineEntityFilters createTimelineEntityFilters(String limit, Long createdTimeStart, Long createdTimeEnd, String relatesTo, String isRelatedTo, String infofilters, String conffilters, String metricfilters, String eventfilters, String fromid) throws TimelineParseException {
        return new TimelineEntityFilters.Builder().entityLimit(TimelineReaderWebServicesUtils.parseLongStr(limit)).createdTimeBegin(createdTimeStart).createTimeEnd(createdTimeEnd).relatesTo(TimelineReaderWebServicesUtils.parseRelationFilters(relatesTo)).isRelatedTo(TimelineReaderWebServicesUtils.parseRelationFilters(isRelatedTo)).infoFilters(TimelineReaderWebServicesUtils.parseKVFilters(infofilters, false)).configFilters(TimelineReaderWebServicesUtils.parseKVFilters(conffilters, true)).metricFilters(TimelineReaderWebServicesUtils.parseMetricFilters(metricfilters)).eventFilters(TimelineReaderWebServicesUtils.parseEventFilters(eventfilters)).fromId(TimelineReaderWebServicesUtils.parseStr(fromid)).build();
    }

    static TimelineDataToRetrieve createTimelineDataToRetrieve(String confs, String metrics, String fields, String metricsLimit, String metricsTimeBegin, String metricsTimeEnd) throws TimelineParseException {
        return new TimelineDataToRetrieve(TimelineReaderWebServicesUtils.parseDataToRetrieve(confs), TimelineReaderWebServicesUtils.parseDataToRetrieve(metrics), TimelineReaderWebServicesUtils.parseFieldsStr(fields, ","), TimelineReaderWebServicesUtils.parseIntStr(metricsLimit), TimelineReaderWebServicesUtils.parseLongStr(metricsTimeBegin), TimelineReaderWebServicesUtils.parseLongStr(metricsTimeEnd));
    }

    static TimelineFilterList parseEventFilters(String expr) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.parseFilters(new TimelineParserForExistFilters(expr, ','));
    }

    static TimelineFilterList parseRelationFilters(String expr) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.parseFilters(new TimelineParserForRelationFilters(expr, ',', ":"));
    }

    private static TimelineFilterList parseFilters(TimelineParser parser) throws TimelineParseException {
        try {
            TimelineFilterList timelineFilterList = parser.parse();
            return timelineFilterList;
        }
        finally {
            IOUtils.closeQuietly((Closeable)parser);
        }
    }

    static TimelineFilterList parseKVFilters(String expr, boolean valueAsString) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.parseFilters(new TimelineParserForKVFilters(expr, valueAsString));
    }

    static EnumSet<TimelineReader.Field> parseFieldsStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter);
        EnumSet<TimelineReader.Field> fieldList = EnumSet.noneOf(TimelineReader.Field.class);
        for (String s : strs) {
            try {
                fieldList.add(TimelineReader.Field.valueOf(s.trim().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(s + " is not a valid field.");
            }
        }
        return fieldList;
    }

    static TimelineFilterList parseMetricFilters(String expr) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.parseFilters(new TimelineParserForNumericFilters(expr));
    }

    static Long parseLongStr(String str) {
        return str == null ? null : Long.valueOf(Long.parseLong(str.trim()));
    }

    static Integer parseIntStr(String str) {
        return str == null ? null : Integer.valueOf(Integer.parseInt(str.trim()));
    }

    static String parseStr(String str) {
        return StringUtils.trimToNull((String)str);
    }

    public static UserGroupInformation getUser(HttpServletRequest req) {
        Principal princ = req.getUserPrincipal();
        String remoteUser = princ == null ? null : princ.getName();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    static String getUserName(UserGroupInformation callerUGI) {
        return callerUGI != null ? callerUGI.getUserName().trim() : "";
    }

    static TimelineFilterList parseDataToRetrieve(String expr) throws TimelineParseException {
        return TimelineReaderWebServicesUtils.parseFilters(new TimelineParserForDataToRetrieve(expr));
    }
}

