/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.slf4j.Logger;

public class SchedulerAppUtils {
    public static boolean isPlaceBlacklisted(SchedulerApplicationAttempt application, SchedulerNode node, Logger log) {
        if (application.isPlaceBlacklisted(node.getNodeName()) || application instanceof FSAppAttempt && application.isPlaceBlackListedBasedOnLabels(node.getNodeName())) {
            log.debug("Skipping 'host' {} for {} since it has been blacklisted", (Object)node.getNodeName(), (Object)application.getApplicationId());
            return true;
        }
        if (application.isPlaceBlacklisted(node.getRackName())) {
            log.debug("Skipping 'rack' {} for {} since it has been blacklisted", (Object)node.getRackName(), (Object)application.getApplicationId());
            return true;
        }
        return false;
    }
}

