/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.ImageManifest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.RuncImageTagToManifestPlugin;

@InterfaceStability.Unstable
public class ImageTagToManifestPlugin
extends AbstractService
implements RuncImageTagToManifestPlugin {
    private Map<String, ImageManifest> manifestCache;
    private ObjectMapper objMapper;
    private AtomicReference<Map<String, String>> localImageToHashCache = new AtomicReference(new HashMap());
    private AtomicReference<Map<String, String>> hdfsImageToHashCache = new AtomicReference(new HashMap());
    private Configuration conf;
    private ScheduledExecutorService exec;
    private long hdfsModTime;
    private long localModTime;
    private String hdfsImageToHashFile;
    private String manifestDir;
    private String localImageTagToHashFile;
    private static final Log LOG = LogFactory.getLog(ImageTagToManifestPlugin.class);
    private static final int SHA256_HASH_LENGTH = 64;
    private static final String ALPHA_NUMERIC = "[a-zA-Z0-9]+";

    public ImageTagToManifestPlugin() {
        super("ImageTagToManifestPluginService");
    }

    @Override
    public ImageManifest getManifestFromImageTag(String imageTag) throws IOException {
        FSDataInputStream input;
        String hash = this.getHashFromImageTag(imageTag);
        ImageManifest manifest = this.manifestCache.get(hash);
        if (manifest != null) {
            return manifest;
        }
        Path manifestPath = new Path(this.manifestDir + hash);
        FileSystem fs = manifestPath.getFileSystem(this.conf);
        try {
            input = fs.open(manifestPath);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Manifest file is not a valid HDFS file: " + manifestPath.toString(), iae);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)input);
        manifest = (ImageManifest)this.objMapper.readValue(bytes, ImageManifest.class);
        this.manifestCache.put(hash, manifest);
        return manifest;
    }

    @Override
    public String getHashFromImageTag(String imageTag) {
        Map<String, String> localImageToHashCacheMap = this.localImageToHashCache.get();
        Map<String, String> hdfsImageToHashCacheMap = this.hdfsImageToHashCache.get();
        String hash = localImageToHashCacheMap.get(imageTag);
        if (hash == null && (hash = hdfsImageToHashCacheMap.get(imageTag)) == null) {
            hash = imageTag;
        }
        return hash;
    }

    protected BufferedReader getLocalImageToHashReader() throws IOException {
        if (this.localImageTagToHashFile == null) {
            LOG.debug((Object)"Did not load local image to hash file, file is null");
            return null;
        }
        File imageTagToHashFile = new File(this.localImageTagToHashFile);
        if (!imageTagToHashFile.exists()) {
            LOG.debug((Object)"Did not load local image to hash file, file doesn't exist");
            return null;
        }
        long newLocalModTime = imageTagToHashFile.lastModified();
        if (newLocalModTime == this.localModTime) {
            LOG.debug((Object)"Did not load local image to hash file, file is unmodified");
            return null;
        }
        this.localModTime = newLocalModTime;
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(imageTagToHashFile), StandardCharsets.UTF_8));
    }

    protected BufferedReader getHdfsImageToHashReader() throws IOException {
        if (this.hdfsImageToHashFile == null) {
            LOG.debug((Object)"Did not load hdfs image to hash file, file is null");
            return null;
        }
        Path imageToHash = new Path(this.hdfsImageToHashFile);
        FileSystem fs = imageToHash.getFileSystem(this.conf);
        if (!fs.exists(imageToHash)) {
            LOG.debug((Object)"Did not load hdfs image to hash file, file doesn't exist");
            return null;
        }
        long newHdfsModTime = fs.getFileStatus(imageToHash).getModificationTime();
        if (newHdfsModTime == this.hdfsModTime) {
            LOG.debug((Object)"Did not load hdfs image to hash file, file is unmodified");
            return null;
        }
        this.hdfsModTime = newHdfsModTime;
        return new BufferedReader(new InputStreamReader((InputStream)fs.open(imageToHash), StandardCharsets.UTF_8));
    }

    protected static Map<String, String> readImageToHashFile(BufferedReader br) throws IOException {
        String line;
        if (br == null) {
            return null;
        }
        HashMap<String, String> imageToHashCache = new HashMap<String, String>();
        while ((line = br.readLine()) != null) {
            int index = line.indexOf("#");
            if (index == 0) continue;
            if (index != -1) {
                line = line.substring(0, index);
            }
            if ((index = line.lastIndexOf(":")) == -1) {
                LOG.warn((Object)("Malformed imageTagToManifest entry: " + line));
                continue;
            }
            String imageTags = line.substring(0, index);
            String[] imageTagArray = imageTags.split(",");
            String hash = line.substring(index + 1);
            if (!hash.matches(ALPHA_NUMERIC) || hash.length() != 64) {
                LOG.warn((Object)("Malformed image hash: " + hash));
                continue;
            }
            for (String imageTag : imageTagArray) {
                imageToHashCache.put(imageTag, hash);
            }
        }
        return imageToHashCache;
    }

    public boolean loadImageToHashFiles() throws IOException {
        boolean ret = false;
        try (BufferedReader localBr = this.getLocalImageToHashReader();
             BufferedReader hdfsBr = this.getHdfsImageToHashReader();){
            Map<String, String> localImageToHash = ImageTagToManifestPlugin.readImageToHashFile(localBr);
            Map<String, String> hdfsImageToHash = ImageTagToManifestPlugin.readImageToHashFile(hdfsBr);
            Map<String, String> tmpLocalImageToHash = this.localImageToHashCache.get();
            Map<String, String> tmpHdfsImageToHash = this.hdfsImageToHashCache.get();
            if (localImageToHash != null && !localImageToHash.equals(tmpLocalImageToHash)) {
                this.localImageToHashCache.set(localImageToHash);
                LOG.info((Object)"Reloaded local image tag to hash cache");
                ret = true;
            }
            if (hdfsImageToHash != null && !hdfsImageToHash.equals(tmpHdfsImageToHash)) {
                this.hdfsImageToHashCache.set(hdfsImageToHash);
                LOG.info((Object)"Reloaded hdfs image tag to hash cache");
                ret = true;
            }
        }
        return ret;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        super.serviceInit(configuration);
        this.conf = configuration;
        this.localImageTagToHashFile = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-tag-to-manifest-plugin.local-hash-file");
        if (this.localImageTagToHashFile == null) {
            LOG.debug((Object)"Failed to load local runC image to hash file. Config not set");
        }
        this.hdfsImageToHashFile = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-tag-to-manifest-plugin.hdfs-hash-file");
        if (this.hdfsImageToHashFile == null) {
            LOG.debug((Object)"Failed to load HDFS runC image to hash file. Config not set");
        }
        if (this.hdfsImageToHashFile == null && this.localImageTagToHashFile == null) {
            LOG.warn((Object)"No valid image-tag-to-hash files");
        }
        this.manifestDir = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-toplevel-dir", "/runc-root") + "/manifests/";
        int numManifestsToCache = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.image-tag-to-manifest-plugin.num-manifests-to-cache", 10);
        this.objMapper = new ObjectMapper();
        this.manifestCache = Collections.synchronizedMap(new LRUCache(numManifestsToCache, 0.75f));
        this.exec = HadoopExecutors.newScheduledThreadPool((int)1);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        if (!this.loadImageToHashFiles()) {
            LOG.warn((Object)"Couldn't load any image-tag-to-hash-files");
        }
        int runcCacheRefreshInterval = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.image-tag-to-manifest-plugin.cache-refresh-interval-secs", 60);
        this.exec = HadoopExecutors.newScheduledThreadPool((int)1);
        this.exec.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageTagToManifestPlugin.this.loadImageToHashFiles();
                }
                catch (Exception e) {
                    LOG.warn((Object)"runC cache refresh thread caught an exception: ", (Throwable)e);
                }
            }
        }, runcCacheRefreshInterval, runcCacheRefreshInterval, TimeUnit.SECONDS);
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        this.exec.shutdownNow();
    }

    private static class LRUCache
    extends LinkedHashMap<String, ImageManifest> {
        private int cacheSize;

        LRUCache(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, true);
            this.cacheSize = initialCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ImageManifest> eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

