package org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.util;

import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.thirdparty.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.google.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.on.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.google.gson.JsonArray;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.google.gson.JsonParser;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.google.gson.JsonSyntaxException;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.slf4j.Logger;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.slf4j.LoggerFactory;

import java.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * A base class for running a maprcli unix org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and.
 * By defaults add maprcli prefix and -json suffix to all org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.ands
 */
public class MaprShellCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MaprShellCommandExecutor.class);
    private static final String DATA_FIELD = "data";

    private final JsonParser parser = new JsonParser();
    private Shell.ShellCommandExecutor executor;

    /**
     * Call maprcli org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and on cluster.
     *
     * @param org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.ands passed by client
     * @param params  extra org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and params
     * @return json object which contains response data
     * @throws IOException
     */
    public JsonArray execute(String[] org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and, Map<String, String> params, boolean skipMaprcli) throws IOException {
        executor = new Shell.ShellCommandExecutor(createArgs(org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and, params, skipMaprcli));
        LOG.info("Trying to execute org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and: " + executor.toString());
        String output = "";
        try {
            executor.execute();
            if (skipMaprcli){
                return null;
            }
            output = executor.getOutput();
            if (output == null || output.isEmpty()) {
                LOG.error("Output is empty");
                throw new IOException("Empty output");
            }
            return parser.parse(output).getAsJsonObject().getAsJsonArray(DATA_FIELD);
        } catch (JsonSyntaxException e){
            LOG.warn("Can't parse JSON output: " + output);
            //Possible enabled debug log for Kerberos, which produces extra logs to maprcli org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and.
            //It doesn't possible to disable kerberos debug for maprcli from outside.
            //Trying to substring all output data to '{' character  to cut all debug logs
            return parser.parse(output.substring(output.indexOf("{"))).getAsJsonObject().getAsJsonArray(DATA_FIELD);
        } catch (IOException e) {
            int exitCode = executor.getExitCode();
            if (exitCode != 0) {
                LOG.error("Failed to execute org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and. Command output " + executor.getOutput());
            }
            throw e;
        } finally {
            executor = null;
        }
    }

    @VisibleForTesting
    protected void setCommandExecutor(Shell.ShellCommandExecutor executor) {
        this.executor = executor;
    }

    /**
     * @param org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.ands passed by client
     * @param params  org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and parameters
     * @return full maprcli org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and
     */
    @VisibleForTesting
    protected String[] createArgs(String[] org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and, Map<String, String> params, boolean skipMaprcli) {
        if (org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and == null) {
            throw new IllegalArgumentException("Empty org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and");
        }
        if (params == null) {
            params = new HashMap<>();
        }

        // extra fields -> maprcli org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and and -json flag
        int size = org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and.length + (params.size() * 2);
        if (!skipMaprcli) size += 2;
        String[] args = new String[size];

        int counter = 0;
        if (!skipMaprcli) args[counter++] = "maprcli";
        for (String c : org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.and) {
            args[counter++] = c;
        }

        for (Map.Entry<String, String> e : params.entrySet()) {
            String paramName = validateAndGetParamName(e.getKey());
            args[counter++] = paramName;
            args[counter++] = e.getValue();
        }
        if (!skipMaprcli) args[counter] = "-json";
        return args;
    }

    /**
     * Check value and return parameter with - (minus) prefix.
     *
     * @param value parameter value
     * @return parameter with - (minus) prefix e.g. -name
     */
    private String validateAndGetParamName(String value) {
        if (value.startsWith("-")) {
            return value;
        } else {
            return "-" + value;
        }
    }
}
