/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.liance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.fs.viewfs;

import java.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.IOException;

import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.fs.Path;

/**
 * RegexMountPointInterceptor is a mechanism provided to intercept
 * src and resolved path before/after resolution.
 */
@InterfaceAudience.LimitedPrivate("Common")
@InterfaceStability.Unstable
interface RegexMountPointInterceptor {

  /**
   * Initialize interceptor and throws IOException if needed.
   * @throws IOException
   */
  void initialize() throws IOException;

  /**
   * Intercept source before resolution.
   * @param source
   * @return
   */
  String interceptSource(String source);

  /**
   * Intercept parsed dest path and return a new one.
   * @return intercepted string
   */
  String interceptResolvedDestPathStr(String parsedDestPathStr);

  /**
   * Intercept remaining path.
   * @return intercepted string
   */
  Path interceptRemainingPath(Path remainingPath);

  /**
   * Get interceptor type.
   * @return
   */
  RegexMountPointInterceptorType getType();

  /**
   * Serialize the interceptor to a string.
   * @return
   */
  String serializeToString();
}
