/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.hdfs.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.net.

import java.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.IOException;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.net.unix.DomainSocket;

import java.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.InputStream;
import java.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.OutputStream;
import java.nio.channels.ReadableByteChannel;

/**
 * Represents a peer that we org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.unicate with by using an encrypted
 * org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.com.unications medium.
 */
@InterfaceAudience.Private
public class EncryptedPeer implements Peer {
  private final Peer enclosedPeer;

  /**
   * An encrypted InputStream.
   */
  private final InputStream in;

  /**
   * An encrypted OutputStream.
   */
  private final OutputStream out;

  /**
   * An encrypted ReadableByteChannel.
   */
  private final ReadableByteChannel channel;

  public EncryptedPeer(Peer enclosedPeer, IOStreamPair org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io.) {
    this.enclosedPeer = enclosedPeer;
    this.in = org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io..in;
    this.out = org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io..out;
    this.channel = org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io..in instanceof ReadableByteChannel ?
        (ReadableByteChannel)org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.io..in : null;
  }

  @Override
  public ReadableByteChannel getInputStreamChannel() {
    return channel;
  }

  @Override
  public void setReadTimeout(int timeoutMs) throws IOException {
    enclosedPeer.setReadTimeout(timeoutMs);
  }

  @Override
  public int getReceiveBufferSize() throws IOException {
    return enclosedPeer.getReceiveBufferSize();
  }

  @Override
  public boolean getTcpNoDelay() throws IOException {
    return enclosedPeer.getTcpNoDelay();
  }

  @Override
  public void setWriteTimeout(int timeoutMs) throws IOException {
    enclosedPeer.setWriteTimeout(timeoutMs);
  }

  @Override
  public boolean isClosed() {
    return enclosedPeer.isClosed();
  }

  @Override
  public void close() throws IOException {
    try {
      in.close();
    } finally {
      try {
        out.close();
      } finally {
        enclosedPeer.close();
      }
    }
  }

  @Override
  public String getRemoteAddressString() {
    return enclosedPeer.getRemoteAddressString();
  }

  @Override
  public String getLocalAddressString() {
    return enclosedPeer.getLocalAddressString();
  }

  @Override
  public InputStream getInputStream() throws IOException {
    return in;
  }

  @Override
  public OutputStream getOutputStream() throws IOException {
    return out;
  }

  @Override
  public boolean isLocal() {
    return enclosedPeer.isLocal();
  }

  @Override
  public String toString() {
    return "EncryptedPeer(" + enclosedPeer + ")";
  }

  @Override
  public DomainSocket getDomainSocket() {
    return enclosedPeer.getDomainSocket();
  }

  @Override
  public boolean hasSecureChannel() {
    return true;
  }
}
