/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.util.MapRCommonSecurityUtil;

public class YarnDefaultProperties
extends Properties {
    private static final long serialVersionUID = 42L;
    public static final String MAPR_TICKET_EXPIRY = "yarn.mapr.ticket.expiration";
    public static final String DEFAULT_MAPR_TICKET_EXPIRY = "604800000";
    public static final String CLUSTER_PREFIX = "cluster.name.prefix";
    public static final String YARN_DIR = "yarn.dir";
    public static final String DEFAULT_YARN_DIR = System.getProperty("cluster.name.prefix") != null ? "/var/mapr/cluster/yarn" + System.getProperty("cluster.name.prefix") : "/var/mapr/cluster/yarn";
    public static final String RM_DIR = "yarn.resourcemanager.dir";
    public static final String DEFAULT_RM_DIR = DEFAULT_YARN_DIR + "/rm";
    public static final String RM_DIR_VOLUME_SHARDING_ENABLED = "yarn.resourcemanager.dir.volume-sharding.enabled";
    public static final boolean DEFAULT_RM_DIR_VOLUME_SHARDING_ENABLED = false;
    public static final String RM_DIR_VOLUME_NEW_PATH_SUPPORT_ENABLED = "yarn.resourcemanager.dir.new-volume-path-support.enabled";
    public static final boolean DEFAULT_RM_DIR_VOLUME_NEW_PATH_SUPPORT_ENABLED = false;
    public static final String RM_DIR_VOLUME_COUNT = "yarn.resourcemanager.dir.volume-count";
    public static final int DEFAULT_RM_DIR_VOLUME_COUNT = 4;
    public static final String RM_STAGING_DIR = "yarn.resourcemanager.staging";
    public static final String DEFAULT_RM_STAGING_DIR = DEFAULT_RM_DIR + "/staging";
    public static final String RM_SYSTEM_DIR = "yarn.resourcemanager.system";
    public static final String DEFAULT_RM_SYSTEM_DIR = DEFAULT_RM_DIR + "/system";
    public static final String RM_VOLUME_MANAGER_SERVICE = "RMVolumeManager";
    public static final String APP_HISTORY_VOLUME_MANAGER_SERVICE = "HSVolumeManager";
    public static final String APP_HISTORY_STAGING_DIR = "yarn.timeline-service.generic-application-history.staging";
    public static final String DEFAULT_APP_HISTORY_STAGING_DIR = System.getProperty("cluster.name.prefix") != null ? "/var/mapr/cluster/hs" + System.getProperty("cluster.name.prefix") : "/var/mapr/cluster/hs";
    public static final String APACHE_SHUFFLE_SERVICE_ID = "mapreduce_shuffle";
    public static final String MAPR_SHUFFLE_SERVICE_ID = "mapr_direct_shuffle";
    private static final String TIMELINE_AUX_SERVICE_ID = "timeline_collector";
    public static final String FAIR_SCHEDULER_CLASS = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler";
    public static final String FS_DEFAULT_NAME = "maprfs:///";
    public static final String DEFAULT_MAPR_LOCAL_VOL_PATH = "/var/mapr/local";
    private static final boolean isSecurityEnabled = MapRCommonSecurityUtil.getInstance().isSecurityEnabled();
    private static final Map<String, String> props = new HashMap<String, String>();

    public static Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll(props);
        return properties;
    }

    public YarnDefaultProperties() {
        this.putAll(props);
    }

    static {
        props.put("yarn.resourcemanager.principal", "mapr");
        props.put(MAPR_TICKET_EXPIRY, DEFAULT_MAPR_TICKET_EXPIRY);
        if (System.getProperty(CLUSTER_PREFIX) != null) {
            props.put(CLUSTER_PREFIX, System.getProperty(CLUSTER_PREFIX));
        }
        props.put(RM_DIR, DEFAULT_RM_DIR);
        props.put(RM_DIR_VOLUME_COUNT, "4");
        props.put(RM_STAGING_DIR, DEFAULT_RM_STAGING_DIR);
        props.put(RM_SYSTEM_DIR, DEFAULT_RM_SYSTEM_DIR);
        props.put(APP_HISTORY_STAGING_DIR, DEFAULT_APP_HISTORY_STAGING_DIR);
        props.put(YARN_DIR, DEFAULT_YARN_DIR);
        if (isSecurityEnabled) {
            props.put("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        }
        props.put("yarn.nodemanager.external.token.localizer", "org.apache.hadoop.yarn.server.nodemanager.security.MapRTicketLocalizer");
        props.put("yarn.external.token.manager", "org.apache.hadoop.yarn.security.MapRTicketManager");
        props.put("yarn.resourcemanager.aux-services", RM_VOLUME_MANAGER_SERVICE);
        props.put(String.format("yarn.resourcemanager.aux-services.%s.class", RM_VOLUME_MANAGER_SERVICE), "org.apache.hadoop.yarn.server.resourcemanager.RMVolumeManager");
        props.put("yarn.timeline-service.generic-application-history.aux-services", APP_HISTORY_VOLUME_MANAGER_SERVICE);
        props.put(String.format("yarn.resourcemanager.aux-services.%s.class", APP_HISTORY_VOLUME_MANAGER_SERVICE), "org.apache.hadoop.yarn.server.applicationhistoryservice.HSVolumeManager");
        props.put("yarn.resourcemanager.address", "${yarn.resourcemanager.hostname}:8032");
        props.put("yarn.resourcemanager.scheduler.address", "${yarn.resourcemanager.hostname}:8030");
        props.put("yarn.resourcemanager.resource-tracker.address", "${yarn.resourcemanager.hostname}:8031");
        props.put("yarn.nodemanager.resource.memory-mb", "${nodemanager.resource.memory-mb}");
        props.put("yarn.nodemanager.resource.cpu-vcores", "${nodemanager.resource.cpu-vcores}");
        long disk = 2000L;
        if (System.getProperty("nodemanager.resource.io-spindles") != null) {
            disk = (long)(Double.parseDouble(System.getProperty("nodemanager.resource.io-spindles")) * 1000.0);
        }
        props.put("yarn.resource-types", "disks");
        props.put("yarn.nodemanager.resource-type.disks", Long.toString(disk));
        Configuration conf = new Configuration();
        conf.addResource("yarn-site.xml");
        String atsVersion = conf.get("yarn.timeline-service.version");
        if (atsVersion != null && !atsVersion.startsWith("1.")) {
            props.put("yarn.nodemanager.aux-services", "mapreduce_shuffle,mapr_direct_shuffle,timeline_collector");
        } else {
            props.put("yarn.nodemanager.aux-services", "mapreduce_shuffle,mapr_direct_shuffle");
        }
        props.put("yarn.nodemanager.aux-services.mapreduce_shuffle.class", "org.apache.hadoop.mapred.ShuffleHandler");
        props.put("yarn.nodemanager.aux-services.mapr_direct_shuffle.class", "org.apache.hadoop.mapred.LocalVolumeAuxService");
        props.put("yarn.nodemanager.container-executor.class", "org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor");
        props.put("yarn.resourcemanager.store.class", "org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore");
        props.put("yarn.resourcemanager.fs.state-store.uri", DEFAULT_RM_SYSTEM_DIR);
        props.put("yarn.resourcemanager.ha.custom-ha-rmaddressfinder", "org.apache.hadoop.yarn.client.MapRZKBasedRMAddressFinder");
        props.put("yarn.resourcemanager.scheduler.class", FAIR_SCHEDULER_CLASS);
        props.put("yarn.log-aggregation-enable", "false");
        props.put("yarn.use-central-logging-for-mapreduce-only", "false");
        props.put("yarn.dfs-logging.handler-class", "org.apache.hadoop.yarn.util.MapRFSLoggingHandler");
        props.put("yarn.dfs-logging.dir-glob", "maprfs:////var/mapr/local/*/logs/yarn/userlogs");
        props.put("yarn.log-aggregation.retain-seconds", "2592000");
    }
}

