/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.openjdk.jmh.util.AbstractStatistics;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;

public class MultisetStatistics
extends AbstractStatistics {
    private static final long serialVersionUID = -4401871054963903938L;
    private final Multiset<Double> values = new TreeMultiset<Double>();

    public void addValue(double d, long count) {
        this.values.add(d, count);
    }

    @Override
    public double getMax() {
        if (!this.values.isEmpty()) {
            double max = Double.NEGATIVE_INFINITY;
            for (double d : this.values.keys()) {
                max = Math.max(max, d);
            }
            return max;
        }
        return Double.NaN;
    }

    @Override
    public double getMin() {
        if (!this.values.isEmpty()) {
            double min2 = Double.POSITIVE_INFINITY;
            for (double d : this.values.keys()) {
                min2 = Math.min(min2, d);
            }
            return min2;
        }
        return Double.NaN;
    }

    @Override
    public long getN() {
        return this.values.size();
    }

    @Override
    public double getSum() {
        if (!this.values.isEmpty()) {
            double sum = 0.0;
            for (double d : this.values.keys()) {
                sum += d * (double)this.values.count(d);
            }
            return sum;
        }
        return Double.NaN;
    }

    private double get(long index) {
        long cur = 0L;
        for (double d : this.values.keys()) {
            if ((cur += this.values.count(d)) < index) continue;
            return d;
        }
        return this.getMax();
    }

    @Override
    public double getPercentile(double rank) {
        if (rank < 0.0 || rank > 100.0) {
            throw new IllegalArgumentException("Rank should be within [0; 100]");
        }
        if (rank == 0.0) {
            return this.getMin();
        }
        double pos = rank * (double)(this.values.size() + 1L) / 100.0;
        double floorPos = Math.floor(pos);
        double flooredValue = this.get((long)floorPos);
        double nextValue = this.get((long)floorPos + 1L);
        return flooredValue + (nextValue - flooredValue) * (pos - floorPos);
    }

    @Override
    public double getVariance() {
        if (this.getN() > 0L) {
            double v = 0.0;
            double m4 = this.getMean();
            for (double d : this.values.keys()) {
                v += Math.pow(d - m4, 2.0) * (double)this.values.count(d);
            }
            return v / (double)(this.getN() - 1L);
        }
        return Double.NaN;
    }

    @Override
    public int[] getHistogram(double[] levels) {
        if (levels.length < 2) {
            throw new IllegalArgumentException("Expected more than two levels");
        }
        ArrayList<Double> vs = new ArrayList<Double>(this.values.keys());
        Collections.sort(vs);
        int[] result = new int[levels.length - 1];
        int c = 0;
        Iterator iterator = vs.iterator();
        block0: while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            while (levels[c] > v || v >= levels[c + 1]) {
                if (++c <= levels.length - 2) continue;
                break block0;
            }
            int n = c;
            result[n] = (int)((long)result[n] + this.values.count(v));
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Double, Long>> getRawData() {
        return this.values.entrySet().iterator();
    }
}

