/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.Utils;

public class OCSPStatusRequest {
    protected Vector responderIDList;
    protected Extensions requestExtensions;

    public OCSPStatusRequest(Vector responderIDList, Extensions requestExtensions) {
        this.responderIDList = responderIDList;
        this.requestExtensions = requestExtensions;
    }

    public Vector getResponderIDList() {
        return this.responderIDList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void encode(OutputStream output) throws IOException {
        if (this.responderIDList == null || this.responderIDList.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            for (int i = 0; i < this.responderIDList.size(); ++i) {
                ResponderID responderID = (ResponderID)this.responderIDList.elementAt(i);
                byte[] derEncoding = responderID.getEncoded("DER");
                TlsUtils.writeOpaque16(derEncoding, buf);
            }
            TlsUtils.checkUint16(buf.size());
            TlsUtils.writeUint16(buf.size(), output);
            Utils.writeBufTo(buf, output);
        }
        if (this.requestExtensions == null) {
            TlsUtils.writeUint16(0, output);
        } else {
            byte[] derEncoding = this.requestExtensions.getEncoded("DER");
            TlsUtils.checkUint16(derEncoding.length);
            TlsUtils.writeUint16(derEncoding.length, output);
            output.write(derEncoding);
        }
    }

    public static OCSPStatusRequest parse(InputStream input) throws IOException {
        Vector<ResponderID> responderIDList = new Vector<ResponderID>();
        byte[] data = TlsUtils.readOpaque16(input);
        if (data.length > 0) {
            ByteArrayInputStream buf = new ByteArrayInputStream(data);
            do {
                byte[] derEncoding = TlsUtils.readOpaque16(buf, 1);
                ASN1Primitive asn1 = TlsUtils.readASN1Object(derEncoding);
                ResponderID responderID = ResponderID.getInstance(asn1);
                TlsUtils.requireDEREncoding(responderID, derEncoding);
                responderIDList.addElement(responderID);
            } while (buf.available() > 0);
        }
        Extensions requestExtensions = null;
        byte[] derEncoding = TlsUtils.readOpaque16(input);
        if (derEncoding.length > 0) {
            ASN1Primitive asn1 = TlsUtils.readASN1Object(derEncoding);
            Extensions extensions = Extensions.getInstance(asn1);
            TlsUtils.requireDEREncoding(extensions, derEncoding);
            requestExtensions = extensions;
        }
        return new OCSPStatusRequest(responderIDList, requestExtensions);
    }
}

