/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Integers;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext context) {
        this.context = context;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    public void copyBufferTo(OutputStream output) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyInputTo(output);
    }

    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    public void notifyPRFDetermined() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.checkTrackingHash(1);
                this.checkTrackingHash(2);
                break;
            }
            default: {
                this.checkTrackingHash(securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
    }

    public void trackHashAlgorithm(int cryptoHashAlgorithm) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(cryptoHashAlgorithm);
    }

    public void sealHashAlgorithms() {
        if (this.sealed) {
            throw new IllegalStateException("Already sealed");
        }
        this.sealed = true;
        this.checkStopBuffering();
    }

    public void stopTracking() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Hashtable newHashes = new Hashtable();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.cloneHash(newHashes, 1);
                this.cloneHash(newHashes, 2);
                break;
            }
            default: {
                this.cloneHash(newHashes, securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
        this.buf = null;
        this.hashes = newHashes;
        this.forceBuffering = false;
        this.sealed = true;
    }

    public TlsHash forkPRFHash() {
        TlsHash prfHash;
        this.checkStopBuffering();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                TlsHash md5Hash = this.cloneHash(1);
                TlsHash sha1Hash = this.cloneHash(2);
                prfHash = new CombinedHash(this.context, md5Hash, sha1Hash);
                break;
            }
            default: {
                prfHash = this.cloneHash(securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
        if (this.buf != null) {
            this.buf.updateDigest(prfHash);
        }
        return prfHash;
    }

    public byte[] getFinalHash(int cryptoHashAlgorithm) {
        TlsHash hash = (TlsHash)this.hashes.get(this.box(cryptoHashAlgorithm));
        if (hash == null) {
            throw new IllegalStateException("CryptoHashAlgorithm." + cryptoHashAlgorithm + " is not being tracked");
        }
        this.checkStopBuffering();
        hash = hash.cloneHash();
        if (this.buf != null) {
            this.buf.updateDigest(hash);
        }
        return hash.calculateHash();
    }

    public void update(byte[] input, int inOff, int len) {
        if (this.buf != null) {
            this.buf.write(input, inOff, len);
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = (TlsHash)e.nextElement();
            hash.update(input, inOff, len);
        }
    }

    public byte[] calculateHash() {
        throw new IllegalStateException("Use 'forkPRFHash' to get a definite hash");
    }

    public TlsHash cloneHash() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = (TlsHash)e.nextElement();
            hash.reset();
        }
    }

    protected Integer box(int cryptoHashAlgorithm) {
        return Integers.valueOf(cryptoHashAlgorithm);
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration e = this.hashes.elements();
            while (e.hasMoreElements()) {
                TlsHash hash = (TlsHash)e.nextElement();
                this.buf.updateDigest(hash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(int cryptoHashAlgorithm) {
        this.checkTrackingHash(this.box(cryptoHashAlgorithm));
    }

    protected void checkTrackingHash(Integer cryptoHashAlgorithm) {
        if (!this.hashes.containsKey(cryptoHashAlgorithm)) {
            TlsHash hash = this.context.getCrypto().createHash(cryptoHashAlgorithm);
            this.hashes.put(cryptoHashAlgorithm, hash);
        }
    }

    protected TlsHash cloneHash(int cryptoHashAlgorithm) {
        return this.cloneHash(this.box(cryptoHashAlgorithm));
    }

    protected TlsHash cloneHash(Integer cryptoHashAlgorithm) {
        return ((TlsHash)this.hashes.get(cryptoHashAlgorithm)).cloneHash();
    }

    protected void cloneHash(Hashtable newHashes, int cryptoHashAlgorithm) {
        this.cloneHash(newHashes, this.box(cryptoHashAlgorithm));
    }

    protected void cloneHash(Hashtable newHashes, Integer cryptoHashAlgorithm) {
        TlsHash hash = this.cloneHash(cryptoHashAlgorithm);
        if (this.buf != null) {
            this.buf.updateDigest(hash);
        }
        newHashes.put(cryptoHashAlgorithm, hash);
    }
}

