/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectionUtil {
    ReflectionUtil() {
    }

    static Method findMethod(Method[] methods, String name) {
        if (methods != null) {
            for (Method m4 : methods) {
                if (!m4.getName().equals(name)) continue;
                return m4;
            }
        }
        return null;
    }

    static boolean hasMethod(Method[] methods, String name) {
        return null != ReflectionUtil.findMethod(methods, name);
    }

    static Class<?> getClass(String className) {
        if (null == className) {
            return null;
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    return clazz;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static <T> Constructor<T> getDeclaredConstructor(String className, Class<?> ... parameterTypes) {
        if (null == className) {
            return null;
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getDeclaredConstructor(classArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method getMethod(String className, String methodName, Class<?> ... parameterTypes) {
        if (null == className || null == methodName) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getMethod(string2, classArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method[] getMethods(String className) {
        if (null == className) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getMethods();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticInt(String className, String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    Class<?> fieldType;
                    Field field;
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz && null != (field = clazz.getField(string2)) && Integer.TYPE == (fieldType = field.getType())) {
                        return field.getInt(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticIntOrDefault(String className, String fieldName, int defaultValue) {
        Integer value = ReflectionUtil.getStaticInt(className, fieldName);
        return null == value ? defaultValue : value;
    }

    static Object invokeGetter(Object obj, Method method) {
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    static Object invokeMethod(Object obj, Method method, Object ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(object, objectArray);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static void invokeSetter(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeMethod(obj, method, arg);
    }
}

