/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.OutputDigestCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.general.GOST3411Digest;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralDigestAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedDigestOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.MD5Digest;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.RIPEMD128Digest;
import org.bouncycastle.crypto.general.RIPEMD160Digest;
import org.bouncycastle.crypto.general.RIPEMD256Digest;
import org.bouncycastle.crypto.general.RIPEMD320Digest;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.TigerDigest;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.WhirlpoolDigest;
import org.bouncycastle.crypto.internal.CipherKeyGenerator;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.macs.TruncatingMac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecureHash {
    private static final Map<GeneralAlgorithm, Integer> defaultMacSize = new HashMap<GeneralAlgorithm, Integer>();
    public static final Parameters MD5;
    public static final AuthParameters MD5_HMAC;
    public static final Parameters GOST3411;
    public static final AuthParameters GOST3411_HMAC;
    public static final Parameters RIPEMD128;
    public static final AuthParameters RIPEMD128_HMAC;
    public static final Parameters RIPEMD160;
    public static final AuthParameters RIPEMD160_HMAC;
    public static final Parameters RIPEMD256;
    public static final AuthParameters RIPEMD256_HMAC;
    public static final Parameters RIPEMD320;
    public static final AuthParameters RIPEMD320_HMAC;
    public static final Parameters TIGER;
    public static final AuthParameters TIGER_HMAC;
    public static final Parameters WHIRLPOOL;
    public static final AuthParameters WHIRLPOOL_HMAC;

    private SecureHash() {
    }

    private static Mac getMac(GeneralAlgorithm generalAlgorithm) {
        Mac mac;
        switch ((Variations)generalAlgorithm.basicVariation()) {
            case GOST3411_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new GOST3411Digest()), new HMacKatTest(Hex.decode("ec352aec8da53f0626fe22699243266ed40da2beff219dfd7dd2dcf3d86ebbc9")));
                break;
            }
            case RIPEMD128_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new RIPEMD128Digest()), new HMacKatTest(Hex.decode("875f828862b6b334b427c55f9f7ff09b")));
                break;
            }
            case RIPEMD160_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new RIPEMD160Digest()), new HMacKatTest(Hex.decode("dda6c0213a485a9e24f4742064a7f033b43c4069")));
                break;
            }
            case RIPEMD256_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new RIPEMD256Digest()), new HMacKatTest(Hex.decode("932d3e799272765675dd63c33f8d2815ea38181494f43271dd52fde91392619f")));
                break;
            }
            case RIPEMD320_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new RIPEMD320Digest()), new HMacKatTest(Hex.decode("e440b00b6326e4f7dad3a6591e8189e9708fc17e3cab306fc67efaf70947aad2ea89e28f79d03bd3")));
                break;
            }
            case TIGER_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new TigerDigest()), new HMacKatTest(Hex.decode("3a351b1dec6075d6290e68b604e553821edc39041b82da83")));
                break;
            }
            case MD5_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new MD5Digest()), new HMacKatTest(Hex.decode("750c783e6ab0b503eaa86e310a5db738")));
                break;
            }
            case WHIRLPOOL_HMAC: {
                mac = SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new HMac(new WhirlpoolDigest()), new HMacKatTest(Hex.decode("3d595ccd1d4f4cfd045af53ba7d5c8283fee6ded6eaf1269071b6b4ea64800056b5077c6a942cfa1221bd4e5aed791276e5dd46a407d2b8007163d3e7cd1de66")));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createMAC: " + generalAlgorithm.getName());
            }
        }
        return mac;
    }

    private static DigestCloner<Digest> createCloner(final GeneralAlgorithm generalAlgorithm) {
        switch ((Variations)generalAlgorithm.basicVariation()) {
            case MD5: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new MD5Digest((MD5Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new MD5Digest(), new DigestKatTest(Hex.decode("900150983cd24fb0d6963f7d28e17f72")));
                    }
                };
            }
            case GOST3411: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new GOST3411Digest((GOST3411Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new GOST3411Digest(), new DigestKatTest(Hex.decode("b285056dbf18d7392d7677369524dd14747459ed8143997e163b2986f92fd42c")));
                    }
                };
            }
            case RIPEMD128: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new RIPEMD128Digest((RIPEMD128Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new RIPEMD128Digest(), new DigestKatTest(Hex.decode("c14a12199c66e4ba84636b0f69144c77")));
                    }
                };
            }
            case RIPEMD160: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new RIPEMD160Digest((RIPEMD160Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new RIPEMD160Digest(), new DigestKatTest(Hex.decode("8eb208f7e05d987a9b044a8e98c6b087f15a0bfc")));
                    }
                };
            }
            case RIPEMD256: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new RIPEMD256Digest((RIPEMD256Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new RIPEMD256Digest(), new DigestKatTest(Hex.decode("afbd6e228b9d8cbbcef5ca2d03e6dba10ac0bc7dcbe4680e1e42d2e975459b65")));
                    }
                };
            }
            case RIPEMD320: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new RIPEMD320Digest((RIPEMD320Digest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new RIPEMD320Digest(), new DigestKatTest(Hex.decode("de4c01b3054f8930a79d09ae738e92301e5a17085beffdc1b8d116713e74f82fa942d64cdbc4682d")));
                    }
                };
            }
            case TIGER: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new TigerDigest((TigerDigest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new TigerDigest(), new DigestKatTest(Hex.decode("2aab1484e8c158f2bfb8c5ff41b57a525129131c957b5f93")));
                    }
                };
            }
            case WHIRLPOOL: {
                return new DigestCloner<Digest>(){

                    @Override
                    public Digest makeDigest(Digest digest) {
                        if (digest != null) {
                            return new WhirlpoolDigest((WhirlpoolDigest)digest);
                        }
                        return SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)generalAlgorithm, new WhirlpoolDigest(), new DigestKatTest(Hex.decode("4e2448a4c6f486bb16b6562c73b4020bf3043e3a731bce721ae1b303d97e6d4c7181eebdb6c57e277d0e34957114cbd6c797fc9d95d8b582d225292076d4eef5")));
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unknown algorithm passed to SecureHash.OperatorFactory.createOutputDigestCalculator: " + generalAlgorithm.getName());
    }

    static Digest createDigest(GeneralDigestAlgorithm generalDigestAlgorithm) {
        return SecureHash.createCloner(generalDigestAlgorithm).makeDigest(null);
    }

    static Mac createHMac(GeneralDigestAlgorithm generalDigestAlgorithm) {
        return SecureHash.getMac(generalDigestAlgorithm);
    }

    static {
        defaultMacSize.put(Algorithm.MD5_HMAC, 128);
        defaultMacSize.put(Algorithm.GOST3411_HMAC, 256);
        defaultMacSize.put(Algorithm.RIPEMD128_HMAC, 128);
        defaultMacSize.put(Algorithm.RIPEMD160_HMAC, 160);
        defaultMacSize.put(Algorithm.RIPEMD256_HMAC, 256);
        defaultMacSize.put(Algorithm.RIPEMD320_HMAC, 320);
        defaultMacSize.put(Algorithm.TIGER_HMAC, 192);
        defaultMacSize.put(Algorithm.WHIRLPOOL_HMAC, 512);
        MD5 = new Parameters(Algorithm.MD5);
        MD5_HMAC = new AuthParameters(Algorithm.MD5_HMAC);
        GOST3411 = new Parameters(Algorithm.GOST3411);
        GOST3411_HMAC = new AuthParameters(Algorithm.GOST3411_HMAC);
        RIPEMD128 = new Parameters(Algorithm.RIPEMD128);
        RIPEMD128_HMAC = new AuthParameters(Algorithm.RIPEMD128_HMAC);
        RIPEMD160 = new Parameters(Algorithm.RIPEMD160);
        RIPEMD160_HMAC = new AuthParameters(Algorithm.RIPEMD160_HMAC);
        RIPEMD256 = new Parameters(Algorithm.RIPEMD256);
        RIPEMD256_HMAC = new AuthParameters(Algorithm.RIPEMD256_HMAC);
        RIPEMD320 = new Parameters(Algorithm.RIPEMD320);
        RIPEMD320_HMAC = new AuthParameters(Algorithm.RIPEMD320_HMAC);
        TIGER = new Parameters(Algorithm.TIGER);
        TIGER_HMAC = new AuthParameters(Algorithm.TIGER_HMAC);
        WHIRLPOOL = new Parameters(Algorithm.WHIRLPOOL);
        WHIRLPOOL_HMAC = new AuthParameters(Algorithm.WHIRLPOOL_HMAC);
    }

    public static final class Algorithm {
        public static final GeneralDigestAlgorithm MD5 = new GeneralDigestAlgorithm("MD5", (Enum)Variations.MD5);
        public static final GeneralDigestAlgorithm MD5_HMAC = new GeneralDigestAlgorithm("MD5/HMAC", (Enum)Variations.MD5_HMAC);
        public static final GeneralDigestAlgorithm GOST3411 = new GeneralDigestAlgorithm("GOST3411", (Enum)Variations.GOST3411);
        public static final GeneralDigestAlgorithm GOST3411_HMAC = new GeneralDigestAlgorithm("GOST3411/HMAC", (Enum)Variations.GOST3411_HMAC);
        public static final GeneralDigestAlgorithm RIPEMD128 = new GeneralDigestAlgorithm("RIPEMD128", (Enum)Variations.RIPEMD128);
        public static final GeneralDigestAlgorithm RIPEMD128_HMAC = new GeneralDigestAlgorithm("RIPEMD128/HMAC", (Enum)Variations.RIPEMD128_HMAC);
        public static final GeneralDigestAlgorithm RIPEMD160 = new GeneralDigestAlgorithm("RIPEMD160", (Enum)Variations.RIPEMD160);
        public static final GeneralDigestAlgorithm RIPEMD160_HMAC = new GeneralDigestAlgorithm("RIPEMD160/HMAC", (Enum)Variations.RIPEMD160_HMAC);
        public static final GeneralDigestAlgorithm RIPEMD256 = new GeneralDigestAlgorithm("RIPEMD256", (Enum)Variations.RIPEMD256);
        public static final GeneralDigestAlgorithm RIPEMD256_HMAC = new GeneralDigestAlgorithm("RIPEMD256/HMAC", (Enum)Variations.RIPEMD256_HMAC);
        public static final GeneralDigestAlgorithm RIPEMD320 = new GeneralDigestAlgorithm("RIPEMD320", (Enum)Variations.RIPEMD320);
        public static final GeneralDigestAlgorithm RIPEMD320_HMAC = new GeneralDigestAlgorithm("RIPEMD320/HMAC", (Enum)Variations.RIPEMD320_HMAC);
        public static final GeneralDigestAlgorithm TIGER = new GeneralDigestAlgorithm("TIGER", (Enum)Variations.TIGER);
        public static final GeneralDigestAlgorithm TIGER_HMAC = new GeneralDigestAlgorithm("TIGER/HMAC", (Enum)Variations.TIGER_HMAC);
        public static final GeneralDigestAlgorithm WHIRLPOOL = new GeneralDigestAlgorithm("WHIRLPOOL", (Enum)Variations.WHIRLPOOL);
        public static final GeneralDigestAlgorithm WHIRLPOOL_HMAC = new GeneralDigestAlgorithm("WHIRLPOOL/HMAC", (Enum)Variations.WHIRLPOOL_HMAC);

        private Algorithm() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(GeneralAlgorithm generalAlgorithm, int n) {
            super(generalAlgorithm);
            this.macSizeInBits = n;
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, (Integer)defaultMacSize.get(generalAlgorithm));
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int n) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DigestCloner<D extends Digest> {
        public D makeDigest(D var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DigestKatTest
    implements BasicKatTest<Digest> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        DigestKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HMacKatTest
    implements BasicKatTest<Mac> {
        private static final byte[] stdHMacVector = Strings.toByteArray("what do ya want for nothing?");
        private static final byte[] key = Hex.decode("4a656665");
        private final byte[] kat;

        HMacKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Mac mac) {
            mac.init(new KeyParameterImpl(Arrays.clone(key)));
            mac.update(stdHMacVector, 0, stdHMacVector.length);
            byte[] byArray = new byte[mac.getMacSize()];
            mac.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator<Parameters> {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(GeneralAlgorithm generalAlgorithm, int n, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalOutputDigestCalculator<T extends GeneralParameters>
    implements Cloneable,
    OutputDigestCalculator<T> {
        private final Digest digest;
        private final T parameter;
        private final DigestCloner<Digest> cloner;

        private LocalOutputDigestCalculator(T t2, DigestCloner<Digest> digestCloner) {
            this(t2, null, digestCloner);
        }

        private LocalOutputDigestCalculator(T t2, Digest digest, DigestCloner<Digest> digestCloner) {
            this.digest = digestCloner.makeDigest(digest);
            this.parameter = t2;
            this.cloner = digestCloner;
        }

        @Override
        public T getParameters() {
            Utils.approveModeCheck(((GeneralParameters)this.parameter).getAlgorithm());
            return this.parameter;
        }

        @Override
        public int getDigestSize() {
            Utils.approveModeCheck(((GeneralParameters)this.parameter).getAlgorithm());
            return this.digest.getDigestSize();
        }

        @Override
        public int getDigestBlockSize() {
            Utils.approveModeCheck(((GeneralParameters)this.parameter).getAlgorithm());
            return this.digest.getByteLength();
        }

        @Override
        public UpdateOutputStream getDigestStream() {
            return new DigestOutputStream(this.digest);
        }

        @Override
        public final byte[] getDigest() {
            byte[] byArray = new byte[this.getDigestSize()];
            this.getDigest(byArray, 0);
            return byArray;
        }

        @Override
        public final int getDigest(byte[] byArray, int n) {
            return this.digest.doFinal(byArray, n);
        }

        @Override
        public void reset() {
            this.digest.reset();
        }

        @Override
        public OutputDigestCalculator<T> clone() throws CloneNotSupportedException {
            super.clone();
            return new LocalOutputDigestCalculator<T>(this.parameter, this.digest, this.cloner);
        }

        /* synthetic */ LocalOutputDigestCalculator(GeneralParameters generalParameters, DigestCloner digestCloner, 1 var3_3) {
            this(generalParameters, digestCloner);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return SecureHash.getMac((GeneralAlgorithm)authParameters.getAlgorithm()).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = SecureHash.getMac((GeneralAlgorithm)authParameters.getAlgorithm());
            if (mac.getMacSize() != (authParameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, authParameters.macSizeInBits);
            }
            ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
            mac.init(Utils.getKeyParameter(validatedSymmetricKey));
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedDigestOperatorFactory<GeneralParameters> {
        @Override
        public OutputDigestCalculator<GeneralParameters> createOutputDigestCalculator(GeneralParameters generalParameters) {
            return new LocalOutputDigestCalculator<GeneralParameters>(generalParameters, SecureHash.createCloner((GeneralAlgorithm)generalParameters.getAlgorithm()), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        MD5,
        MD5_HMAC,
        GOST3411,
        GOST3411_HMAC,
        RIPEMD128,
        RIPEMD128_HMAC,
        RIPEMD160,
        RIPEMD160_HMAC,
        RIPEMD256,
        RIPEMD256_HMAC,
        RIPEMD320,
        RIPEMD320_HMAC,
        TIGER,
        TIGER_HMAC,
        WHIRLPOOL,
        WHIRLPOOL_HMAC;

    }
}

