/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcRecoverableException;
import org.apache.kerby.kerberos.kerb.server.request.AsRequest;
import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.server.request.TgsRequest;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.KrbError;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.kdc.TgsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdcHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KdcHandler.class);
    private final KdcContext kdcContext;

    public KdcHandler(KdcContext kdcContext) {
        this.kdcContext = kdcContext;
    }

    public ByteBuffer handleMessage(ByteBuffer receivedMessage, boolean isTcp, InetAddress remoteAddress) throws KrbException {
        ByteBuffer responseMessage;
        KrbMessage krbResponse;
        KrbMessage krbRequest;
        KdcRequest kdcRequest = null;
        ByteBuffer message = receivedMessage.duplicate();
        try {
            krbRequest = KrbCodec.decodeMessage(receivedMessage);
        }
        catch (IOException e) {
            LOG.error("Krb decoding message failed", e);
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_MSG_TYPE, "Krb decoding message failed");
        }
        KrbMessageType messageType = krbRequest.getMsgType();
        if (messageType == KrbMessageType.TGS_REQ || messageType == KrbMessageType.AS_REQ) {
            KdcReq kdcReq = (KdcReq)krbRequest;
            String realm = this.getRequestRealm(kdcReq);
            if (realm == null || !this.kdcContext.getKdcRealm().equals(realm)) {
                LOG.error("Invalid realm from kdc request: " + realm);
                throw new KrbException(KrbErrorCode.WRONG_REALM, "Invalid realm from kdc request: " + realm);
            }
            if (messageType == KrbMessageType.TGS_REQ) {
                kdcRequest = new TgsRequest((TgsReq)kdcReq, this.kdcContext);
            } else if (messageType == KrbMessageType.AS_REQ) {
                kdcRequest = new AsRequest((AsReq)kdcReq, this.kdcContext);
            } else {
                LOG.error("Invalid message type: " + messageType);
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_MSG_TYPE);
            }
        }
        if (kdcRequest == null) {
            throw new KrbException("Kdc request is null.");
        }
        kdcRequest.setReqPackage(message);
        if (remoteAddress == null) {
            throw new KrbException("Remote address is null, not available.");
        }
        kdcRequest.setClientAddress(remoteAddress);
        kdcRequest.isTcp(isTcp);
        try {
            kdcRequest.process();
            krbResponse = kdcRequest.getReply();
        }
        catch (Throwable e) {
            if (e instanceof KdcRecoverableException) {
                krbResponse = this.handleRecoverableException((KdcRecoverableException)e, kdcRequest);
            }
            KrbError krbError = new KrbError();
            krbError.setStime(KerberosTime.now());
            krbError.setSusec(100);
            KrbErrorCode errorCode = KrbErrorCode.UNKNOWN_ERR;
            if (e instanceof KrbException && ((KrbException)e).getKrbErrorCode() != null) {
                errorCode = ((KrbException)e).getKrbErrorCode();
            }
            krbError.setErrorCode(errorCode);
            krbError.setCrealm(this.kdcContext.getKdcRealm());
            if (kdcRequest.getClientPrincipal() != null) {
                krbError.setCname(kdcRequest.getClientPrincipal());
            }
            krbError.setRealm(this.kdcContext.getKdcRealm());
            if (kdcRequest.getServerPrincipal() != null) {
                krbError.setSname(kdcRequest.getServerPrincipal());
            } else {
                PrincipalName serverPrincipal = kdcRequest.getKdcReq().getReqBody().getSname();
                serverPrincipal.setRealm(kdcRequest.getKdcReq().getReqBody().getRealm());
                krbError.setSname(serverPrincipal);
            }
            if (KrbErrorCode.KRB_AP_ERR_BAD_INTEGRITY.equals(errorCode)) {
                krbError.setEtext("PREAUTH_FAILED");
            } else {
                krbError.setEtext(e.getMessage());
            }
            krbResponse = krbError;
        }
        int bodyLen = krbResponse.encodingLength();
        if (isTcp) {
            responseMessage = ByteBuffer.allocate(bodyLen + 4);
            responseMessage.putInt(bodyLen);
        } else {
            responseMessage = ByteBuffer.allocate(bodyLen);
        }
        KrbCodec.encode(krbResponse, responseMessage);
        responseMessage.flip();
        return responseMessage;
    }

    private KrbMessage handleRecoverableException(KdcRecoverableException e, KdcRequest kdcRequest) throws KrbException {
        LOG.info("KRB error occurred while processing request: " + e.getMessage());
        KrbError error = e.getKrbError();
        error.setStime(KerberosTime.now());
        error.setSusec(100);
        error.setErrorCode(e.getKrbError().getErrorCode());
        error.setRealm(this.kdcContext.getKdcRealm());
        if (kdcRequest != null) {
            error.setSname(kdcRequest.getKdcReq().getReqBody().getCname());
        } else {
            error.setSname(new PrincipalName("NONE"));
        }
        error.setEtext(e.getMessage());
        return error;
    }

    private String getRequestRealm(KdcReq kdcReq) {
        String realm = kdcReq.getReqBody().getRealm();
        if (realm == null && kdcReq.getReqBody().getCname() != null) {
            realm = kdcReq.getReqBody().getCname().getRealm();
        }
        return realm;
    }
}

