/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.kerby.util.IOUtil;

public class Krb5Conf {
    public static final String KRB5_CONF = "java.security.krb5.conf";
    private static final String KRB5_CONF_FILE = "krb5.conf";
    private SimpleKdcServer kdcServer;
    private File confFile;

    public Krb5Conf(SimpleKdcServer kdcServer) {
        this.kdcServer = kdcServer;
    }

    public void initKrb5conf() throws IOException {
        File confFile = this.generateConfFile();
        System.setProperty(KRB5_CONF, confFile.getAbsolutePath());
    }

    private File generateConfFile() throws IOException {
        String templateContent;
        KdcSetting setting = this.kdcServer.getKdcSetting();
        String resourcePath = setting.allowUdp() ? "/krb5_udp-template.conf" : "/krb5-template.conf";
        try (InputStream templateResource = this.getClass().getResourceAsStream(resourcePath);){
            templateContent = IOUtil.readInput(templateResource);
        }
        String content = templateContent;
        content = content.replaceAll("_REALM_", "" + setting.getKdcRealm());
        int kdcPort = setting.allowUdp() ? setting.getKdcUdpPort() : setting.getKdcTcpPort();
        content = content.replaceAll("_KDC_PORT_", String.valueOf(kdcPort));
        if (setting.allowTcp()) {
            content = content.replaceAll("#_KDC_TCP_PORT_", "kdc_tcp_port = " + setting.getKdcTcpPort());
        }
        if (setting.allowUdp()) {
            content = content.replaceAll("#_KDC_UDP_PORT_", "kdc_udp_port = " + setting.getKdcUdpPort());
        }
        int udpLimit = setting.allowUdp() ? 4096 : 1;
        content = content.replaceAll("_UDP_LIMIT_", String.valueOf(udpLimit));
        this.confFile = new File(this.kdcServer.getWorkDir(), KRB5_CONF_FILE);
        IOUtil.writeFile(content, this.confFile);
        return this.confFile;
    }

    public void deleteKrb5conf() throws IOException {
        if (!this.confFile.delete()) {
            throw new IOException();
        }
    }
}

