/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.SocketFactory;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.AsyncCallLimitExceededException;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.apache.hadoop.ipc.RpcClientException;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.ipc.RpcException;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.tracing.Span;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.ProtoUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Client
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final AtomicInteger callIdCounter = new AtomicInteger();
    private static final ThreadLocal<Integer> callId = new ThreadLocal();
    private static final ThreadLocal<Integer> retryCount = new ThreadLocal();
    private static final ThreadLocal<Object> EXTERNAL_CALL_HANDLER = new ThreadLocal();
    private static final ThreadLocal<AsyncGet<? extends Writable, IOException>> ASYNC_RPC_RESPONSE = new ThreadLocal();
    private static final ThreadLocal<Boolean> asynchronousMode = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ConcurrentMap<ConnectionId, Connection> connections = new ConcurrentHashMap<ConnectionId, Connection>();
    private final Object putLock = new Object();
    private final Object emptyCondition = new Object();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private Class<? extends Writable> valueClass;
    private final Configuration conf;
    private SocketFactory socketFactory;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final int connectionTimeout;
    private final boolean fallbackAllowed;
    private final boolean bindToWildCardAddress;
    private final byte[] clientId;
    private final int maxAsyncCalls;
    private final AtomicInteger asyncCallCounter = new AtomicInteger(0);

    @InterfaceStability.Unstable
    public static <T extends Writable> AsyncGet<T, IOException> getAsyncRpcResponse() {
        return ASYNC_RPC_RESPONSE.get();
    }

    public static void setCallIdAndRetryCount(int cid, int rc, Object externalHandler) {
        Preconditions.checkArgument(cid != -2);
        Preconditions.checkState(callId.get() == null);
        Preconditions.checkArgument(rc != -1);
        Client.setCallIdAndRetryCountUnprotected(cid, rc, externalHandler);
    }

    public static void setCallIdAndRetryCountUnprotected(Integer cid, int rc, Object externalHandler) {
        callId.set(cid);
        retryCount.set(rc);
        EXTERNAL_CALL_HANDLER.set(externalHandler);
    }

    public static int getCallId() {
        return callId.get() != null ? callId.get() : Client.nextCallId();
    }

    public static int getRetryCount() {
        return retryCount.get() != null ? retryCount.get() : 0;
    }

    public static Object getExternalHandler() {
        return EXTERNAL_CALL_HANDLER.get();
    }

    public static final void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt("ipc.ping.interval", pingInterval);
    }

    public static final int getPingInterval(Configuration conf) {
        return conf.getInt("ipc.ping.interval", 60000);
    }

    @Deprecated
    public static final int getTimeout(Configuration conf) {
        int timeout = Client.getRpcTimeout(conf);
        if (timeout > 0) {
            return timeout;
        }
        if (!conf.getBoolean("ipc.client.ping", true)) {
            return Client.getPingInterval(conf);
        }
        return -1;
    }

    public static final int getRpcTimeout(Configuration conf) {
        int timeout = conf.getInt("ipc.client.rpc-timeout.ms", 0);
        return timeout < 0 ? 0 : timeout;
    }

    public static final void setConnectTimeout(Configuration conf, int timeout) {
        conf.setInt("ipc.client.connect.timeout", timeout);
    }

    void incCount() {
        this.refCount.incrementAndGet();
    }

    int decAndGetCount() {
        return this.refCount.decrementAndGet();
    }

    void checkResponse(RpcHeaderProtos.RpcResponseHeaderProto header) throws IOException {
        byte[] id;
        if (header == null) {
            throw new EOFException("Response is null.");
        }
        if (header.hasClientId() && !Arrays.equals(id = header.getClientId().toByteArray(), RpcConstants.DUMMY_CLIENT_ID) && !Arrays.equals(id, this.clientId)) {
            throw new IOException("Client IDs not matched: local ID=" + StringUtils.byteToHexString(this.clientId) + ", ID in response=" + StringUtils.byteToHexString(header.getClientId().toByteArray()));
        }
    }

    Call createCall(RPC.RpcKind rpcKind, Writable rpcRequest) {
        return new Call(rpcKind, rpcRequest);
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.conf = conf;
        this.socketFactory = factory;
        this.connectionTimeout = conf.getInt("ipc.client.connect.timeout", 20000);
        this.fallbackAllowed = conf.getBoolean("ipc.client.fallback-to-simple-auth-allowed", false);
        this.bindToWildCardAddress = conf.getBoolean("ipc.client.bind.wildcard.addr", false);
        this.clientId = ClientId.getClientId();
        this.maxAsyncCalls = conf.getInt("ipc.client.async.calls.max", 100);
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + StringUtils.byteToHexString(this.clientId);
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping client");
        }
        Object object = this.putLock;
        synchronized (object) {
            if (!this.running.compareAndSet(true, false)) {
                return;
            }
        }
        for (Connection conn : this.connections.values()) {
            conn.interrupt();
            conn.rpcRequestThread.interrupt();
            conn.interruptConnectingThread();
        }
        object = this.emptyCondition;
        synchronized (object) {
            while (!this.connections.isEmpty()) {
                try {
                    this.emptyCondition.wait();
                }
                catch (InterruptedException e) {
                    LOG.trace("Interrupted while waiting on all connections to be closed.");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        return this.call(rpcKind, rpcRequest, remoteId, 0, fallbackToSimpleAuth, null);
    }

    public Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        return this.call(rpcKind, rpcRequest, remoteId, 0, fallbackToSimpleAuth, alignmentContext);
    }

    private void checkAsyncCall() throws IOException {
        if (Client.isAsynchronousMode() && this.asyncCallCounter.incrementAndGet() > this.maxAsyncCalls) {
            this.asyncCallCounter.decrementAndGet();
            String errMsg = String.format("Exceeded limit of max asynchronous calls: %d, please configure %s to adjust it.", this.maxAsyncCalls, "ipc.client.async.calls.max");
            throw new AsyncCallLimitExceededException(errMsg);
        }
    }

    Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId, int serviceClass, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        return this.call(rpcKind, rpcRequest, remoteId, serviceClass, fallbackToSimpleAuth, null);
    }

    Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId, int serviceClass, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        final Call call = this.createCall(rpcKind, rpcRequest);
        call.setAlignmentContext(alignmentContext);
        final Connection connection = this.getConnection(remoteId, call, serviceClass, fallbackToSimpleAuth);
        try {
            this.checkAsyncCall();
            try {
                connection.sendRpcRequest(call);
            }
            catch (RejectedExecutionException e) {
                throw new IOException("connection has been closed", e);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                InterruptedIOException ioe = new InterruptedIOException("Interrupted waiting to send RPC request to server");
                ioe.initCause(ie);
                throw ioe;
            }
        }
        catch (Exception e) {
            if (Client.isAsynchronousMode()) {
                this.releaseAsyncCall();
            }
            throw e;
        }
        if (Client.isAsynchronousMode()) {
            AsyncGet<Writable, IOException> asyncGet = new AsyncGet<Writable, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Writable get(long timeout, TimeUnit unit) throws IOException, TimeoutException {
                    boolean done = true;
                    try {
                        Writable w = Client.this.getRpcResponse(call, connection, timeout, unit);
                        if (w == null) {
                            done = false;
                            throw new TimeoutException(call + " timed out " + timeout + " " + (Object)((Object)unit));
                        }
                        Writable writable = w;
                        return writable;
                    }
                    finally {
                        if (done) {
                            Client.this.releaseAsyncCall();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isDone() {
                    Call call2 = call;
                    synchronized (call2) {
                        return call.done;
                    }
                }
            };
            ASYNC_RPC_RESPONSE.set((AsyncGet<? extends Writable, IOException>)asyncGet);
            return null;
        }
        return this.getRpcResponse(call, connection, -1L, null);
    }

    @InterfaceStability.Unstable
    public static boolean isAsynchronousMode() {
        return asynchronousMode.get();
    }

    @InterfaceStability.Unstable
    public static void setAsynchronousMode(boolean async) {
        asynchronousMode.set(async);
    }

    private void releaseAsyncCall() {
        this.asyncCallCounter.decrementAndGet();
    }

    @VisibleForTesting
    int getAsyncCallCount() {
        return this.asyncCallCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Writable getRpcResponse(Call call, Connection connection, long timeout, TimeUnit unit) throws IOException {
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    AsyncGet.Util.wait(call, timeout, unit);
                    if (timeout < 0L || call.done) continue;
                    return null;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Call interrupted");
                }
            }
            if (call.error == null) {
                return call.getRpcResponse();
            }
            if (call.error instanceof RemoteException) {
                call.error.fillInStackTrace();
                throw call.error;
            }
            InetSocketAddress address = connection.getRemoteAddress();
            throw NetUtils.wrapException(address.getHostName(), address.getPort(), NetUtils.getHostname(), 0, call.error);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    Set<ConnectionId> getConnectionIds() {
        return this.connections.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(ConnectionId remoteId, Call call, int serviceClass, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Connection connection;
        Consumer<Connection> removeMethod = c -> {
            boolean removed = this.connections.remove(remoteId, c);
            if (removed && this.connections.isEmpty()) {
                Object object = this.emptyCondition;
                synchronized (object) {
                    this.emptyCondition.notify();
                }
            }
        };
        while (true) {
            Object object = this.putLock;
            synchronized (object) {
                if (!this.running.get()) {
                    throw new IOException("Failed to get connection for " + remoteId + ", " + call + ": " + this + " is already stopped");
                }
                connection = this.connections.computeIfAbsent(remoteId, id -> new Connection((ConnectionId)id, serviceClass, removeMethod));
            }
            if (connection.addCall(call)) break;
            removeMethod.accept(connection);
        }
        connection.setupIOstreams(fallbackToSimpleAuth);
        return connection;
    }

    public static int nextCallId() {
        return callIdCounter.getAndIncrement() & Integer.MAX_VALUE;
    }

    @Override
    @InterfaceStability.Unstable
    public void close() throws Exception {
        this.stop();
    }

    @InterfaceAudience.Private
    public static class IpcStreams
    implements Closeable,
    Flushable {
        private DataInputStream in;
        public DataOutputStream out;
        private int maxResponseLength;
        private boolean firstResponse = true;

        IpcStreams(Socket socket, int maxResponseLength) throws IOException {
            this.maxResponseLength = maxResponseLength;
            this.setInputStream(new BufferedInputStream(NetUtils.getInputStream(socket)));
            this.setOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(socket)));
        }

        void setSaslClient(SaslRpcClient client) throws IOException {
            this.setInputStream(new BufferedInputStream(client.getInputStream(this.in)));
            this.setOutputStream(client.getOutputStream(this.out));
        }

        private void setInputStream(InputStream is) {
            this.in = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        }

        private void setOutputStream(OutputStream os) {
            this.out = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        }

        public ByteBuffer readResponse() throws IOException {
            int length = this.in.readInt();
            if (this.firstResponse) {
                this.firstResponse = false;
                if (length == -1) {
                    this.in.readInt();
                    throw new RemoteException(WritableUtils.readString(this.in), WritableUtils.readString(this.in));
                }
            }
            if (length <= 0) {
                throw new RpcException("RPC response has invalid length");
            }
            if (this.maxResponseLength > 0 && length > this.maxResponseLength) {
                throw new RpcException("RPC response exceeds maximum data length");
            }
            ByteBuffer bb = ByteBuffer.allocate(length);
            this.in.readFully(bb.array());
            return bb;
        }

        public void sendRequest(byte[] buf) throws IOException {
            this.out.write(buf);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() {
            IOUtils.closeStream(this.out);
            IOUtils.closeStream(this.in);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Evolving
    public static class ConnectionId {
        private InetSocketAddress address;
        private final UserGroupInformation ticket;
        private final Class<?> protocol;
        private static final int PRIME = 16777619;
        private final int rpcTimeout;
        private final int maxIdleTime;
        private final RetryPolicy connectionRetryPolicy;
        private final int maxRetriesOnSasl;
        private final int maxRetriesOnSocketTimeouts;
        private final boolean tcpNoDelay;
        private final boolean tcpLowLatency;
        private final boolean doPing;
        private final int pingInterval;
        private String saslQop;
        private final Configuration conf;

        public ConnectionId(InetSocketAddress address, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, RetryPolicy connectionRetryPolicy, Configuration conf) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
            this.connectionRetryPolicy = connectionRetryPolicy;
            this.maxIdleTime = conf.getInt("ipc.client.connection.maxidletime", 10000);
            this.maxRetriesOnSasl = conf.getInt("ipc.client.connect.max.retries.on.sasl", 5);
            this.maxRetriesOnSocketTimeouts = conf.getInt("ipc.client.connect.max.retries.on.timeouts", 45);
            this.tcpNoDelay = conf.getBoolean("ipc.client.tcpnodelay", true);
            this.tcpLowLatency = conf.getBoolean("ipc.client.low-latency", false);
            this.doPing = conf.getBoolean("ipc.client.ping", true);
            this.pingInterval = this.doPing ? Client.getPingInterval(conf) : 0;
            this.conf = conf;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        void setAddress(InetSocketAddress address) {
            if (!Objects.equals(this.address.getHostName(), address.getHostName())) {
                throw new IllegalArgumentException("Hostname must match: " + this.address + " vs " + address);
            }
            if (this.address.getPort() != address.getPort()) {
                throw new IllegalArgumentException("Port must match: " + this.address + " vs " + address);
            }
            this.address = address;
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        int getRpcTimeout() {
            return this.rpcTimeout;
        }

        int getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public int getMaxRetriesOnSasl() {
            return this.maxRetriesOnSasl;
        }

        public int getMaxRetriesOnSocketTimeouts() {
            return this.maxRetriesOnSocketTimeouts;
        }

        boolean getTcpNoDelay() {
            return this.tcpNoDelay;
        }

        boolean getTcpLowLatency() {
            return this.tcpLowLatency;
        }

        boolean getDoPing() {
            return this.doPing;
        }

        int getPingInterval() {
            return this.pingInterval;
        }

        RetryPolicy getRetryPolicy() {
            return this.connectionRetryPolicy;
        }

        @VisibleForTesting
        String getSaslQop() {
            return this.saslQop;
        }

        static ConnectionId getConnectionId(InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, RetryPolicy connectionRetryPolicy, Configuration conf) throws IOException {
            if (connectionRetryPolicy == null) {
                int max = conf.getInt("ipc.client.connect.max.retries", 10);
                int retryInterval = conf.getInt("ipc.client.connect.retry.interval", 1000);
                connectionRetryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(max, retryInterval, TimeUnit.MILLISECONDS);
            }
            return new ConnectionId(addr, protocol, ticket, rpcTimeout, connectionRetryPolicy, conf);
        }

        static boolean isEqual(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ConnectionId) {
                ConnectionId that = (ConnectionId)obj;
                return ConnectionId.isEqual(this.address, that.address) && this.doPing == that.doPing && this.maxIdleTime == that.maxIdleTime && ConnectionId.isEqual(this.connectionRetryPolicy, that.connectionRetryPolicy) && this.pingInterval == that.pingInterval && ConnectionId.isEqual(this.protocol, that.protocol) && this.rpcTimeout == that.rpcTimeout && this.tcpNoDelay == that.tcpNoDelay && ConnectionId.isEqual(this.ticket, that.ticket);
            }
            return false;
        }

        public int hashCode() {
            int result = this.connectionRetryPolicy.hashCode();
            result = 16777619 * result + (this.address == null || this.address.getHostName() == null ? 0 : this.address.getHostName().hashCode());
            result = 16777619 * result + (this.address == null ? 0 : this.address.getPort());
            result = 16777619 * result + (this.doPing ? 1231 : 1237);
            result = 16777619 * result + this.maxIdleTime;
            result = 16777619 * result + this.pingInterval;
            result = 16777619 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 16777619 * result + this.rpcTimeout;
            result = 16777619 * result + (this.tcpNoDelay ? 1231 : 1237);
            result = 16777619 * result + (this.ticket == null ? 0 : this.ticket.hashCode());
            return result;
        }

        public String toString() {
            return this.address.toString();
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress server;
        private final ConnectionId remoteId;
        private RpcAuthMethod authMethod;
        private Server.AuthProtocol authProtocol;
        private int serviceClass;
        private SaslRpcClient saslRpcClient;
        private Socket socket = null;
        private IpcStreams ipcStreams;
        private final int maxResponseLength;
        private final int rpcTimeout;
        private int maxIdleTime;
        private final RetryPolicy connectionRetryPolicy;
        private final int maxRetriesOnSasl;
        private int maxRetriesOnSocketTimeouts;
        private final boolean tcpNoDelay;
        private final boolean tcpLowLatency;
        private final boolean doPing;
        private final int pingInterval;
        private final int soTimeout;
        private byte[] pingRequest;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private AtomicLong lastActivity = new AtomicLong();
        private AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;
        private final Thread rpcRequestThread;
        private final SynchronousQueue<Pair<Call, ResponseBuffer>> rpcRequestQueue = new SynchronousQueue(true);
        private AtomicReference<Thread> connectingThread = new AtomicReference();
        private final Consumer<Connection> removeMethod;

        Connection(ConnectionId remoteId, int serviceClass, Consumer<Connection> removeMethod) {
            this.remoteId = remoteId;
            this.server = remoteId.getAddress();
            this.rpcRequestThread = new Thread((Runnable)new RpcRequestSender(), "IPC Parameter Sending Thread for " + remoteId);
            this.rpcRequestThread.setDaemon(true);
            this.maxResponseLength = remoteId.conf.getInt("ipc.maximum.response.length", 0x8000000);
            this.rpcTimeout = remoteId.getRpcTimeout();
            this.maxIdleTime = remoteId.getMaxIdleTime();
            this.connectionRetryPolicy = remoteId.connectionRetryPolicy;
            this.maxRetriesOnSasl = remoteId.getMaxRetriesOnSasl();
            this.maxRetriesOnSocketTimeouts = remoteId.getMaxRetriesOnSocketTimeouts();
            this.tcpNoDelay = remoteId.getTcpNoDelay();
            this.tcpLowLatency = remoteId.getTcpLowLatency();
            this.doPing = remoteId.getDoPing();
            if (this.doPing) {
                ResponseBuffer buf = new ResponseBuffer();
                RpcHeaderProtos.RpcRequestHeaderProto pingHeader = ProtoUtil.makeRpcRequestHeader(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, -4, -1, Client.this.clientId);
                try {
                    pingHeader.writeDelimitedTo(buf);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write to buf for " + remoteId + " in " + Client.this + " due to " + e, e);
                }
                this.pingRequest = buf.toByteArray();
            }
            this.pingInterval = remoteId.getPingInterval();
            this.soTimeout = this.rpcTimeout > 0 ? (this.doPing && this.pingInterval < this.rpcTimeout ? this.pingInterval : this.rpcTimeout) : this.pingInterval;
            this.serviceClass = serviceClass;
            this.removeMethod = removeMethod;
            if (LOG.isDebugEnabled()) {
                LOG.debug("The ping interval is " + this.pingInterval + " ms.");
            }
            UserGroupInformation ticket = remoteId.getTicket();
            boolean trySasl = UserGroupInformation.isSecurityEnabled() || ticket != null && !ticket.getTokens().isEmpty();
            this.authProtocol = trySasl ? Server.AuthProtocol.SASL : Server.AuthProtocol.NONE;
            this.authMethod = RpcAuthRegistry.SIMPLE;
            this.setName("IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + this.server.toString() + " from " + (ticket == null ? "an unknown user" : ticket.getUserName()));
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(Time.now());
        }

        private synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod.shouldReLogin() && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals(currentUser) || loginUser.equals(realUser));
        }

        private synchronized RpcAuthMethod setupSaslConnection(IpcStreams streams) throws IOException {
            this.saslRpcClient = new SaslRpcClient(this.remoteId.getTicket(), this.remoteId.getProtocol(), this.remoteId.getAddress(), this.remoteId.conf);
            return this.saslRpcClient.saslConnect(streams);
        }

        private synchronized boolean updateAddress() throws IOException {
            InetSocketAddress currentAddr = NetUtils.createSocketAddrForHost(this.server.getHostName(), this.server.getPort());
            if (!this.server.equals(currentAddr)) {
                LOG.warn("Address change detected. Old: " + this.server.toString() + " New: " + currentAddr.toString());
                this.server = currentAddr;
                this.remoteId.setAddress(currentAddr);
                UserGroupInformation ticket = this.remoteId.getTicket();
                this.setName("IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + this.server.toString() + " from " + (ticket == null ? "an unknown user" : ticket.getUserName()));
                return true;
            }
            return false;
        }

        private synchronized void setupConnection(UserGroupInformation ticket) throws IOException {
            LOG.debug("Setup connection to " + this.server.toString());
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    String principal;
                    String host;
                    InetAddress localAddr;
                    KerberosInfo krbInfo;
                    if (this.server.isUnresolved()) {
                        throw NetUtils.wrapException(this.server.getHostName(), this.server.getPort(), NetUtils.getHostname(), 0, new UnknownHostException());
                    }
                    this.socket = Client.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(this.tcpNoDelay);
                    this.socket.setKeepAlive(true);
                    if (this.tcpLowLatency) {
                        this.socket.setTrafficClass(20);
                        this.socket.setPerformancePreferences(1, 2, 0);
                    }
                    SocketAddress bindAddr = null;
                    if (ticket != null && ticket.hasKerberosCredentials() && (krbInfo = this.remoteId.getProtocol().getAnnotation(KerberosInfo.class)) != null && (localAddr = NetUtils.getLocalInetAddress(host = SecurityUtil.getHostFromPrincipal(principal = ticket.getUserName()))) != null) {
                        this.socket.setReuseAddress(true);
                        localAddr = NetUtils.bindToLocalAddress(localAddr, Client.this.bindToWildCardAddress);
                        LOG.debug("Binding {} to {}", (Object)principal, Client.this.bindToWildCardAddress ? "0.0.0.0" : localAddr);
                        this.socket.bind(new InetSocketAddress(localAddr, 0));
                    }
                    NetUtils.connect(this.socket, this.server, bindAddr, Client.this.connectionTimeout);
                    this.socket.setSoTimeout(this.soTimeout);
                    return;
                }
                catch (ConnectTimeoutException toe) {
                    if (this.updateAddress()) {
                        ioFailures = 0;
                        timeoutFailures = 0;
                    }
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionTimeout(n, this.maxRetriesOnSocketTimeouts, toe);
                    continue;
                }
                catch (IOException ie) {
                    if (this.updateAddress()) {
                        ioFailures = 0;
                        timeoutFailures = 0;
                        try {
                            int n = ioFailures;
                            ioFailures = (short)(ioFailures + 1);
                            this.handleConnectionFailure(n, ie);
                        }
                        catch (IOException ioe) {
                            LOG.warn("Exception when handle ConnectionFailure: " + ioe.getMessage());
                        }
                        continue;
                    }
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, ie);
                    continue;
                }
                break;
            }
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation ugi) throws IOException, InterruptedException {
            ugi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException, LoginException {
                    int MAX_BACKOFF = 5000;
                    Connection.this.closeConnection();
                    Connection.this.disposeSasl();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Exception encountered while connecting to the server : " + ex);
                            }
                            Connection.this.authMethod.reLogin();
                            Thread.sleep(rand.nextInt(5000) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.remoteId;
                        LOG.warn(msg, ex);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    if (ex instanceof InterruptedIOException) {
                        LOG.debug("Exception encountered while connecting to the server", ex);
                    } else {
                        LOG.warn("Exception encountered while connecting to the server ", ex);
                    }
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    throw new IOException(ex);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void setupIOstreams(AtomicBoolean fallbackToSimpleAuth) {
            try {
                Span span;
                block20: {
                    UserGroupInformation realUser;
                    if (this.socket != null || this.shouldCloseConnection.get()) {
                        this.setFallBackToSimpleAuth(fallbackToSimpleAuth);
                        return;
                    }
                    UserGroupInformation ticket = this.remoteId.getTicket();
                    if (ticket != null && (realUser = ticket.getRealUser()) != null) {
                        ticket = realUser;
                    }
                    this.connectingThread.set(Thread.currentThread());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Connecting to " + this.server);
                    }
                    if ((span = Tracer.getCurrentSpan()) != null) {
                        span.addTimelineAnnotation("IPC client connecting to " + this.server);
                    }
                    int numRetries = 0;
                    Random rand = null;
                    while (true) {
                        this.setupConnection(ticket);
                        this.ipcStreams = new IpcStreams(this.socket, this.maxResponseLength);
                        this.writeConnectionHeader(this.ipcStreams);
                        if (this.authProtocol != Server.AuthProtocol.SASL) break block20;
                        try {
                            this.authMethod = ticket.doAs(new PrivilegedExceptionAction<RpcAuthMethod>(){

                                @Override
                                public RpcAuthMethod run() throws IOException, InterruptedException {
                                    return Connection.this.setupSaslConnection(Connection.this.ipcStreams);
                                }
                            });
                        }
                        catch (IOException ex) {
                            if (this.saslRpcClient == null) {
                                throw ex;
                            }
                            KerberosUtil.checkJCEKeyStrength();
                            this.authMethod = this.saslRpcClient.getAuthMethod();
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, this.maxRetriesOnSasl, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (!this.authMethod.equals(RpcAuthRegistry.SIMPLE)) {
                        this.ipcStreams.setSaslClient(this.saslRpcClient);
                        this.remoteId.saslQop = (String)this.saslRpcClient.getNegotiatedProperty("javax.security.sasl.qop");
                        LOG.debug("Negotiated QOP is :" + this.remoteId.saslQop);
                    }
                    this.setFallBackToSimpleAuth(fallbackToSimpleAuth);
                }
                if (this.doPing) {
                    this.ipcStreams.setInputStream(new PingInputStream(this.ipcStreams.in));
                }
                this.writeConnectionContext(this.remoteId, this.authMethod);
                this.touch();
                span = Tracer.getCurrentSpan();
                if (span != null) {
                    span.addTimelineAnnotation("IPC client connected to " + this.server);
                }
                this.start();
                return;
            }
            catch (Throwable t2) {
                if (t2 instanceof IOException) {
                    this.markClosed((IOException)t2);
                } else {
                    this.markClosed(new IOException("Couldn't set up IO streams: " + t2, t2));
                }
                this.close();
            }
            finally {
                this.connectingThread.set(null);
            }
        }

        private void setFallBackToSimpleAuth(AtomicBoolean fallbackToSimpleAuth) throws AccessControlException {
            if (this.authMethod == null || this.authProtocol != Server.AuthProtocol.SASL) {
                if (this.authProtocol == Server.AuthProtocol.SASL) {
                    LOG.trace("Auth method is not set, yield from setting auth fallback.");
                }
                return;
            }
            if (fallbackToSimpleAuth == null) {
                LOG.trace("Connection {} will skip to set fallbackToSimpleAuth as it is null.", (Object)this.remoteId);
            } else if (fallbackToSimpleAuth.get()) {
                return;
            }
            if (!this.authMethod.equals(RpcAuthRegistry.SIMPLE)) {
                if (fallbackToSimpleAuth != null) {
                    LOG.trace("Disabling fallbackToSimpleAuth, target does not use SIMPLE authentication.");
                    fallbackToSimpleAuth.set(false);
                }
            } else if (UserGroupInformation.isSecurityEnabled()) {
                if (!Client.this.fallbackAllowed) {
                    throw new AccessControlException("Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.");
                }
                if (fallbackToSimpleAuth != null) {
                    LOG.trace("Enabling fallbackToSimpleAuth for target, as we are allowed to fall back.");
                    fallbackToSimpleAuth.set(true);
                }
            }
        }

        private void closeConnection() {
            if (this.socket == null) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn("Not able to close a socket", e);
            }
            this.socket = null;
        }

        private void handleConnectionTimeout(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            LOG.info("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s); maxRetries=" + maxRetries);
        }

        private void handleConnectionFailure(int curRetries, IOException ioe) throws IOException {
            RetryPolicy.RetryAction action;
            this.closeConnection();
            try {
                action = this.connectionRetryPolicy.shouldRetry(ioe, curRetries, 0, true);
            }
            catch (Exception e) {
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
            if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                if (action.reason != null && LOG.isDebugEnabled()) {
                    LOG.debug("Failed to connect to server: " + this.server + ": " + action.reason, ioe);
                }
                throw ioe;
            }
            if (Thread.currentThread().isInterrupted()) {
                LOG.warn("Interrupted while trying for connection");
                throw ioe;
            }
            try {
                Thread.sleep(action.delayMillis);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted: action=" + action + ", retry policy=" + this.connectionRetryPolicy).initCause(e);
            }
            LOG.info("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s); retry policy is " + this.connectionRetryPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeConnectionHeader(IpcStreams streams) throws IOException {
            DataOutputStream out;
            DataOutputStream dataOutputStream = out = streams.out;
            synchronized (dataOutputStream) {
                out.write(RpcConstants.HEADER.array());
                out.write(9);
                out.write(this.serviceClass);
                out.write(this.authProtocol.callId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeConnectionContext(ConnectionId remoteId, RpcAuthMethod authMethod) throws IOException {
            IpcConnectionContextProtos.IpcConnectionContextProto message = ProtoUtil.makeIpcConnectionContext(RPC.getProtocolName(remoteId.getProtocol()), remoteId.getTicket(), authMethod);
            RpcHeaderProtos.RpcRequestHeaderProto connectionContextHeader = ProtoUtil.makeRpcRequestHeader(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, -3, -1, Client.this.clientId);
            ResponseBuffer buf = new ResponseBuffer();
            connectionContextHeader.writeDelimitedTo(buf);
            message.writeDelimitedTo(buf);
            DataOutputStream dataOutputStream = this.ipcStreams.out;
            synchronized (dataOutputStream) {
                this.ipcStreams.sendRequest(buf.toByteArray());
            }
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get() && (timeout = (long)this.maxIdleTime - (Time.now() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    LOG.trace("Interrupted while waiting to retrieve RPC response.");
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sendPing() throws IOException {
            long curTime = Time.now();
            if (curTime - this.lastActivity.get() >= (long)this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.ipcStreams.out;
                synchronized (dataOutputStream) {
                    this.ipcStreams.sendRequest(this.pingRequest);
                    this.ipcStreams.flush();
                }
            }
        }

        @Override
        public void run() {
            this.rpcRequestThread.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + ": starting, having connections " + Client.this.connections.size());
            }
            try {
                while (this.waitForWork()) {
                    this.receiveRpcResponse();
                }
            }
            catch (Throwable t2) {
                LOG.warn("Unexpected error reading responses on connection " + this, t2);
                this.markClosed(new IOException("Error reading responses", t2));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + ": stopped, remaining connections " + Client.this.connections.size());
            }
        }

        public void sendRpcRequest(Call call) throws InterruptedException, IOException {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            RpcHeaderProtos.RpcRequestHeaderProto header = ProtoUtil.makeRpcRequestHeader(call.rpcKind, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, call.id, call.retry, Client.this.clientId, call.alignmentContext);
            ResponseBuffer buf = new ResponseBuffer();
            header.writeDelimitedTo(buf);
            RpcWritable.wrap(call.rpcRequest).writeTo(buf);
            while (!this.shouldCloseConnection.get() && !this.rpcRequestQueue.offer(Pair.of(call, buf), 1L, TimeUnit.SECONDS)) {
            }
        }

        private void receiveRpcResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status;
                ByteBuffer bb = this.ipcStreams.readResponse();
                RpcWritable.Buffer packet = RpcWritable.Buffer.wrap(bb);
                RpcHeaderProtos.RpcResponseHeaderProto header = packet.getValue(RpcHeaderProtos.RpcResponseHeaderProto.getDefaultInstance());
                Client.this.checkResponse(header);
                int callId = header.getCallId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + " got value #" + callId);
                }
                if ((status = header.getStatus()) == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS) {
                    Writable value = (Writable)packet.newInstance(Client.this.valueClass, Client.this.conf);
                    Call call = this.calls.remove(callId);
                    call.setRpcResponse(value);
                    if (call.alignmentContext != null) {
                        call.alignmentContext.receiveResponseState(header);
                    }
                }
                if (packet.remaining() > 0) {
                    throw new RpcClientException("RPC response length mismatch");
                }
                if (status != RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS) {
                    RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto erCode;
                    String exceptionClassName = header.hasExceptionClassName() ? header.getExceptionClassName() : "ServerDidNotSetExceptionClassName";
                    String errorMsg = header.hasErrorMsg() ? header.getErrorMsg() : "ServerDidNotSetErrorMsg";
                    RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto rpcErrorCodeProto = erCode = header.hasErrorDetail() ? header.getErrorDetail() : null;
                    if (erCode == null) {
                        LOG.warn("Detailed error code not set by server on rpc error");
                    }
                    RemoteException re = new RemoteException(exceptionClassName, errorMsg, erCode);
                    if (status == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR) {
                        Call call = this.calls.remove(callId);
                        call.setException(re);
                    } else if (status == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL) {
                        this.markClosed(re);
                    }
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        private void interruptConnectingThread() {
            Thread connThread = this.connectingThread.get();
            if (connThread != null) {
                connThread.interrupt();
            }
        }

        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error("The connection is not in the closed state");
                return;
            }
            this.removeMethod.accept(this);
            IOUtils.closeStream(this.ipcStreams);
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn("A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("closing ipc connection to " + this.server + ": " + this.closeException.getMessage(), this.closeException);
                }
                this.cleanupCalls();
            }
            this.closeConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + ": closed");
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                itor.remove();
                c.setException(this.closeException);
            }
        }

        private class RpcRequestSender
        implements Runnable {
            private RpcRequestSender() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Connection.this.shouldCloseConnection.get()) {
                    ResponseBuffer buf = null;
                    try {
                        Pair pair = (Pair)Connection.this.rpcRequestQueue.poll(Connection.this.maxIdleTime, TimeUnit.MILLISECONDS);
                        if (pair == null || Connection.this.shouldCloseConnection.get()) continue;
                        buf = (ResponseBuffer)pair.getRight();
                        DataOutputStream dataOutputStream = ((Connection)Connection.this).ipcStreams.out;
                        synchronized (dataOutputStream) {
                            if (LOG.isDebugEnabled()) {
                                Call call = (Call)pair.getLeft();
                                LOG.debug(Connection.this.getName() + "{} sending #{} {}", Connection.this.getName(), call.id, call.rpcRequest);
                            }
                            Connection.this.ipcStreams.sendRequest(buf.toByteArray());
                            Connection.this.ipcStreams.flush();
                        }
                        IOUtils.closeStream(buf);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    catch (IOException e) {
                        Connection.this.markClosed(e);
                    }
                    finally {
                        IOUtils.closeStream(buf);
                    }
                }
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e, int waiting) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !Client.this.running.get() || 0 < Connection.this.rpcTimeout && Connection.this.rpcTimeout <= waiting) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                int waiting = 0;
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e, waiting += Connection.this.soTimeout);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                int waiting = 0;
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e, waiting += Connection.this.soTimeout);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    static class Call {
        final int id;
        final int retry;
        final Writable rpcRequest;
        Writable rpcResponse;
        IOException error;
        final RPC.RpcKind rpcKind;
        boolean done;
        private final Object externalHandler;
        private AlignmentContext alignmentContext;

        private Call(RPC.RpcKind rpcKind, Writable param) {
            this.rpcKind = rpcKind;
            this.rpcRequest = param;
            Integer id = (Integer)callId.get();
            if (id == null) {
                this.id = Client.nextCallId();
            } else {
                callId.set(null);
                this.id = id;
            }
            Integer rc = (Integer)retryCount.get();
            this.retry = rc == null ? 0 : rc;
            this.externalHandler = EXTERNAL_CALL_HANDLER.get();
        }

        public String toString() {
            return this.getClass().getSimpleName() + this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
            if (this.externalHandler != null) {
                Object object = this.externalHandler;
                synchronized (object) {
                    this.externalHandler.notify();
                }
            }
        }

        public synchronized void setAlignmentContext(AlignmentContext ac) {
            this.alignmentContext = ac;
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setRpcResponse(Writable rpcResponse) {
            this.rpcResponse = rpcResponse;
            this.callComplete();
        }

        public synchronized Writable getRpcResponse() {
            return this.rpcResponse;
        }
    }
}

