/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.ConfServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.AdminAuthorizedServlet;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HadoopCoreAuthenticationFilterInitializer;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpRequestLog;
import org.apache.hadoop.http.NoCacheFilter;
import org.apache.hadoop.http.PrometheusServlet;
import org.apache.hadoop.http.WebServlet;
import org.apache.hadoop.jmx.JMXJsonServlet;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.sink.PrometheusMetricsSink;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.FileMonitoringTimerTask;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.SymlinkAllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class HttpServer2
implements FilterContainer {
    public static final Logger LOG = LoggerFactory.getLogger(HttpServer2.class);
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String HTTP_MAX_REQUEST_HEADER_SIZE_KEY = "hadoop.http.max.request.header.size";
    public static final int HTTP_MAX_REQUEST_HEADER_SIZE_DEFAULT = 65536;
    public static final String HTTP_MAX_RESPONSE_HEADER_SIZE_KEY = "hadoop.http.max.response.header.size";
    public static final int HTTP_MAX_RESPONSE_HEADER_SIZE_DEFAULT = 65536;
    public static final String HTTP_SOCKET_BACKLOG_SIZE_KEY = "hadoop.http.socket.backlog.size";
    public static final int HTTP_SOCKET_BACKLOG_SIZE_DEFAULT = 128;
    public static final String HTTP_MAX_THREADS_KEY = "hadoop.http.max.threads";
    public static final String HTTP_ACCEPTOR_COUNT_KEY = "hadoop.http.acceptor.count";
    public static final int HTTP_ACCEPTOR_COUNT_DEFAULT = -1;
    public static final String HTTP_SELECTOR_COUNT_KEY = "hadoop.http.selector.count";
    public static final int HTTP_SELECTOR_COUNT_DEFAULT = -1;
    public static final String HTTP_IDLE_TIMEOUT_MS_KEY = "hadoop.http.idle_timeout.ms";
    public static final int HTTP_IDLE_TIMEOUT_MS_DEFAULT = 60000;
    public static final String HTTP_TEMP_DIR_KEY = "hadoop.http.temp.dir";
    public static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    public static final String HTTP_SNI_HOST_CHECK_ENABLED_KEY = "hadoop.http.sni.host.check.enabled";
    public static final boolean HTTP_SNI_HOST_CHECK_ENABLED_DEFAULT = false;
    public static final String CONF_CONTEXT_ATTRIBUTE = "hadoop.conf";
    public static final String ADMINS_ACL = "admins.acl";
    public static final String SPNEGO_FILTER = "authentication";
    public static final String NO_CACHE_FILTER = "NoCacheFilter";
    public static final String BIND_ADDRESS = "bind.address";
    private final AccessControlList adminsAcl;
    protected final Server webServer;
    private final HandlerCollection handlers;
    private final List<ServerConnector> listeners = Lists.newArrayList();
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Configuration.IntegerRanges portRanges;
    private final Map<ServletContextHandler, Boolean> defaultContexts = new HashMap<ServletContextHandler, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    static final String STATE_DESCRIPTION_ALIVE = " - alive";
    static final String STATE_DESCRIPTION_NOT_LIVE = " - not live";
    private final SignerSecretProvider secretProvider;
    private static final Properties headers = new Properties();
    private final Optional<Timer> configurationChangeMonitor;
    private XFrameOption xFrameOption;
    private boolean xFrameOptionIsEnabled;
    public static final String HTTP_HEADER_PREFIX = "hadoop.http.header.";
    private static final String HTTP_HEADER_REGEX = "hadoop\\.http\\.header\\.([a-zA-Z\\-_]+)";
    static final String X_XSS_PROTECTION = "X-XSS-Protection:1; mode=block";
    static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options:nosniff";
    private static final String X_FRAME_OPTIONS = "X-FRAME-OPTIONS";
    private static final Pattern PATTERN_HTTP_HEADER_REGEX = Pattern.compile("hadoop\\.http\\.header\\.([a-zA-Z\\-_]+)");
    private boolean prometheusSupport;
    protected static final String PROMETHEUS_SINK = "PROMETHEUS_SINK";
    private PrometheusMetricsSink prometheusMetricsSink;

    private HttpServer2(Builder b) throws IOException {
        String appDir = this.getWebAppsPath(b.name);
        this.webServer = new Server();
        this.adminsAcl = b.adminsAcl;
        this.handlers = new HandlerCollection();
        this.webAppContext = HttpServer2.createWebAppContext(b, this.adminsAcl, appDir);
        this.xFrameOptionIsEnabled = b.xFrameEnabled;
        this.xFrameOption = b.xFrameOption;
        this.configurationChangeMonitor = b.configurationChangeMonitor;
        try {
            this.secretProvider = HttpServer2.constructSecretProvider(b, this.webAppContext.getServletContext());
            this.webAppContext.getServletContext().setAttribute("signer.secret.provider.object", this.secretProvider);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.findPort = b.findPort;
        this.portRanges = b.portRanges;
        this.initializeWebServer(b.name, b.hostName, b.conf, b.pathSpecs);
    }

    private void initializeWebServer(String name, String hostName, Configuration conf, String[] pathSpecs) throws IOException {
        Preconditions.checkNotNull(this.webAppContext);
        int maxThreads = conf.getInt(HTTP_MAX_THREADS_KEY, -1);
        QueuedThreadPool threadPool = (QueuedThreadPool)this.webServer.getThreadPool();
        threadPool.setDaemon(true);
        if (maxThreads != -1) {
            threadPool.setMaxThreads(maxThreads);
        }
        SessionHandler handler = this.webAppContext.getSessionHandler();
        handler.setHttpOnly(true);
        handler.getSessionCookieConfig().setSecure(true);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLog requestLog = HttpRequestLog.getRequestLog(name);
        this.handlers.addHandler(contexts);
        if (requestLog != null) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(requestLog);
            this.handlers.addHandler(requestLogHandler);
        }
        this.handlers.addHandler(this.webAppContext);
        String appDir = this.getWebAppsPath(name);
        this.addDefaultApps(contexts, appDir, conf);
        this.webServer.setHandler(this.handlers);
        Map<String, String> xFrameParams = this.setHeaders(conf);
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), xFrameParams);
        FilterInitializer[] initializers = HttpServer2.getFilterInitializers(conf);
        if (initializers != null) {
            conf = new Configuration(conf);
            conf.set(BIND_ADDRESS, hostName);
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets();
        this.readHeaders(conf);
        this.addPrometheusServlet(conf);
    }

    private void readHeaders(Configuration conf) throws IOException {
        File headersConf;
        String fileName = conf.get("hadoop.webapps.custom.headers.path");
        if (fileName != null && !fileName.isEmpty() && (headersConf = new File(fileName)).exists()) {
            headers.loadFromXML(new FileInputStream(headersConf));
            LOG.info("Loaded headers from file: " + headersConf.getAbsolutePath());
        }
    }

    private void addPrometheusServlet(Configuration conf) {
        this.prometheusSupport = conf.getBoolean("hadoop.prometheus.endpoint.enabled", false);
        if (this.prometheusSupport) {
            this.prometheusMetricsSink = new PrometheusMetricsSink();
            this.getWebAppContext().getServletContext().setAttribute(PROMETHEUS_SINK, this.prometheusMetricsSink);
            this.addServlet("prometheus", "/prom", PrometheusServlet.class);
        }
    }

    private void addListener(ServerConnector connector) {
        this.listeners.add(connector);
    }

    private static WebAppContext createWebAppContext(Builder b, AccessControlList adminsAcl, String appDir) {
        WebAppContext ctx = new WebAppContext();
        ctx.setDefaultsDescriptor(null);
        ServletHolder holder = new ServletHolder(new WebServlet());
        ImmutableMap<String, String> params = ImmutableMap.builder().put("acceptRanges", "true").put("dirAllowed", "false").put("gzip", "true").put("useFileMappedBuffer", "true").build();
        holder.setInitParameters(params);
        ctx.setWelcomeFiles(new String[]{"index.html"});
        ctx.addServlet(holder, "/");
        ctx.setDisplayName(b.name);
        ctx.setContextPath("/");
        ctx.setWar(appDir + "/" + b.name);
        String tempDirectory = b.conf.get(HTTP_TEMP_DIR_KEY);
        if (tempDirectory != null && !tempDirectory.isEmpty()) {
            ctx.setTempDirectory(new File(tempDirectory));
            ctx.setAttribute("javax.servlet.context.tempdir", tempDirectory);
        }
        ctx.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, b.conf);
        ctx.getServletContext().setAttribute(ADMINS_ACL, adminsAcl);
        HttpServer2.addNoCacheFilter(ctx);
        return ctx;
    }

    private static SignerSecretProvider constructSecretProvider(Builder b, ServletContext ctx) throws Exception {
        Configuration conf = b.conf;
        Properties config = HttpServer2.getFilterProperties(conf, b.authFilterConfigurationPrefix);
        return AuthenticationFilter.constructSecretProvider(ctx, config, b.disallowFallbackToRandomSignerSecretProvider);
    }

    private static Properties getFilterProperties(Configuration conf, String prefix) {
        Properties prop = new Properties();
        Map<String, String> filterConfig = AuthenticationFilterInitializer.getFilterConfigMap(conf, prefix);
        prop.putAll(filterConfig);
        return prop;
    }

    private static void addNoCacheFilter(ServletContextHandler ctxt) {
        HttpServer2.defineFilter(ctxt, NO_CACHE_FILTER, NoCacheFilter.class.getName(), Collections.emptyMap(), new String[]{"/*"});
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class<?>[] classes = conf.getClasses(FILTER_INITIALIZER_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        ArrayList classList = new ArrayList(Arrays.asList(classes));
        if (classList.contains(AuthenticationFilterInitializer.class) && classList.contains(ProxyUserAuthenticationFilterInitializer.class)) {
            classList.remove(AuthenticationFilterInitializer.class);
        }
        FilterInitializer[] initializers = new FilterInitializer[classList.size()];
        for (int i = 0; i < classList.size(); ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance((Class)classList.get(i), conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir, Configuration conf) throws IOException {
        Map<String, String> params;
        String logDir = System.getProperty("hadoop.log.dir");
        boolean logsEnabled = conf.getBoolean("hadoop.http.logs.enabled", true);
        if (logDir != null && logsEnabled) {
            ServletContextHandler logContext = new ServletContextHandler(parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(AdminAuthorizedServlet.class, "/*");
            if (conf.getBoolean("hadoop.jetty.logs.serve.aliases", true)) {
                params = logContext.getInitParams();
                params.put("org.eclipse.jetty.servlet.Default.aliases", "true");
            }
            logContext.setDisplayName("logs");
            SessionHandler handler = new SessionHandler();
            handler.setHttpOnly(true);
            handler.getSessionCookieConfig().setSecure(true);
            logContext.setSessionHandler(handler);
            logContext.addAliasCheck(new SymlinkAllowedResourceAliasChecker(logContext));
            this.setContextAttributes(logContext, conf);
            HttpServer2.addNoCacheFilter(logContext);
            this.defaultContexts.put(logContext, true);
        }
        ServletContextHandler staticContext = new ServletContextHandler(parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(WebServlet.class, "/*");
        staticContext.setDisplayName("static");
        params = staticContext.getInitParams();
        params.put("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        params.put("org.eclipse.jetty.servlet.Default.gzip", "true");
        SessionHandler handler = new SessionHandler();
        handler.setHttpOnly(true);
        handler.getSessionCookieConfig().setSecure(true);
        staticContext.setSessionHandler(handler);
        staticContext.addAliasCheck(new SymlinkAllowedResourceAliasChecker(staticContext));
        this.setContextAttributes(staticContext, conf);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(ServletContextHandler context, Configuration conf) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, conf);
        context.getServletContext().setAttribute(ADMINS_ACL, this.adminsAcl);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
    }

    public void addContext(ServletContextHandler ctxt, boolean isFiltered) {
        this.handlers.addHandler(ctxt);
        HttpServer2.addNoCacheFilter(ctxt);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec) {
        this.addJerseyResourcePackage(packageName, pathSpec, Collections.emptyMap());
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec, Map<String, String> params) {
        LOG.info("addJerseyResourcePackage: packageName=" + packageName + ", pathSpec=" + pathSpec);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", packageName);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sh.setInitParameter(entry.getKey(), entry.getValue());
        }
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        ServletMapping[] servletMappings = this.webAppContext.getServletHandler().getServletMappings();
        for (int i = 0; i < servletMappings.length; ++i) {
            if (!servletMappings[i].containsPathSpec(pathSpec)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found existing " + servletMappings[i].getServletName() + " servlet at path " + pathSpec + "; will replace mapping with " + holder.getName() + " servlet");
            }
            ServletMapping[] newServletMappings = ArrayUtil.removeFromArray(servletMappings, servletMappings[i]);
            this.webAppContext.getServletHandler().setServletMappings(newServletMappings);
            break;
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, Map<String, String> params) {
        ServletHolder sh = new ServletHolder(clazz);
        sh.setName(name);
        sh.setInitParameters(params);
        ServletMapping[] servletMappings = this.webAppContext.getServletHandler().getServletMappings();
        for (int i = 0; i < servletMappings.length; ++i) {
            if (!servletMappings[i].containsPathSpec(pathSpec)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found existing " + servletMappings[i].getServletName() + " servlet at path " + pathSpec + "; will replace mapping with " + sh.getName() + " servlet");
            }
            ServletMapping[] newServletMappings = ArrayUtil.removeFromArray(servletMappings, servletMappings[i]);
            this.webAppContext.getServletHandler().setServletMappings(newServletMappings);
            break;
        }
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addHandlerAtFront(Handler handler) {
        Handler[] h2 = ArrayUtil.prependToArray(handler, this.handlers.getHandlers(), Handler.class);
        this.handlers.setHandlers(h2);
    }

    public void addHandlerAtEnd(Handler handler) {
        this.handlers.addHandler(handler);
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        String[] userFacingUrls = new String[]{"/", "/*"};
        FilterMapping fmap = HttpServer2.getFilterMapping(name, userFacingUrls);
        HttpServer2.defineFilter(this.webAppContext, filterHolder, fmap);
        LOG.info("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName());
        String[] ALL_URLS = new String[]{"/*"};
        fmap = HttpServer2.getFilterMapping(name, ALL_URLS);
        for (Map.Entry<ServletContextHandler, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            ServletContextHandler ctx = e.getKey();
            HttpServer2.defineFilter(ctx, filterHolder, fmap);
            LOG.info("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName());
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        FilterMapping fmap = HttpServer2.getFilterMapping(name, ALL_URLS);
        HttpServer2.defineFilter(this.webAppContext, filterHolder, fmap);
        for (ServletContextHandler ctx : this.defaultContexts.keySet()) {
            HttpServer2.defineFilter(ctx, filterHolder, fmap);
        }
        LOG.info("Added global filter '" + name + "' (class=" + classname + ")");
    }

    public static void defineFilter(ServletContextHandler ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        FilterMapping fmap = HttpServer2.getFilterMapping(name, urls);
        HttpServer2.defineFilter(ctx, filterHolder, fmap);
    }

    private static void defineFilter(ServletContextHandler ctx, FilterHolder holder, FilterMapping fmap) {
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    private static FilterMapping getFilterMapping(String name, String[] urls) {
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(31);
        fmap.setFilterName(name);
        return fmap;
    }

    private static FilterHolder getFilterHolder(String name, String classname, Map<String, String> parameters) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        if (parameters != null) {
            holder.setInitParameters(parameters);
        }
        return holder;
    }

    protected void addFilterPathMapping(String pathSpec, ServletContextHandler webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(31);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    protected String getWebAppsPath(String appName) throws FileNotFoundException {
        URL resourceUrl = null;
        File webResourceDevLocation = new File("src/main/webapps", appName);
        if (webResourceDevLocation.exists()) {
            LOG.info("Web server is in development mode. Resources will be read from the source tree.");
            try {
                resourceUrl = webResourceDevLocation.getParentFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FileNotFoundException("Mailformed URL while finding the web resource dir:" + e.getMessage());
            }
        } else {
            resourceUrl = this.getClass().getClassLoader().getResource("webapps/" + appName);
            if (resourceUrl == null) {
                throw new FileNotFoundException("webapps/" + appName + " not found in CLASSPATH");
            }
        }
        String urlString = resourceUrl.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    @Deprecated
    public int getPort() {
        return ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
    }

    public InetSocketAddress getConnectorAddress(int index) {
        Preconditions.checkArgument(index >= 0);
        if (index > this.webServer.getConnectors().length) {
            return null;
        }
        ServerConnector c = (ServerConnector)this.webServer.getConnectors()[index];
        if (c.getLocalPort() == -1 || c.getLocalPort() == -2) {
            return null;
        }
        return new InetSocketAddress(c.getHost(), c.getLocalPort());
    }

    public void setThreads(int min2, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min2);
        pool.setMaxThreads(max);
    }

    private void initSpnego(Configuration conf, String hostName, String usernameConfKey, String keytabConfKey) throws IOException {
        String httpKeytab;
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = conf.get(usernameConfKey);
        if (principalInConf != null && !principalInConf.isEmpty()) {
            params.put("kerberos.principal", SecurityUtil.getServerPrincipal(principalInConf, hostName));
        }
        if ((httpKeytab = conf.get(keytabConfKey)) != null && !httpKeytab.isEmpty()) {
            params.put("kerberos.keytab", httpKeytab);
        }
        params.put("type", "kerberos");
        HttpServer2.defineFilter(this.webAppContext, SPNEGO_FILTER, AuthenticationFilter.class.getName(), params, null);
    }

    public void start() throws IOException {
        try {
            Handler[] hs;
            try {
                this.openListeners();
                this.webServer.start();
                if (this.prometheusSupport) {
                    DefaultMetricsSystem.instance().register("prometheus", "Hadoop metrics prometheus exporter", this.prometheusMetricsSink);
                }
            }
            catch (IOException ex) {
                LOG.info("HttpServer.start() threw a non Bind IOException", ex);
                throw ex;
            }
            catch (MultiException ex) {
                LOG.info("HttpServer.start() threw a MultiException", ex);
                throw ex;
            }
            for (Handler handler : hs = this.webServer.getHandlers()) {
                if (!handler.isFailed()) continue;
                throw new IOException("Problem in starting http server. Server handlers failed");
            }
            Throwable unavailableException = this.webAppContext.getUnavailableException();
            if (unavailableException != null) {
                this.webServer.stop();
                throw new IOException("Unable to initialize WebAppContext", unavailableException);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted while starting HTTP server").initCause(e);
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    private void loadListeners() {
        for (Connector connector : this.listeners) {
            this.webServer.addConnector(connector);
        }
    }

    private static void bindListener(ServerConnector listener) throws Exception {
        listener.close();
        listener.open();
        LOG.info("Jetty bound to port " + listener.getLocalPort());
    }

    private static BindException constructBindException(ServerConnector listener, IOException ex) {
        BindException be = new BindException("Port in use: " + listener.getHost() + ":" + listener.getPort());
        if (ex != null) {
            be.initCause(ex);
        }
        return be;
    }

    private void bindForSinglePort(ServerConnector listener, int port) throws Exception {
        while (true) {
            try {
                HttpServer2.bindListener(listener);
            }
            catch (IOException ex) {
                if (port == 0 || !this.findPort) {
                    throw HttpServer2.constructBindException(listener, ex);
                }
                listener.setPort(++port);
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    private void bindForPortRange(ServerConnector listener, int startPort) throws Exception {
        IOException ioException = null;
        try {
            HttpServer2.bindListener(listener);
            return;
        }
        catch (IOException ex) {
            ioException = ex;
            for (Integer port : this.portRanges) {
                if (port == startPort) continue;
                Thread.sleep(100L);
                listener.setPort(port);
                try {
                    HttpServer2.bindListener(listener);
                    return;
                }
                catch (IOException ex2) {
                    if (!(ex2 instanceof BindException) && !(ex2.getCause() instanceof BindException)) {
                        throw ex2;
                    }
                    ioException = ex2;
                }
            }
            throw HttpServer2.constructBindException(listener, ioException);
        }
    }

    void openListeners() throws Exception {
        LOG.debug("opening listeners: {}", (Object)this.listeners);
        for (ServerConnector listener : this.listeners) {
            if (listener.getLocalPort() != -1 && listener.getLocalPort() != -2) continue;
            int port = listener.getPort();
            if (this.portRanges != null && port != 0) {
                this.bindForPortRange(listener, port);
                continue;
            }
            this.bindForSinglePort(listener, port);
        }
    }

    public void stop() throws Exception {
        MultiException exception = null;
        if (this.configurationChangeMonitor.isPresent()) {
            try {
                this.configurationChangeMonitor.get().cancel();
            }
            catch (Exception e) {
                LOG.error("Error while canceling configuration monitoring timer for webapp" + this.webAppContext.getDisplayName(), e);
                exception = this.addMultiException(exception, e);
            }
        }
        for (ServerConnector c : this.listeners) {
            try {
                c.close();
            }
            catch (Exception e) {
                LOG.error("Error while stopping listener for webapp" + this.webAppContext.getDisplayName(), e);
                exception = this.addMultiException(exception, e);
            }
        }
        try {
            this.secretProvider.destroy();
            this.webAppContext.clearAttributes();
            this.webAppContext.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web app context for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web server for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        if (exception != null) {
            exception.ifExceptionThrow();
        }
    }

    private MultiException addMultiException(MultiException exception, Exception e) {
        if (exception == null) {
            exception = new MultiException();
        }
        exception.add(e);
        return exception;
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public boolean isAlive() {
        return this.webServer != null && this.webServer.isStarted();
    }

    public String toString() {
        Preconditions.checkState(!this.listeners.isEmpty());
        StringBuilder sb = new StringBuilder("HttpServer (").append(this.isAlive() ? STATE_DESCRIPTION_ALIVE : STATE_DESCRIPTION_NOT_LIVE).append("), listening at:");
        for (ServerConnector l : this.listeners) {
            sb.append(l.getHost()).append(":").append(l.getPort()).append("/,");
        }
        return sb.toString();
    }

    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer2.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(403, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer2.userHasAdministratorAccess(servletContext, remoteUser)) {
            response.sendError(403, "Unauthenticated users are not authorized to access this page.");
            LOG.warn("User " + remoteUser + " is unauthorized to access the page " + request.getRequestURI() + ".");
            return false;
        }
        return true;
    }

    public static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser(remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    private Map<String, String> setHeaders(Configuration conf) {
        HashMap<String, String> xFrameParams = new HashMap<String, String>();
        Map<String, String> headerConfigMap = conf.getValByRegex(HTTP_HEADER_REGEX);
        xFrameParams.putAll(this.getDefaultHeaders());
        if (this.xFrameOptionIsEnabled) {
            xFrameParams.put("hadoop.http.header.X-FRAME-OPTIONS", this.xFrameOption.toString());
        }
        xFrameParams.putAll(headerConfigMap);
        return xFrameParams;
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] splitVal = X_CONTENT_TYPE_OPTIONS.split(":");
        headers.put(HTTP_HEADER_PREFIX + splitVal[0], splitVal[1]);
        splitVal = X_XSS_PROTECTION.split(":");
        headers.put(HTTP_HEADER_PREFIX + splitVal[0], splitVal[1]);
        return headers;
    }

    public static enum XFrameOption {
        DENY("DENY"),
        SAMEORIGIN("SAMEORIGIN"),
        ALLOWFROM("ALLOW-FROM");

        private final String name;

        private XFrameOption(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static XFrameOption getEnum(String value) {
            Preconditions.checkState(value != null && !value.isEmpty());
            for (XFrameOption xoption : XFrameOption.values()) {
                if (!value.equals(xoption.toString())) continue;
                return xoption;
            }
            throw new IllegalArgumentException("Unexpected value in xFrameOption.");
        }
    }

    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;
        private Map<String, String> headerMap;

        @Override
        public void init(FilterConfig config) throws ServletException {
            this.config = config;
            this.initHttpHeaderMap();
        }

        @Override
        public void destroy() {
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (String headerName : headers.stringPropertyNames()) {
                httpResponse.addHeader(headerName, headers.getProperty(headerName));
            }
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            this.headerMap.forEach((k, v) -> httpResponse.addHeader((String)k, (String)v));
            chain.doFilter(quoted, httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ServletContextHandler.Context sContext = (ServletContextHandler.Context)this.config.getServletContext();
            String mime = sContext.getMimeType(path);
            return mime == null ? null : mime;
        }

        private void initHttpHeaderMap() {
            Enumeration<String> params = this.config.getInitParameterNames();
            this.headerMap = new HashMap<String, String>();
            while (params.hasMoreElements()) {
                String key = params.nextElement();
                Matcher m4 = PATTERN_HTTP_HEADER_REGEX.matcher(key);
                if (!m4.matches()) continue;
                String headerKey = m4.group(1);
                this.headerMap.put(headerKey, this.config.getInitParameter(key));
            }
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            @Override
            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            @Override
            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            @Override
            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            @Override
            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map<String, String[]> raw = this.rawRequest.getParameterMap();
                for (Map.Entry<String, String[]> item : raw.entrySet()) {
                    String[] rawValue = item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars(item.getKey()), cookedValue);
                }
                return result;
            }

            @Override
            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            @Override
            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        @Override
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer2.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            response.setContentType("text/plain; charset=UTF-8");
            try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
                ReflectionUtils.printThreadInfo(out, "");
            }
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }

    public static class Builder {
        private ArrayList<URI> endpoints = Lists.newArrayList();
        private String name;
        private Configuration conf;
        private Configuration sslConf;
        private String[] pathSpecs;
        private AccessControlList adminsAcl;
        private boolean securityEnabled = false;
        private String usernameConfKey;
        private String keytabConfKey;
        private boolean needsClientAuth;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String keyPassword;
        private boolean findPort;
        private Configuration.IntegerRanges portRanges = null;
        private String hostName;
        private boolean disallowFallbackToRandomSignerSecretProvider;
        private String authFilterConfigurationPrefix = "hadoop.http.authentication.";
        private String excludeCiphers;
        private boolean xFrameEnabled;
        private XFrameOption xFrameOption = XFrameOption.SAMEORIGIN;
        private boolean sniHostCheckEnabled;
        private Optional<Timer> configurationChangeMonitor = Optional.empty();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addEndpoint(URI endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder trustStore(String location, String password, String type) {
            this.trustStore = location;
            this.trustStorePassword = password;
            this.trustStoreType = type;
            return this;
        }

        public Builder keyStore(String location, String password, String type) {
            this.keyStore = location;
            this.keyStorePassword = password;
            this.keyStoreType = type;
            return this;
        }

        public Builder keyPassword(String password) {
            this.keyPassword = password;
            return this;
        }

        public Builder needsClientAuth(boolean value) {
            this.needsClientAuth = value;
            return this;
        }

        public Builder setFindPort(boolean findPort) {
            this.findPort = findPort;
            return this;
        }

        public Builder setPortRanges(Configuration.IntegerRanges ranges) {
            this.portRanges = ranges;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setSSLConf(Configuration sslCnf) {
            this.sslConf = sslCnf;
            return this;
        }

        public Builder setPathSpec(String[] pathSpec) {
            this.pathSpecs = pathSpec;
            return this;
        }

        public Builder setACL(AccessControlList acl) {
            this.adminsAcl = acl;
            return this;
        }

        public Builder setSecurityEnabled(boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
            return this;
        }

        public Builder setUsernameConfKey(String usernameConfKey) {
            this.usernameConfKey = usernameConfKey;
            return this;
        }

        public Builder setKeytabConfKey(String keytabConfKey) {
            this.keytabConfKey = keytabConfKey;
            return this;
        }

        public Builder disallowFallbackToRandomSingerSecretProvider(boolean value) {
            this.disallowFallbackToRandomSignerSecretProvider = value;
            return this;
        }

        public Builder authFilterConfigurationPrefix(String value) {
            this.authFilterConfigurationPrefix = value;
            return this;
        }

        public Builder excludeCiphers(String pExcludeCiphers) {
            this.excludeCiphers = pExcludeCiphers;
            return this;
        }

        public Builder configureXFrame(boolean xFrameEnabled) {
            this.xFrameEnabled = xFrameEnabled;
            return this;
        }

        public Builder setXFrameOption(String option) {
            this.xFrameOption = XFrameOption.getEnum(option);
            return this;
        }

        public Builder setSniHostCheckEnabled(boolean sniHostCheckEnabled) {
            this.sniHostCheckEnabled = sniHostCheckEnabled;
            return this;
        }

        private static String getPasswordString(Configuration conf, String name) throws IOException {
            char[] passchars = conf.getPassword(name);
            if (passchars == null) {
                return null;
            }
            return new String(passchars);
        }

        private void loadSSLConfiguration() throws IOException {
            if (this.sslConf == null) {
                return;
            }
            this.needsClientAuth = this.sslConf.getBoolean("ssl.server.need.client.auth", false);
            this.keyStore = this.sslConf.getTrimmed("ssl.server.keystore.location");
            if (this.keyStore == null || this.keyStore.isEmpty()) {
                throw new IOException(String.format("Property %s not specified", "ssl.server.keystore.location"));
            }
            this.keyStorePassword = Builder.getPasswordString(this.sslConf, "ssl.server.keystore.password");
            if (this.keyStorePassword == null) {
                throw new IOException(String.format("Property %s not specified", "ssl.server.keystore.password"));
            }
            this.keyStoreType = this.sslConf.get("ssl.server.keystore.type", "jks");
            this.keyPassword = Builder.getPasswordString(this.sslConf, "ssl.server.keystore.keypassword");
            this.trustStore = this.sslConf.get("ssl.server.truststore.location");
            this.trustStorePassword = Builder.getPasswordString(this.sslConf, "ssl.server.truststore.password");
            this.trustStoreType = this.sslConf.get("ssl.server.truststore.type", "jks");
            this.excludeCiphers = this.sslConf.get("ssl.server.exclude.cipher.list");
        }

        public HttpServer2 build() throws IOException {
            Preconditions.checkNotNull(this.name, "name is not set");
            Preconditions.checkState(!this.endpoints.isEmpty(), "No endpoints specified");
            if (this.hostName == null) {
                this.hostName = this.endpoints.get(0).getHost();
            }
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            HttpServer2 server = new HttpServer2(this);
            if (this.securityEnabled) {
                HadoopCoreAuthenticationFilterInitializer initializer = new HadoopCoreAuthenticationFilterInitializer();
                ((FilterInitializer)initializer).initFilter(server, this.conf);
            }
            for (URI ep : this.endpoints) {
                if (!HttpServer2.HTTPS_SCHEME.equals(ep.getScheme())) continue;
                this.loadSSLConfiguration();
                break;
            }
            int requestHeaderSize = this.conf.getInt(HttpServer2.HTTP_MAX_REQUEST_HEADER_SIZE_KEY, 65536);
            int responseHeaderSize = this.conf.getInt(HttpServer2.HTTP_MAX_RESPONSE_HEADER_SIZE_KEY, 65536);
            int idleTimeout = this.conf.getInt(HttpServer2.HTTP_IDLE_TIMEOUT_MS_KEY, 60000);
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setRequestHeaderSize(requestHeaderSize);
            httpConfig.setResponseHeaderSize(responseHeaderSize);
            httpConfig.setSendServerVersion(false);
            int backlogSize = this.conf.getInt(HttpServer2.HTTP_SOCKET_BACKLOG_SIZE_KEY, 128);
            if (!this.sniHostCheckEnabled) {
                this.sniHostCheckEnabled = this.conf.getBoolean(HttpServer2.HTTP_SNI_HOST_CHECK_ENABLED_KEY, false);
            }
            for (URI ep : this.endpoints) {
                ServerConnector connector;
                String scheme = ep.getScheme();
                if (HttpServer2.HTTP_SCHEME.equals(scheme)) {
                    connector = this.createHttpChannelConnector(server.webServer, httpConfig);
                } else if (HttpServer2.HTTPS_SCHEME.equals(scheme)) {
                    connector = this.createHttpsChannelConnector(server.webServer, httpConfig);
                } else {
                    throw new HadoopIllegalArgumentException("unknown scheme for endpoint:" + ep);
                }
                connector.setHost(ep.getHost());
                connector.setPort(ep.getPort() == -1 ? 0 : ep.getPort());
                connector.setAcceptQueueSize(backlogSize);
                connector.setIdleTimeout(idleTimeout);
                server.addListener(connector);
            }
            server.loadListeners();
            return server;
        }

        private ServerConnector createHttpChannelConnector(Server server, HttpConfiguration httpConfig) {
            ServerConnector conn = new ServerConnector(server, this.conf.getInt(HttpServer2.HTTP_ACCEPTOR_COUNT_KEY, -1), this.conf.getInt(HttpServer2.HTTP_SELECTOR_COUNT_KEY, -1));
            HttpConnectionFactory connFactory = new HttpConnectionFactory(httpConfig);
            conn.addConnectionFactory(connFactory);
            if (Shell.WINDOWS) {
                conn.setReuseAddress(false);
            }
            return conn;
        }

        private ServerConnector createHttpsChannelConnector(Server server, HttpConfiguration httpConfig) {
            httpConfig.setSecureScheme(HttpServer2.HTTPS_SCHEME);
            httpConfig.addCustomizer(new SecureRequestCustomizer(this.sniHostCheckEnabled));
            ServerConnector conn = this.createHttpChannelConnector(server, httpConfig);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            if (this.keyStoreType.equalsIgnoreCase("bcfks")) {
                Security.addProvider(new BouncyCastleFipsProvider());
                Security.addProvider(new BouncyCastleJsseProvider());
                sslContextFactory.setProvider("BCJSSE");
            }
            sslContextFactory.setNeedClientAuth(this.needsClientAuth);
            if (this.keyPassword != null) {
                sslContextFactory.setKeyManagerPassword(this.keyPassword);
            }
            if (this.keyStore != null) {
                sslContextFactory.setKeyStorePath(this.keyStore);
                sslContextFactory.setKeyStoreType(this.keyStoreType);
                if (this.keyStorePassword != null) {
                    sslContextFactory.setKeyStorePassword(this.keyStorePassword);
                }
            }
            if (this.trustStore != null) {
                sslContextFactory.setTrustStorePath(this.trustStore);
                sslContextFactory.setTrustStoreType(this.trustStoreType);
                if (this.trustStorePassword != null) {
                    sslContextFactory.setTrustStorePassword(this.trustStorePassword);
                }
            }
            if (null != this.excludeCiphers && !this.excludeCiphers.isEmpty()) {
                sslContextFactory.setExcludeCipherSuites(StringUtils.getTrimmedStrings(this.excludeCiphers));
                LOG.info("Excluded Cipher List:" + this.excludeCiphers);
            }
            this.setEnabledProtocols(sslContextFactory);
            long storesReloadInterval = this.conf.getLong("ssl.{0}.stores.reload.interval", 10000L);
            if (storesReloadInterval > 0L && (this.keyStore != null || this.trustStore != null)) {
                this.configurationChangeMonitor = Optional.of(this.makeConfigurationChangeMonitor(storesReloadInterval, sslContextFactory));
            }
            conn.addFirstConnectionFactory(new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()));
            return conn;
        }

        private Timer makeConfigurationChangeMonitor(long reloadInterval, SslContextFactory.Server sslContextFactory) {
            Timer timer = new Timer("SSL Certificates Store Monitor", true);
            ArrayList<Path> locations = new ArrayList<Path>();
            if (this.keyStore != null) {
                locations.add(Paths.get(this.keyStore, new String[0]));
            }
            if (this.trustStore != null) {
                locations.add(Paths.get(this.trustStore, new String[0]));
            }
            timer.schedule((TimerTask)new FileMonitoringTimerTask(locations, path -> {
                LOG.info("Reloading keystore and truststore certificates.");
                try {
                    sslContextFactory.reload(factory -> {});
                }
                catch (Exception ex) {
                    LOG.error("Failed to reload SSL keystore and truststore certificates", ex);
                }
            }, null), reloadInterval, reloadInterval);
            return timer;
        }

        private void setEnabledProtocols(SslContextFactory sslContextFactory) {
            String enabledProtocols = this.conf.get("hadoop.ssl.enabled.protocols", "TLSv1.2");
            if (!enabledProtocols.equals("TLSv1.2")) {
                String[] jettyExcludedProtocols = sslContextFactory.getExcludeProtocols();
                String[] enabledProtocolsArray = StringUtils.getTrimmedStrings(enabledProtocols);
                List<String> enabledProtocolsList = Arrays.asList(enabledProtocolsArray);
                ArrayList<String> resetExcludedProtocols = new ArrayList<String>();
                for (String jettyExcludedProtocol : jettyExcludedProtocols) {
                    if (!enabledProtocolsList.contains(jettyExcludedProtocol)) {
                        resetExcludedProtocols.add(jettyExcludedProtocol);
                        continue;
                    }
                    LOG.debug("Removed {} from exclude protocol list", (Object)jettyExcludedProtocol);
                }
                sslContextFactory.setExcludeProtocols(resetExcludedProtocols.toArray(new String[0]));
                LOG.info("Reset exclude protocol list: {}", (Object)resetExcludedProtocols);
                sslContextFactory.setIncludeProtocols(enabledProtocolsArray);
                LOG.info("Enabled protocols: {}", (Object)enabledProtocols);
            }
        }
    }
}

