/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.writer;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JacksonRootStrippingGenerator
extends JsonGenerator {
    final JsonGenerator generator;
    int depth = 0;
    boolean isClosed = false;
    final int treshold;

    private JacksonRootStrippingGenerator() {
        this(null, 1);
    }

    private JacksonRootStrippingGenerator(JsonGenerator generator) {
        this(generator, 1);
    }

    private JacksonRootStrippingGenerator(JsonGenerator generator, int treshold) {
        this.generator = generator;
        this.treshold = treshold;
    }

    public static JsonGenerator createRootStrippingGenerator(JsonGenerator g2) {
        return new JacksonRootStrippingGenerator(g2);
    }

    public static JsonGenerator createRootStrippingGenerator(JsonGenerator g2, int threshold) {
        return new JacksonRootStrippingGenerator(g2, threshold);
    }

    @Deprecated
    public void enableFeature(JsonGenerator.Feature feature) {
        this.enableFeature(feature);
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        return this.generator.enable(feature);
    }

    @Deprecated
    public void disableFeature(JsonGenerator.Feature feature) {
        this.disable(feature);
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        return this.generator.disable(feature);
    }

    @Deprecated
    public void setFeature(JsonGenerator.Feature feature, boolean enabled) {
        if (enabled) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
    }

    @Deprecated
    public boolean isFeatureEnabled(JsonGenerator.Feature feature) {
        return this.isEnabled(feature);
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature f) {
        return this.generator.isEnabled(f);
    }

    @Override
    public int getFeatureMask() {
        return 0;
    }

    @Override
    public JsonGenerator setFeatureMask(int i) {
        return null;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        if (this.depth > this.treshold - 1) {
            this.generator.writeStartObject();
        }
        ++this.depth;
    }

    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        if (this.depth > this.treshold) {
            this.generator.writeEndObject();
        }
        --this.depth;
    }

    @Override
    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        if (this.depth > this.treshold) {
            this.generator.writeFieldName(name);
        }
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
    }

    @Override
    public void writeString(String s2) throws IOException, JsonGenerationException {
        this.generator.writeString(s2);
    }

    @Override
    public void writeString(char[] text, int start, int length) throws IOException, JsonGenerationException {
        this.generator.writeString(text, start, length);
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
    }

    @Override
    public void writeRawUTF8String(byte[] bytes, int start, int length) throws IOException, JsonGenerationException {
        this.generator.writeRawUTF8String(bytes, start, length);
    }

    @Override
    public void writeUTF8String(byte[] bytes, int start, int length) throws IOException, JsonGenerationException {
        this.generator.writeUTF8String(bytes, start, length);
    }

    @Override
    public void writeRaw(String raw) throws IOException, JsonGenerationException {
        this.generator.writeRaw(raw);
    }

    @Override
    public void writeRaw(String raw, int start, int length) throws IOException, JsonGenerationException {
        this.generator.writeRaw(raw, start, length);
    }

    @Override
    public void writeRaw(char[] raw, int start, int count) throws IOException, JsonGenerationException {
        this.generator.writeRaw(raw, start, count);
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.generator.writeRaw(c);
    }

    @Override
    public void writeBinary(Base64Variant variant, byte[] bytes, int start, int count) throws IOException, JsonGenerationException {
        this.generator.writeBinary(variant, bytes, start, count);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int i) throws IOException {
        return 0;
    }

    @Override
    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this.generator.writeNumber(i);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this.generator.writeNumber(l);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this.generator.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.generator.writeNumber(f);
    }

    @Override
    public void writeNumber(BigDecimal bd) throws IOException, JsonGenerationException {
        this.generator.writeNumber(bd);
    }

    @Override
    public void writeNumber(String number) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.generator.writeNumber(number);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException, JsonGenerationException {
        this.generator.writeBoolean(b);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this.generator.writeNull();
    }

    @Override
    public void copyCurrentEvent(JsonParser parser) throws IOException, JsonProcessingException {
        this.generator.copyCurrentEvent(parser);
    }

    @Override
    public void copyCurrentStructure(JsonParser parser) throws IOException, JsonProcessingException {
        this.generator.copyCurrentStructure(parser);
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
        this.isClosed = true;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec codec) {
        return this.generator.setCodec(codec);
    }

    @Override
    public ObjectCodec getCodec() {
        return this.generator.getCodec();
    }

    @Override
    public Version version() {
        return null;
    }

    @Override
    public void writeRawValue(String rawString) throws IOException, JsonGenerationException {
        this.generator.writeRawValue(rawString);
    }

    @Override
    public void writeRawValue(String rawString, int startIndex, int length) throws IOException, JsonGenerationException {
        this.generator.writeRawValue(rawString, startIndex, length);
    }

    @Override
    public void writeRawValue(char[] rawChars, int startIndex, int length) throws IOException, JsonGenerationException {
        this.generator.writeRawValue(rawChars, startIndex, length);
    }

    @Override
    public void writeNumber(BigInteger number) throws IOException, JsonGenerationException {
        this.generator.writeNumber(number);
    }

    @Override
    public void writeObject(Object o) throws IOException, JsonProcessingException {
        this.generator.writeObject(o);
    }

    @Override
    public void writeTree(TreeNode node) throws IOException {
        this.generator.writeTree(node);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.generator.getOutputContext();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

